/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.miginfocom.swing.MigLayout;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.layout.PreferredGridLayout;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ColumnLayout;
import oracle.javatools.ui.ExtendedTextField;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.SeparatorListCellRenderer;
import oracle.javatools.ui.TextLayer;
import oracle.javatools.ui.TitledSeparator;
import oracle.javatools.ui.TransparentBorderComponent;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.TruncatingTreeCellRenderer;
import oracle.javatools.ui.border.ShadowBorder;
import oracle.javatools.ui.combo.JCheckCombo;
import oracle.javatools.ui.combo.JFixListCombo;
import oracle.javatools.ui.combo.JTreeCombo;
import oracle.javatools.ui.combo.JTreeFixListCombo;
import oracle.javatools.ui.completion.CompletionTextField;
import oracle.javatools.ui.completion.CompletionTextFieldWithDrop;
import oracle.javatools.ui.completion.StringCompletionProvider;
import oracle.javatools.ui.internal.SearchFieldHarness;
import oracle.javatools.ui.internal.UICDataTipDemoPanel;
import oracle.javatools.ui.internal.UICDateDemoPanel;
import oracle.javatools.ui.internal.UICTableDemoPanel;
import oracle.javatools.ui.internal.UIDemoCheckBoxPanel;
import oracle.javatools.ui.layout.VerticalFlowLayout;
import oracle.javatools.ui.plaf.FlatTabbedPaneUI;
import oracle.javatools.ui.search.TextComponentSearchSupport;
import org.jdesktop.jxlayer.JXLayer;

public class UICDemo {
    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        UIManager.put("Button.borderPaintsFocus", Boolean.FALSE);
        JFrame f = new JFrame("UIC Demo");
        f.setDefaultCloseOperation(3);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setUI(new FlatTabbedPaneUI());
        tabbedPane.setTabPlacement(2);
        SearchFieldHarness sfh = new SearchFieldHarness();
        tabbedPane.addTab("Search", OracleIcons.getIcon((String)"find.png"), sfh);
        tabbedPane.addTab("Vertical Headers", OracleIcons.getIcon((String)"label.png"), UICDemo.createVertHeaderPanel());
        tabbedPane.addTab("Shadow Border", OracleIcons.getIcon((String)"label.png"), UICDemo.createShadowBorderPanel());
        tabbedPane.addTab("Truncating Tree", OracleIcons.getIcon((String)"structure.png"), UICDemo.createTruncatingTreeRenderer());
        tabbedPane.addTab("Headers", OracleIcons.getIcon((String)"listview.png"), UICDemo.createHeaders());
        tabbedPane.addTab("Create Dialogs", OracleIcons.getIcon((String)"new.png"), UICDemo.createCreateDialogs());
        tabbedPane.addTab("Rich Hint Label", OracleIcons.getIcon((String)"label.png"), UICDemo.createRichHintLabel());
        tabbedPane.addTab("Bug 5998458", OracleIcons.getIcon((String)"debug.png"), UICDemo.createBug5998458());
        tabbedPane.addTab("Text Search", OracleIcons.getIcon((String)"text.png"), UICDemo.createTextSearch());
        tabbedPane.addTab("Extended Text", OracleIcons.getIcon((String)"text.png"), UICDemo.createExtended());
        tabbedPane.addTab("Completions", OracleIcons.getIcon((String)"text.png"), UICDemo.createCompletions());
        tabbedPane.addTab("Resizeable Components", OracleIcons.getIcon((String)"component.png"), UICDemo.createResizeables());
        tabbedPane.addTab("OverlayLabel", OracleIcons.getIcon((String)"component.png"), UICDemo.createOverlayLabel());
        tabbedPane.addTab("Rich Combos", OracleIcons.getIcon((String)"structure.png"), UICDemo.createCombos());
        tabbedPane.addTab("Calendar and Dates", OracleIcons.getIcon((String)"chooseDate.png"), UICDemo.createCalendar());
        tabbedPane.addTab("Checkboxes", OracleIcons.getIcon((String)"check.png"), new UIDemoCheckBoxPanel());
        tabbedPane.addTab("GenericTable", OracleIcons.getIcon((String)"table.png"), new UICTableDemoPanel());
        tabbedPane.addTab("DataTips", OracleIcons.getIcon((String)"info.png"), new UICDataTipDemoPanel(f));
        tabbedPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        f.setContentPane(tabbedPane);
        f.setPreferredSize(new Dimension(800, 500));
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    private static Component createTextSearch() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        final JTextPane a = new JTextPane();
        p.add((Component)new JScrollPane(a), "Center");
        p.add(Box.createVerticalStrut(150), "North");
        JButton search = new JButton("Search");
        p.add((Component)search, "South");
        p.add(Box.createHorizontalStrut(150), "East");
        p.add(Box.createHorizontalStrut(150), "West");
        search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new TextComponentSearchSupport(a).showSearchPrompt();
            }
        });
        return p;
    }

    private static Component createBug5998458() {
        TransparentPanel p = new TransparentPanel();
        p.setLayout(new BorderLayout());
        final JTabbedPane pane = new JTabbedPane();
        pane.setUI(new FlatTabbedPaneUI());
        p.add((Component)pane, "Center");
        JButton b = new JButton("Rebuild tabs");
        p.add((Component)b, "South");
        for (int i = 0; i < 10; ++i) {
            pane.addTab("Tab " + i, new JPanel());
        }
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pane.removeAll();
                pane.addTab("Single Tab", new JPanel());
            }
        });
        return p;
    }

    private static Component createRichHintLabel() {
        final TransparentPanel p = new TransparentPanel();
        JSplitPane split = new JSplitPane();
        split.setOrientation(0);
        split.setTopComponent(new JLabel("Hello"));
        RichHintLabel label = new RichHintLabel();
        label.setHtmlText("This is a <a href=\"http:test\">test</a> label with some long text to see how it deals with wrapping in a scroll pane.");
        JScrollPane pane = new JScrollPane(label);
        pane.setVerticalScrollBarPolicy(22);
        pane.setHorizontalScrollBarPolicy(31);
        split.setBottomComponent(pane);
        p.setLayout(new BorderLayout());
        p.add((Component)split, "Center");
        label.registerAction("test", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showConfirmDialog(p, "Hello World!");
            }
        });
        return p;
    }

    private static Component createCreateDialogs() {
        final TransparentPanel p = new TransparentPanel();
        p.setLayout(new BoxLayout(p, 1));
        JButton headerButton = new JButton("Good Header");
        headerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JEWTDialog d = JEWTDialog.createDialog((Component)p, (String)"Create ESB Project", (int)7);
                DialogHeader h = new DialogHeader();
                h.setHeaderImage(OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/project.png")));
                h.setHeaderDescription("Enter the details of the empty Oracle Enterprise Service Bus project. An ESB project is a logical container for a set of files that define an ESB system or porition of an ESB system.");
                d.setDialogHeader((Component)h);
                d.runDialog();
            }
        });
        p.add(headerButton);
        headerButton = new JButton("Bad Header");
        headerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JEWTDialog d = JEWTDialog.createDialog((Component)p, (String)"New Java Class", (int)7);
                DialogHeader h = new DialogHeader();
                h.setHeaderImage(OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/java.png")));
                h.setHeaderDescription("Enter the details of your new class.");
                d.setDialogHeader((Component)h);
                d.runDialog();
            }
        });
        p.add(headerButton);
        return p;
    }

    private static JPanel createCalendar() {
        TransparentPanel p = new TransparentPanel();
        p.add(new UICDateDemoPanel());
        return p;
    }

    private static Component createExtended() {
        JPanel p = new JPanel();
        p.setLayout((LayoutManager)new PreferredGridLayout((Container)p, 0, 3, 5, 10, -1, 2));
        ExtendedTextField field = new ExtendedTextField();
        field.setColumns(30);
        p.add(new JLabel("Extended Text Field (no breaks): "));
        p.add(field);
        p.add(Box.createHorizontalGlue());
        ExtendedTextField field4 = new ExtendedTextField();
        field4.setAllowBreaks(true);
        field4.setColumns(30);
        p.add(new JLabel("Extended Text Field (allows beaks): "));
        p.add(field4);
        p.add(Box.createHorizontalGlue());
        ExtendedTextField field2 = new ExtendedTextField();
        field2.setColumns(30);
        field2.setEnabled(false);
        field2.setText("The power of accurate observation is frequently called cynicism by those who don't have it.");
        field2.getLargerTextArea().setWrapStyleWord(true);
        p.add(new JLabel("Disabled Extended Text Field: "));
        p.add(field2);
        p.add(Box.createHorizontalGlue());
        ExtendedTextField field3 = new ExtendedTextField();
        field3.setColumns(30);
        field3.setEditable(false);
        field3.getLargerTextArea().setWrapStyleWord(true);
        field3.setText("The difference between 'involvement' and 'commitment' is like an eggs-and-ham breakfast: the chicken was 'involved' - the pig was 'committed'.");
        p.add(new JLabel("Non-Editable Extended Text Field: "));
        p.add(field3);
        p.add(Box.createHorizontalGlue());
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return p;
    }

    private static Component createResizeables() {
        TransparentPanel p = new TransparentPanel();
        p.setLayout(new FlowLayout(0, 20, 20));
        p.setPreferredSize(new Dimension(400, 400));
        JTextArea ta = new JTextArea("Hey, whaddya gonna do, nice college boy, eh? Didn't want to get mixed up in the Family business, huh? Now you wanna gun down a police captain. Why? Because he slapped ya in the face a little bit? Hah? What do you think this is the Army, where you shoot 'em a mile away? You've gotta get up close like this and - bada-BING! - you blow their brains all over your nice Ivy League suit. C'mere...", 8, 30);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        JScrollPane sp = new JScrollPane(ta);
        ResizeComponent rc = new ResizeComponent(sp);
        rc.setMinimumSize(new Dimension(100, 55));
        rc.setMaximumSize(new Dimension(400, 240));
        p.add(rc);
        JTree tree = new JTree();
        JScrollPane sp2 = new JScrollPane(tree);
        sp2.setMinimumSize(new Dimension(100, 60));
        sp2.setPreferredSize(new Dimension(100, 200));
        p.add(new ResizeComponent(sp2));
        JTable table = new JTable(new Object[][]{{"Don Corleone", "Heart Attack", "Orange Grove"}, {"Sonny", "Machine Guns", "Toll Booth"}, {"Michal", "Heart Attack", "Italian Villa"}, {"Fredo", "Single Shot", "Rowing Boat"}, {"Carlo", "Garotte", "Car"}, {"Luca", "Garotte", "Bar"}}, new String[]{"Name", "Means", "Place"});
        JScrollPane sp4 = new JScrollPane(table);
        sp4.setMinimumSize(new Dimension(100, 60));
        sp4.setMaximumSize(new Dimension(400, 240));
        ResizeComponent rc4 = new ResizeComponent(sp4);
        rc4.setPreferredSize(new Dimension(240, 120));
        p.add(rc4);
        JList<Object> list = new JList<Object>(new Object[]{"Don Corleone", "Luca Brasi", "Michael", "Kay Adams", "Sollozzo", "Johnny Fontane", "Tessio", "Fredo", "Moe Greene", "Tom Hagen", "Sonny", "Clemenza", "Carlo Rizzi", "Bonasera"});
        JScrollPane sp3 = new JScrollPane(list);
        p.add(new ResizeComponent(sp3));
        return p;
    }

    private static Component createOverlayLabel() {
        TransparentPanel p = new TransparentPanel();
        p.setLayout(new FlowLayout(0, 20, 20));
        p.setPreferredSize(new Dimension(400, 400));
        JTextArea ta = new JTextArea("Well Hello", 8, 30);
        ta.setEnabled(false);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        JScrollPane sp = new JScrollPane(ta);
        sp.setMinimumSize(new Dimension(100, 60));
        sp.setMaximumSize(new Dimension(400, 240));
        p.add(new ResizeComponent((JComponent)new JXLayer((Component)sp, new TextLayer("Hello"))));
        JTree tree = new JTree(new DefaultTreeModel(null));
        JScrollPane sp2 = new JScrollPane(tree);
        sp2.setPreferredSize(new Dimension(100, 200));
        tree.setEnabled(false);
        p.add(new ResizeComponent((JComponent)new JXLayer((Component)sp2, new TextLayer("The Godfather is arguably the greatest film ever made"))));
        JTable table = new JTable(new Object[0][], new String[]{"Name", "Means", "Place"});
        table.setEnabled(false);
        JScrollPane sp4 = new JScrollPane(table);
        sp4.setEnabled(false);
        sp4.setMinimumSize(new Dimension(100, 60));
        sp4.setMaximumSize(new Dimension(400, 240));
        JXLayer jxLayer = new JXLayer((Component)sp4, new TextLayer("It Has Violent Moments"));
        ResizeComponent rc4 = new ResizeComponent((JComponent)jxLayer);
        ((JComponent)rc4).setPreferredSize(new Dimension(240, 120));
        p.add(rc4);
        JList list = new JList();
        list.setEnabled(false);
        JScrollPane sp3 = new JScrollPane(list);
        sp3.setEnabled(false);
        p.add(new ResizeComponent((JComponent)new JXLayer((Component)sp3, new TextLayer("It also has an amazing cast"))));
        return p;
    }

    private static Component createCombos() {
        TransparentPanel p = new TransparentPanel();
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        p.setLayout((LayoutManager)new PreferredGridLayout((Container)p, 0, 2, 8, 5, -1, -1));
        p.setPreferredSize(new Dimension(400, 400));
        p.add(new JLabel("Checkbox Combo:"));
        p.add(UICDemo.createJCheckCombo());
        p.add(new JLabel("Tree Combo:"));
        p.add(new JTreeCombo(new JTree().getModel()));
        p.add(new JLabel("Fix List Combo:"));
        p.add(UICDemo.createJFixCombo());
        p.add(new JLabel("Tree with Fix List Combo:"));
        p.add(UICDemo.createJTreeFixCombo());
        p.add(new JLabel("Combo with Separator"));
        p.add((Component)UICDemo.createSeparatorCombo(), "wrap");
        return p;
    }

    private static JComboBox createJCheckCombo() {
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        for (Object obj : UICDemo.createListArray()) {
            listModel.addElement(obj);
        }
        JCheckCombo combo = new JCheckCombo(listModel);
        combo.setPreferredSize(new Dimension(140, combo.getPreferredSize().height));
        return combo;
    }

    private static JComboBox createJFixCombo() {
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        for (Object obj : UICDemo.createListArray()) {
            listModel.addElement(obj);
        }
        DefaultListModel<Object> fixModel = new DefaultListModel<Object>();
        for (Object obj : UICDemo.createFixArray()) {
            fixModel.addElement(obj);
        }
        JFixListCombo combo = new JFixListCombo(listModel, fixModel);
        return combo;
    }

    private static JTreeFixListCombo createJTreeFixCombo() {
        DefaultListModel<Object> fixModel = new DefaultListModel<Object>();
        for (Object obj : UICDemo.createFixArray()) {
            fixModel.addElement(obj);
        }
        JTreeFixListCombo combo = new JTreeFixListCombo(new JTree().getModel(), fixModel);
        return combo;
    }

    private static JComboBox createSeparatorCombo() {
        JComboBox<Object> combo = new JComboBox<Object>(UICDemo.createListArray());
        SeparatorListCellRenderer renderer = new SeparatorListCellRenderer(new DefaultListCellRenderer(), new SeparatorListCellRenderer.SeparatorModel(){

            @Override
            public boolean hasTrailingSeparator(int index, Object value) {
                return index == 1 || index == 7;
            }
        });
        combo.setRenderer(renderer);
        return combo;
    }

    private static Object[] createListArray() {
        Object[] list = new String[]{"Michael", "Vito", "Sonny", "Fredo", "Kay", "Connie", "Tom Hagen", "Clemenza", "Solattzo", "Enzo", "Hyman Roth", "Johnny Fontaine"};
        return list;
    }

    private static Object[] createFixArray() {
        Object[] list = new String[]{"Fixed Option", "More..."};
        return list;
    }

    private static Component createHeaders() {
        TransparentPanel p = new TransparentPanel();
        p.setLayout(new BorderLayout());
        HeaderPanel<TransparentPanel> page = new HeaderPanel<TransparentPanel>();
        page.getHeader().setText("Tam O'Shanter");
        page.getHeader().setLevel(Header.Level.PAGE);
        page.getHeader().setExpanded(true);
        page.setStaticHelpText("This is some help text for the page level header.");
        p.add(page, "Center");
        TransparentPanel pagePanel = new TransparentPanel();
        pagePanel.setLayout(new VerticalFlowLayout());
        page.setHostedComponent(pagePanel);
        HeaderPanel<JPanel> sub1 = new HeaderPanel<JPanel>();
        sub1.getHeader().setName("TEST_HEADER_1");
        sub1.getHeader().setText("Warlocks and Witches in a Dance");
        sub1.setStaticHelpText("This is some help text for this header.");
        sub1.getHeader().setRollupStatusText("Nae cotillion, brent new frae France");
        sub1.getHeader().addActionControl(new NullAction(OracleIcons.getIcon((String)"add.png")));
        sub1.getHeader().addActionControl(new NullAction(OracleIcons.getIcon((String)"edit.png")));
        sub1.getHeader().addActionControl(new NullAction(OracleIcons.getIcon((String)"delete.png")));
        sub1.getHeader().setExpanded(false);
        sub1.getHeader().setExpanded(true);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new PreferredGridLayout((Container)contentPanel, 0, 1, 0, 2, -1, 0));
        contentPanel.add(new JLabel("Collapse me to see rollup text.", OracleIcons.getIcon((String)"info.png"), 2));
        contentPanel.add(new JLabel("There sat auld Nick"));
        contentPanel.add(new TitledSeparator("Dotted Separator with Title", TitledSeparator.STYLE.DOTTED));
        contentPanel.add(new JCheckBox("Hornpipes"));
        contentPanel.add(new JCheckBox("Jigs"));
        contentPanel.add(new JCheckBox("Strathspeys"));
        contentPanel.add(new TitledSeparator("Plain Separator with Title"));
        contentPanel.add(new JCheckBox("Reels"));
        sub1.setHostedComponent(contentPanel);
        sub1.getHeader().setLevel(Header.Level.SUB);
        pagePanel.add(sub1);
        HeaderPanel<TransparentPanel> sub2 = new HeaderPanel<TransparentPanel>();
        sub2.getHeader().setText("A Winnock Bunker in the East");
        sub2.getHeader().setLevel(Header.Level.SUB);
        sub2.getHeader().addActionControl(new AbstractAction("Foo"){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        TransparentPanel sub2Panel = new TransparentPanel();
        sub2Panel.setLayout(new VerticalFlowLayout());
        HeaderPanel<JLabel> subsub1 = new HeaderPanel<JLabel>();
        subsub1.getHeader().setLevel(Header.Level.SUBSUB);
        subsub1.getHeader().setText("A Tousie Tyke");
        subsub1.getHeader().setRollupStatusText("Black, grim, and large");
        subsub1.setHostedComponent(new JLabel("To gie them music was his charge"));
        sub2Panel.add(subsub1);
        HeaderPanel<JLabel> subsub2 = new HeaderPanel<JLabel>();
        subsub2.getHeader().setLevel(Header.Level.SUBSUB);
        subsub2.getHeader().setText("And by Some Devilish Cantraip Sleight");
        subsub2.getHeader().addActionControl(new NullAction(OracleIcons.getIcon((String)"add.png")));
        subsub2.getHeader().setRollupStatusText("Each in its cauld hand held a light");
        subsub2.setHostedComponent(new JLabel("Till roof and rafters a' did dirl"));
        sub2Panel.add(subsub2);
        sub2.setHostedComponent(sub2Panel);
        pagePanel.add(sub2);
        HeaderPanel<JLabel> dh = new HeaderPanel<JLabel>();
        dh.getHeader().setLevel(Header.Level.DIALOG);
        dh.getHeader().setText("A Dialog Style Header");
        dh.getHeader().setExpanded(false);
        dh.setHostedComponent(new JLabel("Boo.", OracleIcons.getIcon((String)"user.png"), 2));
        dh.setAnimationEnabled(false);
        pagePanel.add(dh);
        JScrollPane sp = new JScrollPane(p);
        sp.getViewport().setOpaque(false);
        sp.setBorder(null);
        sp.setOpaque(false);
        return sp;
    }

    private static Component createTruncatingTreeRenderer() {
        class Node {
            String text;
            Icon icon;

            Node() {
            }
        }
        Node n = new Node();
        n.text = "Root";
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(n);
        n = new Node();
        n.text = "GetStockDailyValuesByValueXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new Node();
        n.text = "GetStockDailyValuesByDateXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new Node();
        n.text = "GetStockDailyValuesXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new Node();
        n.text = "GetLatestStockDailyValuesXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new Node();
        n.text = "GetStockDailyValue";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        DefaultMutableTreeNode sdv = new DefaultMutableTreeNode(n);
        root.add(sdv);
        n = new Node();
        n.text = "Method returns the value of the stock on the given date.";
        n.icon = OracleIcons.getIcon((String)"element.png");
        sdv.add(new DefaultMutableTreeNode(n));
        JTree tree = new JTree();
        tree.setModel(new DefaultTreeModel(root));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setCellRenderer(new TruncatingTreeCellRenderer<DefaultMutableTreeNode>(){

            @Override
            protected String getText(JTree tree, DefaultMutableTreeNode value, boolean selected, boolean expanded, boolean leaf, int row) {
                return ((Node)value.getUserObject()).text;
            }

            @Override
            protected Icon getIcon(JTree tree, DefaultMutableTreeNode value, boolean selected, boolean expanded, boolean leaf, int row) {
                return ((Node)value.getUserObject()).icon;
            }
        });
        JScrollPane sp = new JScrollPane(tree);
        sp.getViewport().setOpaque(false);
        sp.setBorder(null);
        sp.setOpaque(false);
        return sp;
    }

    private static Component createShadowBorderPanel() {
        JPanel parent = new JPanel();
        TransparentBorderComponent p = new TransparentBorderComponent();
        JLabel l = new JLabel();
        l.setText("Label with a drop shadow!");
        p.setBorder(new ShadowBorder());
        p.add(l);
        parent.add(p);
        return p;
    }

    private static Component createVertHeaderPanel() {
        TransparentPanel p = new TransparentPanel();
        p.setBackground(Color.WHITE);
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        p.setLayout(new ColumnLayout());
        JTree tree = new JTree();
        tree.setCellRenderer(new TruncatingTreeCellRenderer());
        tree.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Colors.FLAT_EDITOR_BORDER));
        HeaderPanel<JTree> hp = new HeaderPanel<JTree>(tree);
        hp.setCollapseMode(HeaderPanel.CollapseMode.COLLAPSE_LEFT);
        hp.getHeader().setText("Messages");
        hp.getHeader().setLevel(Header.Level.SUBSUB);
        hp.setComponentBorderPainted(true);
        hp.setComponentIndented(false);
        hp.getHeader().addActionControl(new AbstractAction("", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        hp.getHeader().addActionControl(new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        p.add(hp);
        class Node {
            String text;
            Icon icon;

            Node() {
            }
        }
        Node n = new Node();
        n.text = "Root";
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(n);
        n = new Node();
        n.text = "GetStockDailyValuesByValueXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new Node();
        n.text = "GetStockDailyValuesByDateXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new Node();
        n.text = "GetStockDailyValuesXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new Node();
        n.text = "GetLatestStockDailyValuesXML";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        root.add(new DefaultMutableTreeNode(n));
        n = new Node();
        n.text = "GetStockDailyValue";
        n.icon = OracleIcons.getIcon((String)"webmethod.png");
        DefaultMutableTreeNode sdv = new DefaultMutableTreeNode(n);
        root.add(sdv);
        n = new Node();
        n.text = "Method returns the value of the stock on the given date.";
        n.icon = OracleIcons.getIcon((String)"element.png");
        sdv.add(new DefaultMutableTreeNode(n));
        tree = new JTree();
        tree.setModel(new DefaultTreeModel(root));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setCellRenderer(new TruncatingTreeCellRenderer<DefaultMutableTreeNode>(){

            @Override
            protected String getText(JTree tree, DefaultMutableTreeNode value, boolean selected, boolean expanded, boolean leaf, int row) {
                return ((Node)value.getUserObject()).text;
            }

            @Override
            protected Icon getIcon(JTree tree, DefaultMutableTreeNode value, boolean selected, boolean expanded, boolean leaf, int row) {
                return ((Node)value.getUserObject()).icon;
            }
        });
        hp = new HeaderPanel<JTree>(tree);
        hp.setCollapseMode(HeaderPanel.CollapseMode.COLLAPSE_LEFT);
        hp.getHeader().setLevel(Header.Level.SUBSUB);
        hp.getHeader().setText("Port Types");
        hp.setComponentBorderPainted(true);
        hp.setComponentIndented(false);
        hp.getHeader().addActionControl(new AbstractAction("", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        hp.getHeader().addActionControl(new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        p.add(hp);
        hp = new HeaderPanel<JTree>(new JTree());
        hp.setCollapseMode(HeaderPanel.CollapseMode.COLLAPSE_RIGHT);
        hp.getHeader().setText("Bindings");
        hp.getHeader().setLevel(Header.Level.SUBSUB);
        hp.getHeader().addActionControl(new AbstractAction("", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        hp.getHeader().addActionControl(new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        hp.setComponentBorderPainted(true);
        hp.setComponentIndented(false);
        p.add(hp);
        hp = new HeaderPanel<JTree>(new JTree());
        hp.setCollapseMode(HeaderPanel.CollapseMode.COLLAPSE_RIGHT);
        hp.getHeader().setText("Services");
        hp.getHeader().setLevel(Header.Level.SUBSUB);
        hp.getHeader().addActionControl(new AbstractAction("", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        hp.getHeader().addActionControl(new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        hp.setComponentBorderPainted(true);
        hp.setComponentIndented(false);
        p.add(hp);
        JScrollPane sp = new JScrollPane(p);
        sp.getViewport().setOpaque(false);
        sp.setBorder(null);
        sp.setOpaque(false);
        return sp;
    }

    private static Component createCompletions() {
        TreeSet<String> countries = new TreeSet<String>();
        for (Locale l : Locale.getAvailableLocales()) {
            String countryName = l.getDisplayCountry();
            if (countryName.length() <= 0) continue;
            countries.add(countryName);
        }
        JPanel panel = new JPanel((LayoutManager)new MigLayout(""));
        CompletionTextField ctf = new CompletionTextField();
        ctf.setColumns(25);
        ctf.getPopupHandler().registerInsightProvider(new StringCompletionProvider(countries));
        ctf.getPopupHandler().setAlignWithField(true);
        CompletionTextField ctfDrop = new CompletionTextField();
        ctfDrop.setColumns(25);
        ctfDrop.getPopupHandler().registerInsightProvider(new StringCompletionProvider(countries));
        CompletionTextFieldWithDrop drop = new CompletionTextFieldWithDrop(ctfDrop);
        panel.add(new JLabel("CompletionTextField:"));
        panel.add((Component)ctf, "ay top, wrap");
        panel.add(new JLabel("CompletionTextFieldWithDrop:"));
        panel.add((Component)drop, "ay top");
        return panel;
    }

    private static class NullAction
    extends AbstractAction {
        public NullAction(Icon icon) {
            super("", icon);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    }
}

