/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal.theme;

import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import oracle.javatools.ui.internal.theme.Colors;

public class SkyBluer
extends PlasticTheme {
    protected FontUIResource controlTextFont;
    protected FontUIResource userTextFont;
    protected FontUIResource menuTextFont;
    protected FontUIResource systemTextFont;
    protected FontUIResource windowTitleFont;
    protected FontUIResource subTextFont;
    private static boolean _isWindowsRegistryFontSupported = false;
    private FontSet _fontSet;

    public static void setWindowsRegistryFontSupported(boolean isSupported) {
        _isWindowsRegistryFontSupported = isSupported;
    }

    public String getName() {
        return "Sky Bluer";
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public FontUIResource getControlTextFont() {
        if (this.controlTextFont == null) {
            this.controlTextFont = this.getDefaultFont("swing.plaf.metal.controlFont", "Button.font", super.getControlTextFont());
        }
        return this.controlTextFont;
    }

    public FontUIResource getSystemTextFont() {
        if (this.systemTextFont == null) {
            this.systemTextFont = this.getDefaultFont("swing.plaf.metal.systemFont", "ToolTip.font", super.getSystemTextFont());
        }
        return this.systemTextFont;
    }

    public FontUIResource getUserTextFont() {
        if (this.userTextFont == null) {
            this.userTextFont = this.getDefaultFont("swing.plaf.metal.userFont", "TextField.font", super.getUserTextFont());
        }
        return this.userTextFont;
    }

    public FontUIResource getMenuTextFont() {
        if (this.menuTextFont == null) {
            this.menuTextFont = this.getDefaultFont("swing.plaf.metal.controlFont", "Menu.font", super.getMenuTextFont());
        }
        return this.menuTextFont;
    }

    public FontUIResource getWindowTitleFont() {
        if (this.windowTitleFont == null) {
            this.windowTitleFont = this.getDefaultFont("swing.plaf.metal.controlFont", "InternalFrame.titleFont", super.getWindowTitleFont());
        }
        return this.windowTitleFont;
    }

    public FontUIResource getSubTextFont() {
        if (this.subTextFont == null) {
            Font font = Font.getFont("swing.plaf.metal.smallFont");
            if (font != null) {
                this.subTextFont = new FontUIResource(font);
            } else if (this.isWindows()) {
                font = this.getFont0();
                String name = font.getName();
                int style = font.getStyle();
                int size = Math.round(font.getSize2D() * 0.9f);
                this.subTextFont = new FontUIResource(name, style, size);
            } else {
                this.subTextFont = super.getSubTextFont();
            }
        }
        return this.subTextFont;
    }

    protected Font getFont0() {
        Toolkit toolkit;
        Object value;
        if (this.isWindows() && (value = (toolkit = Toolkit.getDefaultToolkit()).getDesktopProperty("win.defaultGUI.font")) instanceof Font) {
            Font font = (Font)value;
            int fontSize = font.getSize();
            return this.getFont0(fontSize);
        }
        return this.getFont0(LookUtils.IS_LOW_RESOLUTION ? 11 : 14);
    }

    protected Font getFont0(int size) {
        return new Font("Dialog", 0, size);
    }

    protected FontSet getFontSet() {
        if (this._fontSet == null) {
            this._fontSet = FontSets.createDefaultFontSet((Font)this.getFont0());
        }
        return this._fontSet;
    }

    protected FontUIResource getDefaultFont(String propertyKey, String uiDefaultsKey, FontUIResource defaultFont) {
        Font font = Font.getFont(propertyKey);
        if (font != null) {
            return new FontUIResource(font);
        }
        if (this.isWindows()) {
            FontUIResource ret;
            Object value = null;
            try {
                WindowsLookAndFeel winLaf = new WindowsLookAndFeel();
                UIDefaults winDefaults = winLaf.getDefaults();
                value = winDefaults.get(uiDefaultsKey);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (value instanceof FontUIResource) {
                ret = (FontUIResource)value;
            } else if (value instanceof Font) {
                ret = new FontUIResource((Font)value);
            } else {
                return defaultFont;
            }
            if (_isWindowsRegistryFontSupported) {
                return ret;
            }
            String fontName = ret.getFontName();
            if (!fontName.equalsIgnoreCase("tahoma")) {
                return ret;
            }
        }
        return defaultFont;
    }

    protected ColorUIResource getPrimary1() {
        return Colors.BLUE_MEDIUM_DARKEST;
    }

    protected ColorUIResource getPrimary2() {
        return Colors.BLUE_MEDIUM_MEDIUM;
    }

    protected ColorUIResource getPrimary3() {
        return Colors.BLUE_MEDIUM_LIGHTEST;
    }

    protected ColorUIResource getSecondary1() {
        return Colors.GRAY_MEDIUMDARK;
    }

    protected ColorUIResource getSecondary2() {
        return Colors.GRAY_LIGHT;
    }

    protected ColorUIResource getSecondary3() {
        return Colors.GRAY_LIGHTER;
    }

    public ColorUIResource getMenuItemSelectedBackground() {
        return this.getPrimary2();
    }

    public ColorUIResource getMenuItemSelectedForeground() {
        return this.getWhite();
    }

    public ColorUIResource getMenuSelectedBackground() {
        return this.getSecondary2();
    }

    public ColorUIResource getFocusColor() {
        return PlasticLookAndFeel.getHighContrastFocusColorsEnabled() ? Colors.YELLOW_FOCUS : super.getFocusColor();
    }

    public void addCustomEntriesToTable(UIDefaults table) {
        super.addCustomEntriesToTable(table);
        Object[] uiDefaults = new Object[]{"ScrollBar.maxBumpsWidth", new Integer(30)};
        table.putDefaults(uiDefaults);
    }
}

