/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.list;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import oracle.javatools.ui.list.DefaultCheckListCellRenderer;

public class ReflectiveCheckListCellRenderer
extends DefaultCheckListCellRenderer {
    private Method textMethod;
    private Object[] textParameterValues;
    private Class[] textParameterClasses;
    private String textMethodName;
    private Method iconMethod;
    private Object[] iconParameterValues;
    private Class[] iconParameterClasses;
    private String iconMethodName;

    public ReflectiveCheckListCellRenderer(String textMethodName) {
        this.textMethodName = textMethodName;
    }

    public ReflectiveCheckListCellRenderer(String textMethodName, Class[] textParameterClasses, Object[] textParameterValues) {
        this.textMethodName = textMethodName;
        this.textParameterClasses = textParameterClasses;
        this.textParameterValues = textParameterValues;
    }

    public ReflectiveCheckListCellRenderer(String textMethodName, String iconMethodName) {
        this.textMethodName = textMethodName;
        this.iconMethodName = iconMethodName;
    }

    public ReflectiveCheckListCellRenderer(String textMethodName, Class[] textParameterClasses, Object[] textParameterValues, String iconMethodName, Class[] iconParameterClasses, Object[] iconParameterValues) {
        this.textMethodName = textMethodName;
        this.textParameterClasses = textParameterClasses;
        this.textParameterValues = textParameterValues;
        this.iconMethodName = iconMethodName;
        this.iconParameterClasses = iconParameterClasses;
        this.iconParameterValues = iconParameterValues;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JCheckBox checkBox = (JCheckBox)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        try {
            Object ret;
            if (this.textMethod == null && this.textMethodName != null && value != null) {
                this.textMethod = value.getClass().getMethod(this.textMethodName, this.textParameterClasses);
            }
            if (this.iconMethod == null && this.iconMethodName != null && value != null) {
                this.iconMethod = value.getClass().getMethod(this.iconMethodName, this.iconParameterClasses);
            }
            if (this.textMethod != null && (ret = this.textMethod.invoke(value, this.textParameterValues)) != null) {
                checkBox.setText(ret.toString());
            }
            if (this.iconMethod != null && (ret = this.iconMethod.invoke(value, this.iconParameterValues)) != null) {
                checkBox.setIcon((Icon)ret);
            }
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.SEVERE, "Cannot render list item: " + value, e);
        }
        return checkBox;
    }
}

