/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.javatools.ui.AttributedStringBuilder;
import oracle.javatools.ui.SuperLabel;
import oracle.javatools.util.Tuple;

public abstract class SuperListCellRenderer<T>
implements ListCellRenderer {
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border DEFAULT_NO_FOCUS_BORDER;
    protected static Border noFocusBorder;
    private SuperLabel label = new SuperLabel();
    private JLabel iconLabel = new JLabel();
    private JPanel content = new JPanel(new LayoutM());

    public SuperListCellRenderer() {
        this.content.add((Component)this.iconLabel, "Before");
        this.content.add(this.label);
    }

    public JComponent getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Object item = value;
        this.cellSetup(list, item, index, isSelected, cellHasFocus);
        Icon icon = null;
        AttributedString text = null;
        Tuple<Icon, AttributedString> cellContent = this.getCellContent(list, value, index, isSelected, cellHasFocus);
        if (cellContent != null) {
            icon = (Icon)cellContent.object1();
            text = (AttributedString)cellContent.object2();
        } else {
            icon = this.getCellIcon(list, item, index, isSelected, cellHasFocus);
            text = this.getCellText(list, item, index, isSelected, cellHasFocus);
        }
        if (text == null) {
            this.label.setText("");
        } else {
            this.label.setAttributedText(text);
        }
        this.iconLabel.setIcon(icon);
        return this.content;
    }

    public Tuple<Icon, AttributedString> getCellContent(JList list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        return null;
    }

    public Icon getCellIcon(JList list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        Tuple<Icon, AttributedString> content = this.getCellContent(list, value, index, isSelected, cellHasFocus);
        return content == null ? null : (Icon)content.object1();
    }

    public AttributedString getCellText(JList list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        Tuple<Icon, AttributedString> content = this.getCellContent(list, value, index, isSelected, cellHasFocus);
        return content == null ? null : (AttributedString)content.object2();
    }

    protected void cellSetup(JList list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        this.label.setComponentOrientation(list.getComponentOrientation());
        Color bg = null;
        Color fg = null;
        JList.DropLocation dropLocation = list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor("List.dropCellBackground");
            fg = UIManager.getColor("List.dropCellForeground");
            isSelected = true;
        }
        if (isSelected) {
            this.content.setBackground(bg == null ? list.getSelectionBackground() : bg);
            this.content.setForeground(fg == null ? list.getSelectionForeground() : fg);
        } else {
            this.content.setBackground(list.getBackground());
            this.content.setForeground(list.getForeground());
        }
        if (value instanceof Icon) {
            this.iconLabel.setIcon((Icon)value);
            this.label.setText("");
        } else {
            this.iconLabel.setIcon(null);
            this.label.setText(value == null ? "" : value.toString());
        }
        this.label.setEnabled(list.isEnabled());
        this.label.setFont(list.getFont());
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = this.getNoFocusBorder();
        }
        this.content.setBorder(border);
    }

    private Border getNoFocusBorder() {
        Border border = UIManager.getBorder("List.cellNoFocusBorder");
        if (System.getSecurityManager() != null) {
            if (border != null) {
                return border;
            }
            return SAFE_NO_FOCUS_BORDER;
        }
        if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
            return border;
        }
        return noFocusBorder;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        String[] items = new String[]{"Apple", "Blueberry", "Cherry"};
        JList<String> list = new JList<String>(items);
        list.setCellRenderer((ListCellRenderer<String>)new SuperListCellRenderer<String>(){

            @Override
            public Tuple<Icon, AttributedString> getCellContent(JList list, String value, int index, boolean isSelected, boolean cellHasFocus) {
                Color color = Color.GREEN;
                if (index == 1) {
                    color = Color.BLUE;
                }
                if (index == 2) {
                    color = Color.RED;
                }
                AttributedStringBuilder asb = new AttributedStringBuilder(value, TextAttribute.FOREGROUND, color);
                HashMap<TextAttribute, Number> attrs = new HashMap<TextAttribute, Number>();
                attrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                attrs.put(TextAttribute.SIZE, 10);
                attrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRA_LIGHT);
                asb.append(" (java.lang.fruit)", attrs);
                return new Tuple((Object)UIManager.getIcon("Tree.closedIcon"), (Object)asb.toAttributedString());
            }
        });
        f.add(new JScrollPane(list));
        f.setSize(400, 600);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    static {
        noFocusBorder = DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    }

    private class LayoutM
    implements LayoutManager {
        private final int iconTextGap = 2;

        private LayoutM() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension iconD = SuperListCellRenderer.this.iconLabel.getPreferredSize();
            Dimension textD = SuperListCellRenderer.this.label.getPreferredSize();
            return new Dimension(1 + iconD.width + 2 + textD.width + 1, Math.max(iconD.height, textD.height) + 1);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension iconD = SuperListCellRenderer.this.iconLabel.getMinimumSize();
            Dimension textD = SuperListCellRenderer.this.label.getMinimumSize();
            return new Dimension(1 + iconD.width + 2 + textD.width + 1, Math.max(iconD.height, textD.height) + 1);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension iconD = SuperListCellRenderer.this.iconLabel.getPreferredSize();
            Dimension textD = SuperListCellRenderer.this.label.getPreferredSize();
            int iconYOff = 0;
            int textYOff = 0;
            if (parent.getHeight() > textD.height) {
                textYOff = (parent.getHeight() - textD.height) / 2;
            }
            if (parent.getHeight() > iconD.height) {
                iconYOff = (parent.getHeight() - iconD.height) / 2;
            }
            SuperListCellRenderer.this.iconLabel.setBounds(1, iconYOff, iconD.width, iconD.height);
            SuperListCellRenderer.this.label.setBounds(1 + iconD.width + 2, textYOff, textD.width, textD.height);
        }
    }
}

