/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicLabelUI;
import oracle.javatools.ui.SuperLabel;

public class SuperLabelUI
extends BasicLabelUI {
    private static final SuperLabelUI superLabelUI = new SuperLabelUI();

    public static SuperLabelUI createUI(JLabel label) {
        return superLabelUI;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        SuperLabel label = (SuperLabel)jComponent;
        Insets insets = jComponent.getInsets();
        int width = ((SuperLabel)jComponent).getPreferredWrapWidth() - insets.left - insets.right;
        Dimension d = this.sizeOrPaint((Graphics2D)jComponent.getGraphics(), false, width, label);
        d.height += insets.bottom;
        d.width += insets.left + insets.right;
        return d;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SuperLabel label = (SuperLabel)jComponent;
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets insets = jComponent.getInsets();
        int cWidth = jComponent.getWidth() - insets.left - insets.right;
        int cHeight = jComponent.getHeight();
        Dimension d = this.sizeOrPaint((Graphics2D)graphics, false, cWidth, label);
        if (!label.isEnabled()) {
            graphics.setColor(UIManager.getColor("Label.disabledForeground"));
        }
        if (d.width > cWidth || d.height > cHeight) {
            this.paintTruncated(label, (Graphics2D)graphics);
        } else {
            this.sizeOrPaint((Graphics2D)graphics, true, cWidth, label);
        }
    }

    public Dimension sizeOrPaint(Graphics2D g, boolean paint, int width, SuperLabel label) {
        FontRenderContext frc = g == null ? new FontRenderContext(null, true, true) : g.getFontRenderContext();
        AttributedString as = label.getAttributedText();
        if (label.getText() == null || label.getText().length() == 0 || width < 1) {
            return new Dimension(1, 14);
        }
        LineBreakMeasurer lbm = new LineBreakMeasurer(as.getIterator(), frc);
        Deque<Integer> newLines = this.findNewLines(as.getIterator());
        Insets insets = label.getInsets();
        int maxWidth = 0;
        int maxHeight = 0;
        int y = insets.top;
        int pos = lbm.getPosition();
        int end = as.getIterator().getEndIndex();
        Integer nextNewLine = newLines.isEmpty() ? end : newLines.pop();
        TextLayout layout = null;
        while (pos < end) {
            if (pos == nextNewLine) {
                ++pos;
                nextNewLine = newLines.peek() == null ? end : newLines.pop();
            }
            layout = nextNewLine == null ? lbm.nextLayout(width) : lbm.nextLayout(width, nextNewLine, false);
            y = (int)((float)y + layout.getAscent());
            float x = layout.isLeftToRight() ? (float)insets.left : (float)width - layout.getVisibleAdvance();
            maxWidth = (int)Math.max((float)maxWidth, layout.getVisibleAdvance());
            maxHeight = y;
            switch (label.getHorizontalAlignment()) {
                case 4: {
                    x = (float)width - layout.getVisibleAdvance() + (float)insets.left;
                    break;
                }
                case 0: {
                    x = (float)(width / 2) - layout.getVisibleAdvance() / 2.0f;
                }
            }
            if (paint) {
                layout.draw(g, x, y);
            }
            y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
            pos = lbm.getPosition();
        }
        if (layout != null) {
            maxHeight = (int)((float)maxHeight + layout.getDescent());
        }
        return new Dimension(maxWidth, maxHeight);
    }

    private Deque<Integer> findNewLines(AttributedCharacterIterator it) {
        ArrayDeque<Integer> newLines = new ArrayDeque<Integer>();
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\n') {
                newLines.add(it.getIndex());
            }
            c = it.next();
        }
        return newLines;
    }

    private void paintTruncated(SuperLabel label, Graphics2D g) {
        AttributedString as = label.getAttributedText();
        LineBreakMeasurer lbm = new LineBreakMeasurer(as.getIterator(), g.getFontRenderContext());
        Deque<Integer> newLines = this.findNewLines(as.getIterator());
        int end = as.getIterator().getEndIndex();
        Integer nextNewLine = newLines.isEmpty() ? end : newLines.pop();
        Insets insets = label.getInsets();
        Rectangle r = label.getBounds();
        r.width = r.width - insets.left - insets.right;
        r.height = r.height - insets.top - insets.bottom;
        int width = r.width;
        int lines = this.findTruncatedLineCount(as, g, r);
        if (lines == 0) {
            int x = insets.left;
            switch (label.getHorizontalAlignment()) {
                case 4: {
                    x = width - 16;
                    break;
                }
                case 0: {
                    x = width / 2 - 8;
                }
            }
            g.drawString("...", x, insets.top + 8);
            return;
        }
        float x = 0.0f;
        int y = insets.top;
        int pos = lbm.getPosition();
        for (int line = 0; line < lines; ++line) {
            if (pos == nextNewLine) {
                ++pos;
                nextNewLine = newLines.peek() == null ? end : newLines.pop();
            }
            if (line == lines - 1) {
                width -= SwingUtilities.computeStringWidth(g.getFontMetrics(), "...");
            }
            TextLayout layout = nextNewLine == end ? lbm.nextLayout(width) : lbm.nextLayout(width, nextNewLine, false);
            y = (int)((float)y + layout.getAscent());
            x = layout.isLeftToRight() ? (float)insets.left : (float)width - layout.getVisibleAdvance();
            switch (label.getHorizontalAlignment()) {
                case 4: {
                    x = (float)width - layout.getVisibleAdvance() + (float)insets.left;
                    break;
                }
                case 0: {
                    x = (float)(width / 2) - layout.getVisibleAdvance() / 2.0f;
                }
            }
            layout.draw(g, x, y);
            if (line == lines - 1) {
                g.drawString("...", layout.getVisibleAdvance(), (float)y);
                break;
            }
            y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
            pos = lbm.getPosition();
        }
    }

    private int findTruncatedLineCount(AttributedString as, Graphics2D g, Rectangle r) {
        LineBreakMeasurer lbm = new LineBreakMeasurer(as.getIterator(), g.getFontRenderContext());
        Deque<Integer> newLines = this.findNewLines(as.getIterator());
        int end = as.getIterator().getEndIndex();
        Integer nextNewLine = newLines.isEmpty() ? end : newLines.pop();
        int width = r.width;
        float x = 0.0f;
        int y = 0;
        int pos = lbm.getPosition();
        int lines = 0;
        while (pos < end) {
            if (pos == nextNewLine) {
                ++pos;
                nextNewLine = newLines.peek() == null ? end : newLines.pop();
            }
            TextLayout layout = nextNewLine == null ? lbm.nextLayout(width) : lbm.nextLayout(width, nextNewLine, false);
            y = (int)((float)y + layout.getAscent());
            float f = x = layout.isLeftToRight() ? 0.0f : (float)width - layout.getAdvance();
            if ((float)r.width < layout.getVisibleAdvance() || (float)r.height < (float)y + layout.getDescent()) break;
            ++lines;
            y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
            pos = lbm.getPosition();
        }
        return lines;
    }
}

