/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import com.jgoodies.looks.plastic.PlasticMenuUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;

public class ThemedMenuUI
extends PlasticMenuUI {
    private final Handler _handler = new Handler();
    private boolean customBorder;

    public static ComponentUI createUI(JComponent m) {
        return new ThemedMenuUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (Themes.isThemed()) {
            c.addMouseListener(this._handler);
            c.addPropertyChangeListener(this._handler);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (Themes.isThemed()) {
            c.removeMouseListener(this._handler);
            c.removePropertyChangeListener(this._handler);
        }
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        if (!(menuItem instanceof JMenu)) {
            return;
        }
        if (((JMenu)menuItem).isTopLevelMenu()) {
            menuItem.setOpaque(false);
            Painter painter = null;
            if (menuItem.getModel().isSelected()) {
                painter = Themes.getActiveTheme().getStateProperties("menubar", "selected").getPainter("bg");
            } else if (menuItem.getModel().isRollover()) {
                painter = Themes.getActiveTheme().getStateProperties("menubar", "mouseover").getPainter("bg");
            }
            if (painter != null) {
                this.paintBackground(g, menuItem, painter);
            }
        }
    }

    private void paintBackground(Graphics g, JMenuItem menuItem, Painter painter) {
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        painter.paint(g, 0, 0, menuWidth, menuHeight);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon aCheckIcon, Icon anArrowIcon, Color background, Color foreground, int textIconGap) {
        super.paintMenuItem(g, c, aCheckIcon, anArrowIcon, background, foreground, textIconGap);
        if (this.customBorder) {
            return;
        }
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            this.customBorder = true;
            this.menuItem.setBorder(new MainMenuBorder());
            this.menuItem.setOpaque(false);
        }
    }

    private void setMenuStyle(JMenu menu, boolean mouseOver) {
        String state = mouseOver ? "mouseover" : "normal";
        Theme theme = Themes.getActiveTheme();
        if (menu.getFont() instanceof UIResource) {
            Font defaultFont = UIManager.getFont("Menu.font");
            menu.setFont(theme.getStateProperties("menubar", state).getFont(defaultFont, "label"));
        }
        if (menu.getForeground() instanceof UIResource) {
            menu.setForeground(theme.getStateProperties("menubar", state).getColor("label.foreground"));
        }
        if (menu.isShowing()) {
            menu.repaint();
        }
    }

    private class MainMenuBorder
    implements Border {
        private Color borderSelected = Themes.getActiveTheme().getStateProperties("menubar", "selected").getColor("border");
        private Color borderOver = Themes.getActiveTheme().getStateProperties("menubar", "mouseover").getColor("border");
        private Color cornerSelected = Themes.getActiveTheme().getStateProperties("menubar", "selected").getColor("corner");
        private Color cornerOver = Themes.getActiveTheme().getStateProperties("menubar", "mouseover").getColor("corner");
        private Insets insets = Themes.getActiveTheme().getPartProperties("menubar").getInsets("inset");

        private MainMenuBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (ThemedMenuUI.this.menuItem.getModel().isSelected()) {
                this.paintBorder(g, x, y, width, height, this.cornerSelected, this.borderSelected);
            } else if (ThemedMenuUI.this.menuItem.getModel().isRollover()) {
                this.paintBorder(g, x, y, width, height, this.cornerOver, this.borderOver);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        private void paintBorder(Graphics g, int x, int y, int width, int height, Color corner, Color border) {
            g.setColor(border);
            g.drawLine(x, y, x + width, y);
            g.drawLine(x, y + height - 1, x + width, y + height - 1);
            g.drawLine(x, y, x, y + height);
            g.drawLine(x + width - 1, y, x + width - 1, y + height);
            g.setColor(corner);
            int cornerSpace = 1;
            g.drawLine(x, y, x + cornerSpace - 1, y);
            g.drawLine(x + width - cornerSpace, y, x + width, y);
            g.drawLine(x, y + height - 1, x + cornerSpace - 1, y + height - 1);
            g.drawLine(x + width - cornerSpace, y + height - 1, x + width, y + height - 1);
        }
    }

    private class Handler
    implements MouseListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (menu.isTopLevelMenu()) {
                ThemedMenuUI.this.setMenuStyle(menu, true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (menu.isTopLevelMenu()) {
                ThemedMenuUI.this.setMenuStyle(menu, false);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JMenu menu;
            if ("ancestor".equals(e.getPropertyName()) && (menu = (JMenu)e.getSource()).isTopLevelMenu()) {
                ThemedMenuUI.this.setMenuStyle(menu, false);
            }
        }
    }
}

