/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalProgressBarUI;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

public final class ThemedProgressBarUI
extends MetalProgressBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new ThemedProgressBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (Themes.isThemed()) {
            ThemeProperties properties = Themes.getActiveTheme().getPartProperties("ProgressBar");
            UIManager.put("ProgressBar.cycleTime", properties.getInt("cycleTime"));
        }
    }

    @Override
    public void paintDeterminate(Graphics g, JComponent c) {
        if (!Themes.isThemed()) {
            super.paintDeterminate(g, c);
            return;
        }
        if (!(g instanceof Graphics2D)) {
            return;
        }
        this._paintDeterminateBorder(g, c);
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        this._paintBackground(g, b.left, b.top, barRectWidth, barRectHeight);
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        String dir = "";
        dir = this.progressBar.getOrientation() == 0 ? "horizontal" : "vertical";
        ThemeProperties properties = Themes.getActiveTheme().getStateProperties("progressbar.determinate", dir);
        Painter painter = properties.getPainter("bg");
        if (this.progressBar.getOrientation() == 0) {
            painter.paint(g, b.left, b.top, amountFull, barRectHeight);
        } else {
            painter.paint(g, b.left, barRectHeight + b.top - amountFull, barRectWidth, amountFull);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    @Override
    public void paintIndeterminate(Graphics g, JComponent c) {
        if (!Themes.isThemed()) {
            super.paintDeterminate(g, c);
            return;
        }
        if (!(g instanceof Graphics2D)) {
            return;
        }
        this._paintInDeterminateBorder(g, c);
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        this._paintBackground(g, b.left, b.top, barRectWidth, barRectHeight);
        Graphics2D g2 = (Graphics2D)g;
        this.boxRect = this.getBox(this.boxRect);
        if (this.boxRect != null) {
            ThemeProperties properties = Themes.getActiveTheme().getPartProperties("progressbar.indeterminate");
            Color c1 = properties.getColor("bottom.center");
            Color c2 = properties.getColor("bottom.outer");
            Color c3 = properties.getColor("top.center");
            Color c4 = properties.getColor("top.outer");
            if (this.progressBar.getOrientation() == 0) {
                Point2D.Float center = new Point2D.Float(this.boxRect.x + this.boxRect.width / 2, this.boxRect.y + this.boxRect.height / 2);
                float radius = Math.max(this.boxRect.width / 2, this.boxRect.height / 2);
                float[] dist = new float[]{0.0f, 1.0f};
                Color[] colors = new Color[]{c1, c2};
                RadialGradientPaint grad = new RadialGradientPaint(center, radius, dist, colors);
                ((Graphics2D)g).setPaint(grad);
                g.fillRect(this.boxRect.x, this.boxRect.y + this.boxRect.height / 2, this.boxRect.width, this.boxRect.height / 2 + 1);
                Color[] colors1 = new Color[]{c3, c4};
                RadialGradientPaint grad1 = new RadialGradientPaint(center, radius, dist, colors1);
                ((Graphics2D)g).setPaint(grad1);
                g.fillRect(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height / 2);
            } else {
                Point2D.Float center = new Point2D.Float(this.boxRect.x + this.boxRect.width / 2, this.boxRect.y + this.boxRect.height / 2);
                float radius = Math.max(this.boxRect.width / 2, this.boxRect.height / 2);
                float[] dist = new float[]{0.0f, 1.0f};
                Color[] colors = new Color[]{c1, c2};
                RadialGradientPaint grad = new RadialGradientPaint(center, radius, dist, colors);
                ((Graphics2D)g).setPaint(grad);
                g.fillRect(this.boxRect.x, this.boxRect.y, this.boxRect.width / 2, this.boxRect.height);
                Color[] colors1 = new Color[]{c3, c4};
                RadialGradientPaint grad1 = new RadialGradientPaint(center, radius, dist, colors1);
                ((Graphics2D)g).setPaint(grad1);
                g.fillRect(this.boxRect.x + this.boxRect.width / 2, this.boxRect.y, this.boxRect.width / 2, this.boxRect.height);
            }
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g2, b.left, b.top, barRectWidth, barRectHeight, barRectWidth, b);
            } else {
                this.paintString(g2, b.left, b.top, barRectWidth, barRectHeight, barRectHeight, b);
            }
        }
    }

    @Override
    protected int getBoxLength(int availableLength, int otherDimension) {
        if (!Themes.isThemed()) {
            return super.getBoxLength(availableLength, otherDimension);
        }
        return (int)Math.round((double)availableLength / 3.0);
    }

    @Override
    protected Rectangle getBox(Rectangle r) {
        r = super.getBox(r);
        if (!Themes.isThemed()) {
            return r;
        }
        if (r == null || this.progressBar.getOrientation() == 1) {
            return r;
        }
        int currentFrame = this.getAnimationIndex();
        int middleFrame = this.getFrameCount() / 2;
        int quarterFrame = this.getFrameCount() / 4;
        r.x = currentFrame < quarterFrame ? (int)((double)r.x - (double)r.width * 2.0 * (double)(quarterFrame - currentFrame) / (double)this.getFrameCount()) : (currentFrame >= quarterFrame && currentFrame < middleFrame ? (int)((double)r.x + (double)r.width * 2.0 * (double)(currentFrame - quarterFrame) / (double)this.getFrameCount()) : (currentFrame >= middleFrame && currentFrame < middleFrame + quarterFrame ? (int)((double)r.x + (double)r.width * 2.0 * (double)(middleFrame + quarterFrame - currentFrame) / (double)this.getFrameCount()) : (int)((double)r.x - (double)r.width * 2.0 * (double)(currentFrame - (middleFrame + quarterFrame)) / (double)this.getFrameCount())));
        return r;
    }

    private void _paintBackground(Graphics g, int x, int y, int w, int h) {
        String dir = "";
        dir = this.progressBar.getOrientation() == 0 ? "horizontal" : "vertical";
        ThemeProperties properties = Themes.getActiveTheme().getStateProperties("progressbar", dir);
        Painter determinate = properties.getPainter("bg");
        determinate.paint(g, x, y, w, h);
    }

    private void _paintDeterminateBorder(Graphics g, JComponent c) {
        if (this.progressBar.isBorderPainted()) {
            Insets b = this.progressBar.getInsets();
            int barRectWidth = this.progressBar.getWidth() - (b.left + b.right);
            int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            boolean isLeftToRight = c.getComponentOrientation().isLeftToRight();
            int startX = b.left;
            int startY = b.top;
            int endX = b.left + barRectWidth - 1;
            int endY = b.top + barRectHeight - 1;
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(1.0f));
            if (this.progressBar.getOrientation() == 0) {
                g2.setColor(MetalLookAndFeel.getControlShadow());
                g2.drawLine(startX, startY, endX, startY);
                if (amountFull > 0) {
                    g2.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                    if (isLeftToRight) {
                        g2.drawLine(startX, startY, startX + amountFull - 1, startY);
                    } else {
                        g2.drawLine(endX, startY, endX - amountFull + 1, startY);
                        if (this.progressBar.getPercentComplete() != 1.0) {
                            g2.setColor(MetalLookAndFeel.getControlShadow());
                        }
                    }
                }
                g2.drawLine(startX, startY, startX, endY);
            } else {
                g2.setColor(MetalLookAndFeel.getControlShadow());
                g2.drawLine(startX, startY, startX, endY);
                if (amountFull > 0) {
                    g2.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                    g2.drawLine(startX, endY, startX, endY - amountFull + 1);
                }
                g2.setColor(MetalLookAndFeel.getControlShadow());
                if (this.progressBar.getPercentComplete() == 1.0) {
                    g2.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                }
                g2.drawLine(startX, startY, endX, startY);
            }
        }
    }

    private void _paintInDeterminateBorder(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.left + b.right);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Rectangle box = null;
        box = this.getBox(box);
        int startX = b.left;
        int startY = b.top;
        int endX = b.left + barRectWidth - 1;
        int endY = b.top + barRectHeight - 1;
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f));
        if (this.progressBar.getOrientation() == 0) {
            g2.setColor(MetalLookAndFeel.getControlShadow());
            g2.drawLine(startX, startY, endX, startY);
            g2.drawLine(startX, startY, startX, endY);
            g2.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g2.drawLine(box.x, startY, box.x + box.width - 1, startY);
        } else {
            g2.setColor(MetalLookAndFeel.getControlShadow());
            g2.drawLine(startX, startY, startX, endY);
            g2.drawLine(startX, startY, endX, startY);
            g2.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g2.drawLine(startX, box.y, startX, box.y + box.height - 1);
        }
    }
}

