/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.olaf2.OracleTabbedPaneUI;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;
import sun.swing.SwingUtilities2;

public final class ThemedTabbedPaneUI
extends OracleTabbedPaneUI {
    private static final Class<MouseListener> _MOUSE_LISTENER_CLASS = MouseListener.class;
    private static final Class<MouseMotionListener> _MOUSE_MOTION_LISTENER_CLASS = MouseMotionListener.class;
    private Color _borderColor;
    private Listener _listener;

    public static ComponentUI createUI(JComponent component) {
        return new ThemedTabbedPaneUI();
    }

    protected void installDefaults() {
        if (Themes.isThemed()) {
            UIManager.put("TabbedPane.contentOpaque", Boolean.FALSE);
            ThemeProperties properties = Themes.getActiveTheme().getStateProperties("contenttab", "border");
            this._borderColor = properties.getColor("color");
        }
        super.installDefaults();
    }

    protected void installListeners() {
        this._listener = new Listener();
        super.installListeners();
        this.tabPane.addPropertyChangeListener(this._listener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removePropertyChangeListener(this._listener);
        this._listener = null;
    }

    protected void setRolloverTab(int index) {
        super.setRolloverTab(index);
        this.tabPane.repaint();
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        Insets insets = (Insets)this.tabPane.getClientProperty("tabInsets");
        if (insets != null) {
            return insets;
        }
        return super.getTabInsets(tabPlacement, tabIndex);
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        if (Themes.isThemed()) {
            ThemeProperties properties = Themes.getActiveTheme().getStateProperties("contenttab", "tabarea");
            return properties.getInsets("inset");
        }
        return super.getTabAreaInsets(tabPlacement);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean disabled;
        if (!Themes.isThemed()) {
            super.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
            return;
        }
        Rectangle tabRect = this.rects[tabIndex];
        int rollOverIndex = this.getRolloverTab();
        boolean isRollOver = rollOverIndex == tabIndex;
        boolean bl = disabled = !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(tabIndex);
        String stateId = disabled ? "disabled" : (isRollOver ? "mouseover" : (isSelected ? "selected" : "default"));
        String part = "";
        switch (this.tabPane.getTabPlacement()) {
            case 1: {
                part = "contenttab.top.";
                break;
            }
            case 3: {
                part = "contenttab.bottom.";
                break;
            }
            case 2: {
                part = "contenttab.left.";
                break;
            }
            case 4: {
                part = "contenttab.right.";
            }
        }
        ThemeProperties properties = Themes.getActiveTheme().getStateProperties(part + "center", stateId);
        properties.getPainter("bg").paint(g, tabRect.x, tabRect.y, tabRect.width, tabRect.height);
        properties = Themes.getActiveTheme().getStateProperties(part + "edge1", stateId);
        properties.getPainter("bg").paint(g, tabRect.x, tabRect.y, tabRect.width, tabRect.height);
        properties = Themes.getActiveTheme().getStateProperties(part + "edge2", stateId);
        properties.getPainter("bg").paint(g, tabRect.x, tabRect.y, tabRect.width, tabRect.height);
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (!Themes.isThemed()) {
            super.paintTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
            return;
        }
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rectangles, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (!Themes.isThemed()) {
            super.paintFocusIndicator(g, tabPlacement, rectangles, tabIndex, iconRect, textRect, isSelected);
            return;
        }
        if (this.tabPane.hasFocus() && isSelected) {
            g.setColor(UIManager.getColor("TabbedPane.focus"));
            Rectangle tabRect = this.rects[tabIndex];
            g.drawRect(tabRect.x, tabRect.y, tabRect.width - 1, tabRect.height - 1);
        }
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        if (!Themes.isThemed()) {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
            return;
        }
        if (!(this.getTextViewForTab(tabIndex) != null || this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex))) {
            g.setFont(font);
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            g.setColor(new Color(166, 166, 166));
            SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
        } else {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        }
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (!Themes.isThemed()) {
            super.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            return;
        }
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this._borderColor);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y, x + w - 1, y);
        } else {
            g.drawLine(x, y - 1, selRect.x, y - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width, y - 1, x + w - 1, y - 1);
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (!Themes.isThemed()) {
            super.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            return;
        }
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this._borderColor);
        if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x, y, x, y + h - 1);
        } else {
            g.drawLine(x - 1, y, x - 1, selRect.y - 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x - 1, selRect.y + selRect.height, x - 1, y + h - 1);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (!Themes.isThemed()) {
            super.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            return;
        }
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this._borderColor);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > y + h || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else {
            g.drawLine(x, y + h, selRect.x - 1, y + h);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width, y + h, x + w - 1, y + h);
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (!Themes.isThemed()) {
            super.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            return;
        }
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this._borderColor);
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > x + w || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        } else {
            g.drawLine(x + w, y, x + w, selRect.y - 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x + w, selRect.y + selRect.height, x + w, y + h - 2);
            }
        }
    }

    protected JButton createScrollButton(int direction) {
        if (!Themes.isThemed()) {
            return super.createScrollButton(direction);
        }
        if (direction != 5 && direction != 1 && direction != 3 && direction != 7) {
            throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
        }
        ScrollableTabButton scrollButton = new ScrollableTabButton();
        if (Themes.isThemed()) {
            String dir = "";
            switch (direction) {
                case 7: {
                    dir = "scrollabletabbutton.west";
                    break;
                }
                case 3: {
                    dir = "scrollabletabbutton.east";
                    break;
                }
                case 5: {
                    dir = "scrollabletabbutton.south";
                    break;
                }
                case 1: {
                    dir = "scrollabletabbutton.north";
                }
            }
            ThemeProperties tp = Themes.getActiveTheme().getStateProperties(dir, "default");
            scrollButton.setIcon(tp.getIcon("icon"));
            tp = Themes.getActiveTheme().getStateProperties(dir, "disabled");
            scrollButton.setDisabledIcon(tp.getIcon("icon"));
            tp = Themes.getActiveTheme().getStateProperties(dir, "over");
            scrollButton.setRolloverIcon(tp.getIcon("icon"));
            tp = Themes.getActiveTheme().getStateProperties(dir, "pressed");
            scrollButton.setPressedIcon(tp.getIcon("icon"));
        }
        return scrollButton;
    }

    private class Listener
    extends MouseAdapter
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            Component c;
            if (pe.getPropertyName() == "indexForTabComponent" && (c = ThemedTabbedPaneUI.this.tabPane.getTabComponentAt((Integer)pe.getNewValue())) != null) {
                c.addMouseMotionListener(this);
                c.addMouseListener(this);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this._retarget(e, _MOUSE_LISTENER_CLASS);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._retarget(e, _MOUSE_LISTENER_CLASS);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this._retarget(e, _MOUSE_LISTENER_CLASS);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ThemedTabbedPaneUI.this.setRolloverTab(ThemedTabbedPaneUI.this.tabPane.indexOfTabComponent(e.getComponent()));
            this._retarget(e, _MOUSE_LISTENER_CLASS);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ThemedTabbedPaneUI.this.setRolloverTab(ThemedTabbedPaneUI.this.tabPane.indexOfTabComponent(e.getComponent()));
            this._retarget(e, _MOUSE_LISTENER_CLASS);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this._retarget(e, _MOUSE_MOTION_LISTENER_CLASS);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ThemedTabbedPaneUI.this.setRolloverTab(ThemedTabbedPaneUI.this.tabPane.indexOfTabComponent(e.getComponent()));
            this._retarget(e, _MOUSE_MOTION_LISTENER_CLASS);
        }

        private void _retarget(MouseEvent e, Class type) {
            if (this._isOnlyListener(e, type)) {
                MouseEvent me = SwingUtilities.convertMouseEvent(e.getComponent(), e, ThemedTabbedPaneUI.this.tabPane);
                ThemedTabbedPaneUI.this.tabPane.dispatchEvent(me);
            }
        }

        private boolean _isOnlyListener(MouseEvent e, Class type) {
            boolean isOnlyListener = true;
            Component component = e.getComponent();
            if (component != null) {
                EventListener[] listeners;
                for (EventListener listener : listeners = component.getListeners(type)) {
                    if (listener == this) continue;
                    isOnlyListener = false;
                    break;
                }
            } else {
                isOnlyListener = false;
            }
            return isOnlyListener;
        }
    }

    private class ScrollableTabButton
    extends JButton
    implements UIResource {
        public ScrollableTabButton() {
            this.setFocusable(false);
            this.setOpaque(false);
            this.setAlignmentY(1.0f);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setForeground(new Color(102, 102, 102));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
            this.setRequestFocusEnabled(false);
            this.setContentAreaFilled(false);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }
    }
}

