/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;

public final class ThemedTableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer _originalHeaderRenderer;
    private int rolloverColumn = -1;

    public static ComponentUI createUI(JComponent h) {
        return new ThemedTableHeaderUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (Themes.isThemed()) {
            this._originalHeaderRenderer = this.header.getDefaultRenderer();
            if (this._originalHeaderRenderer instanceof UIResource) {
                this.header.setDefaultRenderer(new ThemedDefaultRenderer());
            }
        }
    }

    private void updateRolloverColumn(MouseEvent e) {
        int col;
        if (this.header.getDraggedColumn() == null && this.header.contains(e.getPoint()) && (col = this.header.columnAtPoint(e.getPoint())) != this.rolloverColumn) {
            this.rolloverColumn = col;
            this.header.repaint();
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        if (Themes.isThemed()) {
            return new BasicTableHeaderUI.MouseInputHandler(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    super.mouseMoved(e);
                    ThemedTableHeaderUI.this.updateRolloverColumn(e);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    super.mouseEntered(e);
                    ThemedTableHeaderUI.this.updateRolloverColumn(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    super.mouseExited(e);
                    ThemedTableHeaderUI.this.rolloverColumn = -1;
                    ThemedTableHeaderUI.this.header.repaint();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    if (ThemedTableHeaderUI.this.header.getReorderingAllowed()) {
                        ThemedTableHeaderUI.this.rolloverColumn = -1;
                        ThemedTableHeaderUI.this.header.repaint();
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    super.mouseDragged(e);
                    ThemedTableHeaderUI.this.updateRolloverColumn(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    ThemedTableHeaderUI.this.updateRolloverColumn(e);
                }
            };
        }
        return super.createMouseInputListener();
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.header.getDefaultRenderer() instanceof ThemedDefaultRenderer) {
            this.header.setDefaultRenderer(this._originalHeaderRenderer);
        }
        super.uninstallUI(c);
    }

    private class ThemedDefaultRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        final Theme theme = Themes.getActiveTheme();
        boolean isSelected;
        boolean hasFocus;
        boolean hasRollover;
        int column;

        private ThemedDefaultRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setFont(header.getFont());
            }
            this.isSelected = isSelected;
            this.hasFocus = hasFocus;
            this.column = column;
            this.hasRollover = column == ThemedTableHeaderUI.this.rolloverColumn;
            this.setText(value == null ? "" : value.toString());
            this.setBorder(new EmptyBorder(this.theme.getPartProperties("tableheader").getInsets("contentmargin")));
            return this;
        }

        private int viewIndexForColumn(TableColumn aColumn) {
            TableColumnModel cm = ThemedTableHeaderUI.this.header.getColumnModel();
            for (int column = 0; column < cm.getColumnCount(); ++column) {
                if (cm.getColumn(column) != aColumn) continue;
                return column;
            }
            return -1;
        }

        @Override
        public void paint(Graphics g) {
            Dimension size = this.getSize();
            String state = "normal";
            if (ThemedTableHeaderUI.this.header == null) {
                return;
            }
            if (this.column == this.viewIndexForColumn(ThemedTableHeaderUI.this.header.getDraggedColumn())) {
                state = "mousedown";
            } else if (this.isSelected || this.hasFocus || this.hasRollover) {
                state = "mouseover";
            }
            this.theme.getStateProperties("tableheader", state).getPainter("bg").paint(g, 0, 0, size.width, size.height);
            super.paint(g);
        }
    }
}

