/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.ui.themes.Themes;

public class ThemedToolBarButtonUI
extends IconicButtonUI {
    private static final ThemedToolBarButtonUI INSTANCE = new ThemedToolBarButtonUI();
    private static Insets insets = new Insets(0, 0, 0, 0);
    private String prefixName;

    public static ComponentUI createUI(JComponent component) {
        return INSTANCE;
    }

    private boolean isEditorToolbar(AbstractButton b) {
        boolean editorToolbar = false;
        if (b.getParent() != null && b.getParent() instanceof JComponent && ((JComponent)b.getParent()).getClientProperty("isPrimary") == Boolean.TRUE || ((JComponent)b.getParent()).getClientProperty("isSecondary") == Boolean.TRUE) {
            editorToolbar = true;
        }
        return editorToolbar;
    }

    private String getToolbarPrefixName(AbstractButton b) {
        if (b.getParent() != null && b.getParent().getClass().getName().contains("org.openide.awt.Toolbar")) {
            return "main.";
        }
        return "";
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (Themes.isThemed() && this.isEditorToolbar(b)) {
            b.setRolloverEnabled(true);
            if (b.getText() != null && b.getText().length() > 0) {
                Insets innerInsets = Themes.getActiveTheme().getPartProperties("toolbarbutton").getInsets("innermargin");
                b.setBorder(BorderFactory.createCompoundBorder(b.getBorder(), BorderFactory.createEmptyBorder(innerInsets.top, innerInsets.left, innerInsets.bottom, innerInsets.right)));
            }
        }
        this.prefixName = this.getToolbarPrefixName(b);
        insets = Themes.getActiveTheme().getPartProperties("toolbarbutton").getInsets("outermargin");
    }

    @Override
    protected void paintThemeBackground(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (this.prefixName.length() > 0) {
            this.paintButton(this._getState(b), c, g);
        } else if (b.getIcon() != null && (b.getText() == null || b.getText().length() == 0)) {
            super.paintThemeBackground(g, c);
        } else if (this.isEditorToolbar(b)) {
            String state = this._getState(b);
            this.paintButton(state, c, g);
            if (b.hasFocus() && b.isFocusPainted()) {
                state = "focus";
                Themes.getActiveTheme().getStateProperties("toolbarbutton.edge1", state).getPainter("bg").paint(g, 0, 0, c.getWidth(), c.getHeight());
                Themes.getActiveTheme().getStateProperties("toolbarbutton.edge2", state).getPainter("bg").paint(g, 0, 0, c.getWidth() - 1, c.getHeight());
                Themes.getActiveTheme().getStateProperties("toolbarbutton.edge3", state).getPainter("bg").paint(g, ThemedToolBarButtonUI.insets.left, 0, c.getWidth() - ThemedToolBarButtonUI.insets.left - ThemedToolBarButtonUI.insets.right, c.getHeight());
                Themes.getActiveTheme().getStateProperties("toolbarbutton.edge4", state).getPainter("bg").paint(g, ThemedToolBarButtonUI.insets.left, 0, c.getWidth() - ThemedToolBarButtonUI.insets.left - ThemedToolBarButtonUI.insets.right, c.getHeight());
            }
        } else {
            super.paintThemeBackground(g, c);
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!this.isEditorToolbar(b)) {
            super.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (!Themes.isThemed()) {
            super.paintButtonPressed(g, b);
        } else if (b.isContentAreaFilled()) {
            this.paintThemeBackground(g, b);
        }
    }

    private String _getState(AbstractButton b) {
        String state = "default";
        if (!b.isEnabled()) {
            state = "disabled";
        }
        if (b.getModel().isArmed() && b.getModel().isPressed()) {
            state = "down";
        } else if (b.getModel().isRollover()) {
            state = "over";
        } else if (b instanceof JButton && ((JButton)b).isDefaultButton()) {
            state = "defaultbutton";
        } else if (b.getModel().isSelected()) {
            state = "selected";
        }
        String captureState = (String)b.getClientProperty("capture");
        if (captureState != null && this.prefixName.length() > 0) {
            state = captureState;
        }
        return state;
    }

    private void paintButton(String state, JComponent c, Graphics g) {
        Themes.getActiveTheme().getStateProperties(this.prefixName + "toolbarbutton.edge1", state).getPainter("bg").paint(g, 0, 0, c.getWidth(), c.getHeight());
        Themes.getActiveTheme().getStateProperties(this.prefixName + "toolbarbutton.edge2", state).getPainter("bg").paint(g, 0, 0, c.getWidth() - 1, c.getHeight());
        Themes.getActiveTheme().getStateProperties(this.prefixName + "toolbarbutton.edge3", state).getPainter("bg").paint(g, ThemedToolBarButtonUI.insets.left, 0, c.getWidth() - ThemedToolBarButtonUI.insets.left - ThemedToolBarButtonUI.insets.right, c.getHeight());
        Themes.getActiveTheme().getStateProperties(this.prefixName + "toolbarbutton.edge4", state).getPainter("bg").paint(g, ThemedToolBarButtonUI.insets.left, 0, c.getWidth() - ThemedToolBarButtonUI.insets.left - ThemedToolBarButtonUI.insets.right, c.getHeight());
        Themes.getActiveTheme().getStateProperties(this.prefixName + "toolbarbutton.center", state).getPainter("bg").paint(g.create(), ThemedToolBarButtonUI.insets.left, ThemedToolBarButtonUI.insets.top, c.getWidth() - ThemedToolBarButtonUI.insets.left - ThemedToolBarButtonUI.insets.right, c.getHeight() - ThemedToolBarButtonUI.insets.top - ThemedToolBarButtonUI.insets.bottom);
    }
}

