/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.ui.search.BasicSearchFieldUI;
import oracle.javatools.ui.search.PromptedTextField;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchFieldUI;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchProgress;
import oracle.javatools.ui.search.SlideTip;
import oracle.javatools.ui.search.ThemedSearchFieldUI;
import oracle.javatools.ui.themes.Themes;
import org.jdesktop.animation.timing.Cycle;
import org.jdesktop.animation.timing.Envelope;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.TimingTarget;

public final class SearchField
extends JPanel {
    private final JPanel _searchPanel;
    private final JButton _searchButton = new DropDownButton();
    private final PromptedTextField _textField;
    private final JLabel _infoLabel = new JLabel("Hi");
    private final JPanel _insideFieldButtonPanel = new JPanel();
    private final JPanel _outsideFieldButtonPanel = new JPanel();
    private final CancelButton _cancelButton = new CancelButton();
    private final JButton _previousButton = new JButton();
    private final JButton _nextButton = new JButton();
    private final List<SearchCategory> _categories = new ArrayList<SearchCategory>();
    private final List<JMenuItem> _extraItems = new ArrayList<JMenuItem>();
    private transient SearchCategory _selectedCategory;
    private final Timer _searchTimer;
    private String _lastSearch;
    private final List<SearchListener> _listeners = new CopyOnWriteArrayList<SearchListener>();
    private Style _style;
    private TypingDelay _typingDelay;
    private JPopupMenu categoryMenu = new JPopupMenu();
    private boolean _allowEmptySearch = false;
    private boolean _isSearching = false;
    private boolean _isAdjusting = false;
    private transient SearchProgress _searchProgress;
    private float _indeterminateProgress = -1.0f;
    private final Action _clearAction;
    private final Action _findNextAction;
    private final Action _findPreviousAction;
    private final Action _categoryDropDownAction;
    private AWTEventListener _awtListener;
    private boolean _popupAlreadyShown;
    private Component _keyEventTargetComponent;
    private boolean _notifyOnEmptySearch = false;
    private boolean _autoFind = false;
    private static final String CATEGORY_DROP_DOWN_ACTION_ID = "categoryDropDownAction";
    private static final String FIND_NEXT_ACTION_ID = "findNextAction";
    private static final String FIND_PREVIOUS_ACTION_ID = "findPreviousAction";
    private static final String CLEAR_ACTION_ID = "clearAction";
    private transient SlideTip _searchWrappedTip = new SlideTip();
    private transient SlideTip _searchFailedTip = new SlideTip();

    public SearchField() {
        this(new PromptedTextField(), true);
    }

    public SearchField(Style style) {
        this(new PromptedTextField(), true);
        this.setStyle(style);
    }

    public SearchField(PromptedTextField textField) {
        this(textField, true);
    }

    public SearchField(PromptedTextField textField, Style style) {
        this(textField, true);
        this.setStyle(style);
    }

    private SearchField(PromptedTextField textField, boolean buttonsInsideField) {
        this.updateUI();
        this._textField = textField;
        this._textField.setMinimumSize(new Dimension(25, 0));
        this._getUI().configureTextField(this._textField);
        this._clearAction = this.createClearAction();
        this._findNextAction = this.createFindNextAction();
        this._findPreviousAction = this.createFindPreviousAction();
        this._categoryDropDownAction = this.createCategoryDropDownAction();
        this._cancelButton.setAction(this._clearAction);
        this._nextButton.setAction(this._findNextAction);
        this._previousButton.setAction(this._findPreviousAction);
        this._searchButton.setModel(new DropDownModel());
        this.setPopDownAction(this._categoryDropDownAction);
        this._awtListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event.getSource() == SearchField.this._searchButton && event.getID() == 501) {
                    JPopupMenu popup = SearchField.this.getCategoriesPopup();
                    SearchField.this._popupAlreadyShown = popup != null ? popup.isVisible() : false;
                }
            }
        };
        this._searchButton.putClientProperty(UIConstants.VETO_CONVERSION, true);
        this._cancelButton.putClientProperty(UIConstants.VETO_CONVERSION, true);
        this._nextButton.putClientProperty(UIConstants.VETO_CONVERSION, true);
        this._previousButton.putClientProperty(UIConstants.VETO_CONVERSION, true);
        this._infoLabel.putClientProperty(UIConstants.VETO_CONVERSION, true);
        this._infoLabel.setForeground(UIManager.getColor("Label.disabledForeground"));
        this.setInfoText(null);
        this._searchPanel = this._getUI().createSearchPanel();
        this.setOpaque(false);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this._searchPanel, "Center");
        if (!buttonsInsideField) {
            this.add((Component)this._outsideFieldButtonPanel, "East");
        }
        this._searchPanel.setLayout((LayoutManager)new MigLayout("ins 0, gap 0 0, fillx, nogrid, hidemode 2"));
        this._searchPanel.add((Component)this._searchButton, "dock west");
        this._searchPanel.add((Component)this._textField, "growx 100");
        if (buttonsInsideField) {
            JPanel tmp = new JPanel();
            tmp.setLayout(new BorderLayout());
            tmp.setOpaque(false);
            tmp.add((Component)this._insideFieldButtonPanel, "West");
            tmp.add((Component)this._outsideFieldButtonPanel, "East");
            this._searchPanel.add((Component)tmp, "dock east");
        } else {
            this._searchPanel.add((Component)this._insideFieldButtonPanel, "dock east");
        }
        this._insideFieldButtonPanel.setLayout(new BorderLayout(3, 0));
        this._insideFieldButtonPanel.setOpaque(false);
        this._insideFieldButtonPanel.add(this._cancelButton);
        this._insideFieldButtonPanel.add((Component)this._infoLabel, "East");
        this._outsideFieldButtonPanel.setLayout(new BorderLayout());
        this._outsideFieldButtonPanel.setOpaque(false);
        this._cancelButton.setHidden(false);
        this._cancelButton.setVisible(this.getStyle() == Style.FILTER);
        this._nextButton.setVisible(false);
        this._previousButton.setVisible(false);
        this.configureIconicButton(this._searchButton);
        this._getUI().configureSearchButton(this._searchButton);
        this._cancelButton.setRolloverIcon(this._getUI().getCancelIcon(true));
        this._cancelButton.putClientProperty("iconicButtonNoBackground", Boolean.TRUE);
        this.configureIconicButton(this._cancelButton, this._getUI().getCancelIcon(false), null);
        this.configureIconicButton(this._previousButton, this._getUI().getPreviousIcon(true), this._getUI().getPreviousIcon(false), UIBundle.get("PREVIOUS_MATCH"));
        this._outsideFieldButtonPanel.add((Component)this._nextButton, "West");
        this._outsideFieldButtonPanel.add((Component)this._previousButton, "East");
        ActionListener timerListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SearchField.this.isFiringEventsOnKeypress()) {
                    SearchField.this.fireSearchPerformed(SearchEvent.Direction.FORWARD, true);
                }
            }
        };
        this._searchTimer = new Timer(0, timerListener);
        this._searchTimer.setRepeats(false);
        this._searchTimer.setCoalesce(true);
        this.setStyle(Style.FILTER);
        this.setTypingDelay(TypingDelay.FAST);
        this._textField.getDocument().addDocumentListener(new DocumentListener(){

            private void update() {
                if (SearchField.this._isAdjusting) {
                    return;
                }
                if (SearchField.this.isFiringEventsOnKeypress()) {
                    SearchField.this._searchTimer.stop();
                    SearchField.this._searchTimer.start();
                } else {
                    SearchField.this.updateButtons();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }
        });
        this._searchButton.setBorder(new EmptyBorder(0, 0, 0, 3));
        this.installKeyboard();
        this.addPropertyChangeListener("allowEmptySearch", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SearchField.this.updateButtons();
            }
        });
        this.setNotifyOnEmptySearch(true);
    }

    @Override
    public void updateUI() {
        if (Themes.isThemed()) {
            this.setUI(new ThemedSearchFieldUI());
        } else {
            this.setUI(new BasicSearchFieldUI());
        }
    }

    private SearchFieldUI _getUI() {
        return (SearchFieldUI)this.ui;
    }

    public void setNotifyOnEmptySearch(boolean notifyOnEmptySearch) {
        this._notifyOnEmptySearch = notifyOnEmptySearch;
    }

    public void setKeyEventTargetComponent(Component c) {
        if (c == this._keyEventTargetComponent) {
            return;
        }
        Component old = this._keyEventTargetComponent;
        this._keyEventTargetComponent = c;
        this.firePropertyChange("keyEventTargetComponent", old, c);
    }

    public Component getKeyEventTargetComponent() {
        return this._keyEventTargetComponent;
    }

    @Override
    public void setForeground(Color color) {
        if (this.getTextField() != null) {
            this.getTextField().setForeground(color);
        }
    }

    private boolean isFiringEventsOnKeypress() {
        return this.getStyle() == Style.FILTER || this.isAutoFind() && this.getStyle() == Style.FIND;
    }

    private void installKeyboard() {
        this.installFindNextKeyStroke(KeyStroke.getKeyStroke("ENTER"));
        this.installFindNextKeyStroke(KeyStroke.getKeyStroke("DOWN"));
        this.installFindPreviousKeyStroke(KeyStroke.getKeyStroke("shift ENTER"));
        this.installFindPreviousKeyStroke(KeyStroke.getKeyStroke("UP"));
        this.getActionMap().put(FIND_NEXT_ACTION_ID, this._findNextAction);
        this.getActionMap().put(FIND_PREVIOUS_ACTION_ID, this._findPreviousAction);
        this.getActionMap().put(CLEAR_ACTION_ID, this._clearAction);
    }

    public void installFindNextKeyStroke(KeyStroke keyStroke) {
        this.getInputMap(1).put(keyStroke, FIND_NEXT_ACTION_ID);
    }

    public void installFindPreviousKeyStroke(KeyStroke keyStroke) {
        this.getInputMap(1).put(keyStroke, FIND_PREVIOUS_ACTION_ID);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._textField.setEnabled(enabled);
        this._searchButton.setEnabled(enabled);
        this._cancelButton.setEnabled(enabled);
        this._previousButton.setEnabled(enabled);
        this._nextButton.setEnabled(enabled);
        if (enabled) {
            this.updateButtons();
        }
    }

    private Action createClearAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SearchField.this.getStyle() == Style.FILTER) {
                    SearchField.this.clear();
                }
            }
        };
    }

    private Action createFindNextAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchField.this.getStyle() == Style.FIND) {
                    SearchField.this.fireSearchPerformed(SearchEvent.Direction.FORWARD, false);
                } else if (SearchField.this.getStyle() == Style.SEARCH) {
                    if (SearchField.this._isSearching) {
                        if (SearchField.this._searchProgress == null) {
                            throw new IllegalStateException("No progress object while searching!");
                        }
                        SearchField.this._searchProgress.setStopped(true);
                        SearchField.this._nextButton.setEnabled(false);
                    } else {
                        SearchField.this.fireSearchPerformed(SearchEvent.Direction.FORWARD, false);
                    }
                }
            }
        };
    }

    private Action createFindPreviousAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchField.this.getStyle() == Style.FILTER) {
                    return;
                }
                SearchField.this.fireSearchPerformed(SearchEvent.Direction.BACKWARD, false);
            }
        };
    }

    private Action createCategoryDropDownAction() {
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchField.this._categories.isEmpty() && SearchField.this._extraItems.isEmpty()) {
                    return;
                }
                SearchField.this.categoryMenu.removeAll();
                if (!SearchField.this._categories.isEmpty()) {
                    ButtonGroup bg = new ButtonGroup();
                    for (SearchCategory c : SearchField.this._categories) {
                        JRadioButtonMenuItem item = new JRadioButtonMenuItem(new SearchCategoryAction(c));
                        bg.add(item);
                        SearchField.this.categoryMenu.add(item);
                        item.setSelected(SearchField.this._selectedCategory == c);
                    }
                }
                if (!SearchField.this._categories.isEmpty() && !SearchField.this._extraItems.isEmpty()) {
                    SearchField.this.categoryMenu.addSeparator();
                }
                for (JMenuItem item : SearchField.this._extraItems) {
                    SearchField.this.categoryMenu.add(item);
                }
                SearchField.this.categoryMenu.show(SearchField.this._searchButton, 0, SearchField.this._searchButton.getHeight());
            }
        };
        a.putValue("SmallIcon", this._getUI().getSearchPopupIcon());
        return a;
    }

    public void showSearchWrapped() {
        this._searchWrappedTip.setText("The find wrapped");
        this._searchWrappedTip.show(this._textField.getBounds().x, this, 3000);
    }

    public void showSearchFailed() {
        this._searchFailedTip.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this._searchFailedTip.setText("Not found");
        this._searchFailedTip.show(this._textField.getBounds().x, this, 5000);
    }

    public JPopupMenu getCategoriesPopup() {
        return this.categoryMenu;
    }

    public void setCategoriesPopup(JPopupMenu menu) {
        this.categoryMenu = menu;
    }

    public void setAutoFind(boolean autoFind) {
        if (this._autoFind != autoFind) {
            this._autoFind = autoFind;
            this.firePropertyChange("autoFind", !this._autoFind, this._autoFind);
        }
    }

    public void setAllowEmptySearch(boolean allowEmptySearch) {
        if (this._allowEmptySearch != allowEmptySearch) {
            this._allowEmptySearch = allowEmptySearch;
            this.firePropertyChange("allowEmptySearch", !this._allowEmptySearch, this._allowEmptySearch);
        }
    }

    public boolean isAutoFind() {
        return this._autoFind;
    }

    public boolean isAllowEmptySearch() {
        return this._allowEmptySearch;
    }

    public void clear() {
        try {
            String textBeforeCancel = this._textField.getText();
            this._textField.getDocument().remove(0, this._textField.getDocument().getLength());
            this._searchTimer.stop();
            this.fireSearchCleared(textBeforeCancel);
            this.fireSearchPerformed(SearchEvent.Direction.FORWARD, false);
        }
        catch (BadLocationException ble) {
            throw new IllegalStateException(ble);
        }
    }

    public void setStyle(Style style) {
        if (style == null) {
            throw new NullPointerException("style is null");
        }
        Style oldStyle = this._style;
        if (oldStyle != style) {
            this._style = style;
            this.updateButtons();
            this.firePropertyChange("style", (Object)oldStyle, (Object)style);
            this.setText("");
            this._lastSearch = null;
        }
        this._cancelButton.setVisible(style == Style.FILTER);
    }

    public Style getStyle() {
        return this._style != null ? this._style : Style.FILTER;
    }

    public void setPopDownAction(Action action) {
        Object oldCommand;
        KeyStroke oldKeyStroke;
        if (action == null) {
            throw new NullPointerException("action is null");
        }
        InputMap inputMap = this.getInputMap(1);
        Action oldAction = this._searchButton.getAction();
        if (oldAction != null && (oldKeyStroke = (KeyStroke)oldAction.getValue("AcceleratorKey")) != null && (oldCommand = inputMap.get(oldKeyStroke)) != null) {
            this.getActionMap().remove(oldCommand);
        }
        this._searchButton.setAction(action);
        Icon disabledIcon = (Icon)action.getValue("SmallIcon");
        if (disabledIcon == null) {
            throw new IllegalArgumentException("Action must have an icon");
        }
        this._searchButton.setIcon(this._getUI().getSearchIcon(disabledIcon, true));
        this._searchButton.setDisabledIcon(this._getUI().getSearchIcon(disabledIcon, false));
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keyStroke == null) {
            keyStroke = KeyStroke.getKeyStroke("alt DOWN");
        }
        inputMap.put(keyStroke, CATEGORY_DROP_DOWN_ACTION_ID);
        this.getActionMap().put(CATEGORY_DROP_DOWN_ACTION_ID, action);
        this.updateButtons();
    }

    public final Action getPopDownAction() {
        return this._searchButton.getAction();
    }

    public void addCategoryMenuItem(JMenuItem item) {
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this._extraItems.add(item);
        this.updateButtons();
    }

    public void removeCategoryMenuItem(JMenuItem item) {
        this._extraItems.remove(item);
        this.updateButtons();
    }

    public void clearCategoryMenuItems() {
        this._extraItems.clear();
        this.updateButtons();
    }

    public void addCategory(SearchCategory category) {
        if (category == null) {
            throw new NullPointerException("category is null");
        }
        this._categories.add(category);
        if (this._categories.size() == 1) {
            this.setSelectedCategory(category);
        }
        this.updateButtons();
    }

    public void removeCategory(SearchCategory category) {
        this._categories.remove(category);
        if (category != null && category.equals(this._selectedCategory)) {
            if (this._categories.size() == 0) {
                this.setSelectedCategory(null);
            } else {
                this.setSelectedCategory(this._categories.get(0));
            }
        }
        this.updateButtons();
    }

    public void clearCategories() {
        this._categories.clear();
        this.setSelectedCategory(null);
        this.updateButtons();
    }

    public SearchCategory getSelectedCategory() {
        return this._selectedCategory;
    }

    public void setSelectedCategory(SearchCategory selectedCategory) {
        if (selectedCategory == null && !this._categories.isEmpty()) {
            throw new IllegalStateException("Cannot set selected category to null when there are categories");
        }
        if (!this._categories.contains(selectedCategory) && selectedCategory != null) {
            throw new IllegalArgumentException("Category " + selectedCategory + " has not been added.");
        }
        SearchCategory old = this._selectedCategory;
        if ((old == null || selectedCategory == null) && old != selectedCategory || old != null && !old.equals(selectedCategory)) {
            this._selectedCategory = selectedCategory;
            this.updateButtons();
            this.firePropertyChange("selectedCategory", old, selectedCategory);
            this.fireSearchCategoryChanged();
        }
        this.getTextField().setToolTipText(this._selectedCategory != null ? this._selectedCategory.getLabel() : "");
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 27) {
            boolean isEscapeOverridden;
            InputMap map = this.getInputMap(condition);
            boolean bl = isEscapeOverridden = map != null && map.get(ks) != null;
            if (this.processEscapeKey(e) && !isEscapeOverridden) {
                return true;
            }
        }
        boolean processed = super.processKeyBinding(ks, e, condition, pressed);
        if (this._keyEventTargetComponent == null) {
            return processed;
        }
        try {
            e.setSource(this._keyEventTargetComponent);
            Method processKeyEvent = JComponent.class.getDeclaredMethod("processKeyEvent", KeyEvent.class);
            processKeyEvent.setAccessible(true);
            processKeyEvent.invoke((Object)this._keyEventTargetComponent, e);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return e.isConsumed();
    }

    private boolean processEscapeKey(KeyEvent e) {
        if (!this.isEnabled() || !this.hasSearchText()) {
            return false;
        }
        Action action = this.getActionMap().get(CLEAR_ACTION_ID);
        if (action == null) {
            return false;
        }
        KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        return SwingUtilities.notifyAction(action, stroke, e, this, e.getModifiers());
    }

    private void updateCategoriesAction() {
        if (this._categoryDropDownAction != null) {
            boolean haveCategories = !this._categories.isEmpty() || !this._extraItems.isEmpty();
            this._categoryDropDownAction.setEnabled(haveCategories);
        }
    }

    private void updateButtons() {
        this.updateCategoriesAction();
        Boolean wasEnabled = (Boolean)this._searchButton.getClientProperty("enabledState");
        Action action = this._searchButton.getAction();
        if (action != null) {
            boolean isEnabled;
            boolean bl = isEnabled = action.isEnabled() || this._allowEmptySearch && this.getStyle() == Style.SEARCH;
            if (wasEnabled == null || wasEnabled != isEnabled) {
                this._searchButton.putClientProperty("iconicButtonUIActive", isEnabled);
                action.setEnabled(!isEnabled);
                action.setEnabled(isEnabled);
            }
        }
        boolean haveSearch = this._textField.getDocument().getLength() != 0;
        this._nextButton.setVisible(haveSearch && this.getStyle() == Style.FIND || this.getStyle() == Style.SEARCH);
        this._previousButton.setVisible(haveSearch && this.getStyle() == Style.FIND);
        if (haveSearch) {
            this._cancelButton.setHidden(this.getStyle() != Style.FILTER);
        } else {
            this._cancelButton.setHidden(true);
        }
        if (this.getSelectedCategory() != null) {
            this.setPrompt(this.getSelectedCategory().getLabel());
        } else if (this._categories.size() > 0) {
            this.setPrompt("");
        }
        switch (this.getStyle()) {
            case SEARCH: {
                if (this._isSearching) {
                    this.configureIconicButton(this._nextButton, this._getUI().getSearchingIcon(), null, UIBundle.get("STOP_SEARCH"));
                    break;
                }
                if (haveSearch) {
                    this.configureIconicButton(this._nextButton, this._getUI().getSearchHaveTextIcon(), null, UIBundle.get("START_SEARCH"));
                    break;
                }
                this.configureIconicButton(this._nextButton, this._getUI().getSearchDefaultIcon(), null, UIBundle.get("START_SEARCH"));
                break;
            }
            case FIND: {
                this.configureIconicButton(this._nextButton, this._getUI().getFindNextIcon(true), this._getUI().getFindNextIcon(false), UIBundle.get("NEXT_MATCH"));
            }
        }
        this._nextButton.setEnabled(haveSearch || this._isSearching && !this._searchProgress.isStopped());
        this._previousButton.setEnabled(haveSearch);
        this._previousButton.setBorder(this._getUI().getPreviousBorder());
        this._nextButton.setBorder(this._getUI().getNextBorder());
    }

    private boolean hasSearchText() {
        return this._textField.getText().length() > 0;
    }

    private boolean shouldIgnoreEmptySearch() {
        return this.getStyle() == Style.SEARCH && !this._allowEmptySearch || this.getStyle() == Style.FIND && !this._notifyOnEmptySearch;
    }

    protected final void fireSearchPerformed(SearchEvent.Direction direction, boolean keypress) {
        if (this._listeners.isEmpty()) {
            return;
        }
        if (this.shouldIgnoreEmptySearch() && !this.hasSearchText()) {
            return;
        }
        String searchText = this._textField.getText();
        if (this.getStyle() == Style.FILTER && (searchText = searchText.replaceAll("^\\s+", "")).equals(this._lastSearch)) {
            return;
        }
        this._lastSearch = searchText;
        if (this.getStyle() == Style.SEARCH) {
            this.startSearchAnimation();
        }
        SearchEvent event = new SearchEvent(this, searchText, this.getSelectedCategory(), this._searchProgress, direction, keypress);
        for (SearchListener listener : this._listeners) {
            listener.searchPerformed(event);
        }
        this.updateButtons();
    }

    private void startSearchAnimation() {
        this._indeterminateProgress = 0.0f;
        TimingTarget tgt = new TimingTarget(){

            public void end() {
            }

            public void begin() {
            }

            public void timingEvent(long l, long l1, float fraction) {
                SearchField.this._indeterminateProgress = fraction * 1.0f;
                SearchField.this.repaint();
            }
        };
        final TimingController controller = new TimingController(new Cycle(2000, 30), new Envelope(-1.0, 0, Envelope.RepeatBehavior.FORWARD, Envelope.EndBehavior.RESET), tgt);
        controller.start();
        this._searchProgress = new SearchProgress(){

            @Override
            public void setProgress(int progress) {
                super.setProgress(progress);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        controller.stop();
                        SearchField.this._indeterminateProgress = -1.0f;
                        SearchField.this.repaint();
                    }
                });
            }

            @Override
            public void finish() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchField.this._isSearching = false;
                        SearchField.this._searchProgress = null;
                        controller.stop();
                        SearchField.this._indeterminateProgress = -1.0f;
                        SearchField.this.repaint();
                        SearchField.this.updateButtons();
                    }
                });
            }
        };
        this._isSearching = true;
    }

    protected final void fireSearchCategoryChanged() {
        if (!this.hasSearchText() || this._listeners.isEmpty()) {
            return;
        }
        SearchEvent event = new SearchEvent(this, this._textField.getText(), this.getSelectedCategory(), null, SearchEvent.Direction.FORWARD, false);
        for (SearchListener listener : this._listeners) {
            listener.searchCategoryChanged(event);
        }
    }

    protected final void fireSearchCleared(String textBeforeClear) {
        SearchEvent event = new SearchEvent(this, textBeforeClear, true);
        for (SearchListener listener : this._listeners) {
            listener.searchPerformed(event);
        }
    }

    public void addSearchListener(SearchListener sl) {
        if (sl == null) {
            throw new NullPointerException("sl is null");
        }
        this._listeners.add(sl);
    }

    public void removeSearchListener(SearchListener sl) {
        this._listeners.remove(sl);
    }

    public void setPrompt(String prompt) {
        this._textField.setPrompt(prompt);
    }

    public void setTypingDelay(TypingDelay delay) {
        if (delay == null) {
            throw new NullPointerException("delay is null");
        }
        if (this._typingDelay != delay) {
            TypingDelay old = this._typingDelay;
            this._typingDelay = delay;
            this._typingDelay.configureSearchField(this);
            this.firePropertyChange("typingDelay", (Object)old, (Object)delay);
        }
    }

    public TypingDelay getTypingDelay() {
        return this._typingDelay;
    }

    private void setTimerDelay(TimeUnit unit, long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("delay " + delay + " is invalid. Must be >= 0.");
        }
        long delayInMillis = unit.toMillis(delay);
        this._searchTimer.setDelay((int)delayInMillis);
        this._searchTimer.setInitialDelay((int)delayInMillis);
    }

    public String getText() {
        return this._textField.getText();
    }

    public String getInfoText() {
        return this._infoLabel.getText();
    }

    public void setInfoText(String text) {
        this._infoLabel.setText(text);
        this._infoLabel.setVisible(text != null);
    }

    public PromptedTextField getTextField() {
        return this._textField;
    }

    public void setText(String text) {
        this._textField.setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String newText, boolean isAdjusting) {
        if (this._textField.getText().equals(newText)) {
            return;
        }
        try {
            if (isAdjusting) {
                this._isAdjusting = true;
                this._searchTimer.stop();
            }
            this._textField.setText(newText);
            this.updateButtons();
        }
        finally {
            this._isAdjusting = false;
        }
    }

    public void doSearch(SearchCategory category, String searchText, SearchEvent.Direction direction) {
        this.doSearch(category, searchText, direction, true);
    }

    public void doSearch(SearchCategory category, String searchText, SearchEvent.Direction direction, boolean force) {
        if (force) {
            this._lastSearch = null;
        }
        this.setSelectedCategory(category);
        this.setText(searchText);
        this.fireSearchPerformed(direction, false);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (this._textField != null) {
            comp.setBackground(this._textField.getBackground());
        }
    }

    @Override
    public void requestFocus() {
        this._textField.requestFocus();
    }

    private void configureIconicButton(AbstractButton button, Icon icon, Icon disabledIcon, String tooltip) {
        if (button == null) {
            return;
        }
        button.setDisabledIcon(disabledIcon);
        this.configureIconicButton(button, icon, tooltip);
    }

    private void configureIconicButton(AbstractButton button, Icon icon, String tooltip) {
        if (button == null) {
            return;
        }
        Action action = button.getAction();
        if (action != null) {
            action.putValue("SmallIcon", icon);
            action.putValue("ShortDescription", tooltip);
        }
        this.configureIconicButton(button);
    }

    private void configureIconicButton(AbstractButton button) {
        IconicButtonUI.install(button);
        button.setOpaque(false);
        button.setFocusable(false);
        button.setContentAreaFilled(false);
        button.setBorder(null);
    }

    SearchProgress getSearchProgress() {
        return this._searchProgress;
    }

    JButton getSearchButton() {
        return this._searchButton;
    }

    public JButton getPreviousButton() {
        return this._previousButton;
    }

    public JButton getNextButton() {
        return this._nextButton;
    }

    float getIndeterminateValue() {
        return this._indeterminateProgress;
    }

    JPanel getSearchPanel() {
        return this._searchPanel;
    }

    private class CancelButton
    extends JButton {
        private boolean isHidden = false;

        CancelButton() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (CancelButton.this.isHidden) {
                        me.consume();
                        SearchField.this._textField.requestFocus();
                    }
                }
            });
        }

        public void setHidden(boolean hide) {
            this.isHidden = hide;
            this.repaint();
            if (this.isHidden && SearchField.this._cancelButton.hasFocus()) {
                SearchField.this._textField.requestFocus();
            }
            this.setFocusable(!this.isHidden);
            this.setFocusPainted(false);
        }

        @Override
        public void paintComponent(Graphics g) {
            if (!this.isHidden) {
                super.paintComponent(g);
            }
        }

        @Override
        public Cursor getCursor() {
            if (this.isHidden) {
                return SearchField.this._textField.getCursor();
            }
            return super.getCursor();
        }
    }

    private class SearchCategoryAction
    extends AbstractAction {
        private SearchCategory _searchCategory;

        SearchCategoryAction(SearchCategory sc) {
            super(sc.getLabel());
            this._searchCategory = sc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchField.this.setSelectedCategory(this._searchCategory);
        }
    }

    private class DropDownModel
    extends DefaultButtonModel {
        private DropDownModel() {
        }

        @Override
        public void setArmed(boolean b) {
            if (SearchField.this._popupAlreadyShown && b) {
                return;
            }
            super.setArmed(b);
        }
    }

    private class DropDownButton
    extends JButton {
        private DropDownButton() {
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            Toolkit.getDefaultToolkit().removeAWTEventListener(SearchField.this._awtListener);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            Toolkit.getDefaultToolkit().addAWTEventListener(SearchField.this._awtListener, 16L);
        }
    }

    public static enum Style {
        FILTER,
        SEARCH,
        FIND;

    }

    public static enum TypingDelay {
        FAST(200L),
        SLOW(850L);

        private final long _delayInMs;

        private TypingDelay(long delayInMs) {
            this._delayInMs = delayInMs;
        }

        void configureSearchField(SearchField sf) {
            sf.setTimerDelay(TimeUnit.MILLISECONDS, this._delayInMs);
        }
    }
}

