/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.segmented;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.ItemSelectable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.PanelUI;
import oracle.ide.hover.HoverFlavor;
import oracle.javatools.ui.infotip.InfoTipOrientation;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.ui.segmented.ActionSegment;
import oracle.javatools.ui.segmented.Segment;
import oracle.javatools.ui.segmented.SegmentButton;
import oracle.javatools.ui.segmented.SegmentedControlHoverable;
import oracle.javatools.ui.segmented.SegmentedControlUI;

public final class SegmentedControl<T>
extends JPanel
implements ItemSelectable {
    private static final String uiClassID = "SegmentedControlUI";
    private static final long serialVersionUID = 1L;
    private final ButtonListener buttonL = new ButtonListener();
    private final ButtonGroup group = new ButtonGroup();
    private final List<ItemListener> itemListeners = new CopyOnWriteArrayList<ItemListener>();
    private List<SegmentButton<T>> segmentButtons = new ArrayList<SegmentButton<T>>();
    private final SelectionType selectionType;

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean isMinimumSizeSet() {
        return true;
    }

    @Override
    public boolean isMaximumSizeSet() {
        return true;
    }

    public SegmentedControl() {
        this.setLayout(new FlowLayout(3, 1, 0));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.setFocusTraversalPolicy(new CustomFocusPolicy());
        this.setFocusTraversalPolicyProvider(true);
        this.selectionType = SelectionType.SINGLE;
    }

    public SegmentedControl(SelectionType selectionType) {
        this.setLayout(new FlowLayout(3, 1, 0));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.setFocusTraversalPolicy(new CustomFocusPolicy());
        this.setFocusTraversalPolicyProvider(true);
        this.selectionType = selectionType;
    }

    public SelectionType getSelectionType() {
        return this.selectionType;
    }

    public void addSegment(Segment<T> segment) {
        this.addSegment(segment, -1);
    }

    public void addSegment(Segment<T> segment, int index) {
        Action action;
        Object sel;
        SegmentButton<T> button = new SegmentButton<T>(segment, this);
        this.add((Component)button, index);
        if (index == -1) {
            this.segmentButtons.add(button);
        } else {
            this.segmentButtons.add(index, button);
        }
        if (this.selectionType == SelectionType.SINGLE) {
            this.group.add(button);
        }
        this.sizeButtonsIdentically();
        if (this.segmentButtons.size() == 1 && this.selectionType == SelectionType.SINGLE) {
            button.setSelected(true);
        }
        button.addItemListener(this.buttonL);
        button.addKeyListener(this.buttonL);
        button.addFocusListener(this.buttonL);
        button.addPropertyChangeListener(this.buttonL);
        button.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SegmentedControl.this.repaint();
            }
        });
        if (segment instanceof ActionSegment && Boolean.TRUE.equals(sel = (action = (Action)segment.getUserObject()).getValue("SwingSelectedKey"))) {
            button.setSelected(true);
        }
    }

    public void setSelected(Segment<T> segment) {
        for (SegmentButton<T> sb : this.getSegmentButtons()) {
            if (!sb.getSegment().equals(segment)) continue;
            sb.setSelected(true);
        }
    }

    public void setSelected(T userObject) {
        for (SegmentButton<T> sb : this.getSegmentButtons()) {
            if (!userObject.equals(sb.getSegment().getUserObject())) continue;
            sb.setSelected(true);
        }
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        if (!this.itemListeners.contains(itemListener)) {
            this.itemListeners.add(itemListener);
        }
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.itemListeners.remove(itemListener);
    }

    private void fireItemEvent(Segment segment, boolean selected) {
        ItemEvent event = new ItemEvent(this, 701, segment, selected ? 1 : 2);
        for (ItemListener l : this.itemListeners) {
            l.itemStateChanged(event);
        }
    }

    private void sizeButtonsIdentically() {
        Dimension largestD = new Dimension(0, 0);
        for (SegmentButton<T> b : this.getSegmentButtons()) {
            if (b.getSegment().getText() == null) continue;
            b.setPreferredSize(null);
            Dimension d = b.getPreferredSize();
            largestD.height = Math.max(largestD.height, d.height);
            largestD.width = Math.max(largestD.width, d.width);
        }
        for (SegmentButton<T> b : this.getSegmentButtons()) {
            if (b.getSegment().getText() == null) continue;
            b.setPreferredSize(largestD);
        }
    }

    @Override
    public void setUI(PanelUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((PanelUI)UIManager.getUI(this));
        } else {
            this.setUI(SegmentedControlUI.createUI(this));
        }
    }

    @Override
    public SegmentedControlUI getUI() {
        return (SegmentedControlUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public boolean hasFocus() {
        for (SegmentButton<T> b : this.getSegmentButtons()) {
            if (!b.hasFocus()) continue;
            return true;
        }
        return false;
    }

    public List<SegmentButton<T>> getSegmentButtons() {
        return Collections.unmodifiableList(this.segmentButtons);
    }

    private int indexOfSegment(Segment<T> segment) {
        int count = this.segmentButtons.size();
        for (int i = 0; i < count; ++i) {
            SegmentButton<T> b = this.segmentButtons.get(i);
            if (!b.getSegment().equals(segment)) continue;
            return i;
        }
        return -1;
    }

    public void removeSegment(Segment<T> segment) {
        int index = this.indexOfSegment(segment);
        if (index == -1) {
            return;
        }
        SegmentButton<T> bToBeRemoved = this.segmentButtons.get(index);
        if (this.selectionType == SelectionType.SINGLE && bToBeRemoved.isSelected() && this.segmentButtons.size() > 1) {
            int idxToSelect = index == 0 ? 1 : 0;
            Segment<T> segToSelect = this.segmentButtons.get(idxToSelect).getSegment();
            this.setSelected((T)segToSelect);
        }
        bToBeRemoved.removeItemListener(this.buttonL);
        bToBeRemoved.removeKeyListener(this.buttonL);
        bToBeRemoved.removeFocusListener(this.buttonL);
        bToBeRemoved.removePropertyChangeListener(this.buttonL);
        if (this.selectionType == SelectionType.SINGLE) {
            this.group.remove(bToBeRemoved);
        }
        this.remove(bToBeRemoved);
        this.segmentButtons.remove(bToBeRemoved);
    }

    public void removeAllSegments() {
        for (SegmentButton<T> b : this.segmentButtons) {
            b.removeItemListener(this.buttonL);
            b.removeKeyListener(this.buttonL);
            b.removeFocusListener(this.buttonL);
            if (this.selectionType != SelectionType.SINGLE) continue;
            this.group.remove(b);
        }
        this.removeAll();
        this.segmentButtons.clear();
    }

    public T getSelected() {
        for (SegmentButton<T> sb : this.getSegmentButtons()) {
            if (!sb.isSelected()) continue;
            return sb.getSegment().getUserObject();
        }
        return null;
    }

    public Segment[] getSelectedObjects() {
        ArrayList<Segment<T>> segments = new ArrayList<Segment<T>>();
        for (SegmentButton<T> sb : this.getSegmentButtons()) {
            if (!sb.isSelected()) continue;
            segments.add(sb.getSegment());
        }
        return segments.toArray(new Segment[segments.size()]);
    }

    private SegmentButton getSelectedButton() {
        for (SegmentButton<T> sb : this.getSegmentButtons()) {
            if (!sb.isSelected()) continue;
            return sb;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (SegmentButton<T> sb : this.getSegmentButtons()) {
            sb.setEnabled(enabled);
        }
        this.setFocusTraversalPolicyProvider(enabled);
    }

    public void setInfoTip(InfoTipTemplate<T> template, InfoTipStyles style, HoverFlavor flavor, InfoTipOrientation orientation) {
        if (template == null) {
            throw new IllegalArgumentException("Attempt to set an InfoTip with null template.");
        }
        SegmentedControlHoverable.install(template, style, this, flavor, orientation);
    }

    public static interface InfoTipTemplate<T>
    extends Template {
        @Override
        public JComponent getContent();

        public void setSegment(Segment<T> var1);
    }

    private class CustomFocusPolicy
    extends FocusTraversalPolicy {
        private CustomFocusPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            return null;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            return null;
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return SegmentedControl.this.getSelectedButton();
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return SegmentedControl.this.getSelectedButton();
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return SegmentedControl.this.getSelectedButton();
        }
    }

    private class ButtonListener
    extends KeyAdapter
    implements ItemListener,
    FocusListener,
    PropertyChangeListener {
        private ButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SegmentButton b = (SegmentButton)e.getSource();
            SegmentedControl.this.fireItemEvent(b.getSegment(), b.isSelected());
            if (b.getSegment() instanceof ActionSegment) {
                ((ActionSegment)b.getSegment()).getUserObject().putValue("SwingSelectedKey", b.isSelected());
            }
            SegmentedControl.this.repaint();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int index;
            if (e.getKeyCode() != 37 && e.getKeyCode() != 39) {
                return;
            }
            Object o = e.getSource();
            List buttons = SegmentedControl.this.getSegmentButtons();
            int count = buttons.size();
            for (index = 0; index < count && o != buttons.get(index); ++index) {
            }
            if (e.getKeyCode() == 37) {
                index = Math.max(0, index - 1);
            } else if (e.getKeyCode() == 39) {
                index = Math.min(count - 1, index + 1);
            }
            SegmentButton b = buttons.get(index);
            if (SegmentedControl.this.selectionType == SelectionType.SINGLE) {
                b.setSelected(true);
            }
            b.requestFocus();
        }

        @Override
        public void focusGained(FocusEvent e) {
            SegmentedControl.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            SegmentedControl.this.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("text") || evt.getPropertyName().equals("icon")) {
                SegmentedControl.this.sizeButtonsIdentically();
            }
        }
    }

    public static enum SelectionType {
        SINGLE,
        MULTIPLE;

    }
}

