/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import oracle.javatools.ui.table.CheckRowHeaderRenderer;
import oracle.javatools.ui.table.RowHeader;
import oracle.javatools.ui.table.RowHeaderSelectionModel;
import oracle.javatools.ui.table.SimpleTableModel;
import oracle.javatools.util.CollectionEvent;
import oracle.javatools.util.CollectionListener;
import oracle.javatools.util.ListenableCollection;

public class CheckRowHeader
extends RowHeader {
    protected ListenableCollection checkedItems;
    private CheckListener checkListener = new CheckListener();

    public CheckRowHeader(JTable table, ListenableCollection checkedItems) {
        super(table);
        this.checkedItems = checkedItems;
        this.setCellRenderer(new CheckRowHeaderRenderer(table, (Collection)checkedItems));
        this.addMouseListener(this.checkListener);
        table.addKeyListener(this.checkListener);
        this.addKeyListener(this.checkListener);
        checkedItems.addListener(new CollectionListener(){

            public void collectionChanged(CollectionEvent event) {
                SimpleTableModel model = CheckRowHeader.this.getTableModel();
                int index = model.indexOf(event.getItem());
                if (index < 0) {
                    return;
                }
                JTable table = CheckRowHeader.this.getTable();
                index = table.convertRowIndexToView(index);
                if (event.getType() == CollectionEvent.Type.ADDITION) {
                    if (!table.isRowSelected(index)) {
                        table.addRowSelectionInterval(index, index);
                        table.repaint();
                        CheckRowHeader.this.repaint();
                    }
                } else if (event.getType() == CollectionEvent.Type.REMOVAL && table.isRowSelected(index)) {
                    table.removeRowSelectionInterval(index, index);
                    table.repaint();
                    CheckRowHeader.this.repaint();
                }
            }
        });
    }

    @Override
    protected ListSelectionModel createSelectionModel() {
        ListSelectionModel selModel = super.createSelectionModel();
        if (selModel instanceof RowHeaderSelectionModel) {
            ((RowHeaderSelectionModel)selModel).setShrinkSelection(true);
        }
        return selModel;
    }

    protected SimpleTableModel getTableModel() {
        assert (this.getTable().getModel() instanceof SimpleTableModel) : "CheckRowHeader is currently only compatible with SimpleTableModels";
        return (SimpleTableModel)this.getTable().getModel();
    }

    private class CheckListener
    extends MouseAdapter
    implements KeyListener {
        private CheckListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int i = CheckRowHeader.this.locationToIndex(e.getPoint());
            Rectangle cellBounds = CheckRowHeader.this.getCellBounds(i, i);
            if (cellBounds.contains(e.getPoint())) {
                this.toggleSelection();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!(e.getKeyCode() != 32 || e.isControlDown() || e.isAltDown() || e.isShiftDown())) {
                this.toggleSelection();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        private void toggleSelection() {
            Object rowObject;
            int viewIndex;
            boolean check = true;
            for (int i : CheckRowHeader.this.getTable().getSelectedRows()) {
                viewIndex = CheckRowHeader.this.getTable().convertRowIndexToModel(i);
                rowObject = CheckRowHeader.this.getTableModel().getRow(viewIndex);
                if (!CheckRowHeader.this.checkedItems.contains(rowObject)) continue;
                check = false;
            }
            for (int i : CheckRowHeader.this.getTable().getSelectedRows()) {
                viewIndex = CheckRowHeader.this.getTable().convertRowIndexToModel(i);
                rowObject = CheckRowHeader.this.getTableModel().getRow(viewIndex);
                if (check) {
                    if (!CheckRowHeader.this.checkedItems.contains(rowObject)) {
                        CheckRowHeader.this.checkedItems.add(rowObject);
                    }
                } else {
                    CheckRowHeader.this.checkedItems.remove(rowObject);
                }
                CheckRowHeader.this.repaint(CheckRowHeader.this.getCellBounds(i, i));
            }
        }
    }
}

