/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.JTextComponent;
import oracle.javatools.ui.table.ColumnSelector;
import oracle.javatools.ui.table.DisplayableTable;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTableAutoSizeModel;
import oracle.javatools.ui.table.GenericTableHeaderRenderer;
import oracle.javatools.ui.table.GenericTablePersistentSettings;
import oracle.javatools.ui.table.LegacyTableModel;
import oracle.javatools.ui.table.RowHeader;
import oracle.javatools.ui.table.TableHelper;
import oracle.javatools.ui.table.TableUIManager;

public class GenericTable
extends JTable
implements DisplayableTable {
    private boolean _showToolTips = true;
    private boolean _selectAll;
    private KeyStroke _currKeyStroke;
    private Boolean _useTransferHandler = null;
    private Color _sortColumnBackgroundColor = TableUIManager.SORTED_COL_BACK;

    public GenericTable() {
        this._init();
    }

    public GenericTable(TableModel model) {
        super(model);
        this._init();
    }

    public GenericTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this._init();
    }

    public GenericTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this._init();
    }

    public int getSortColumn() {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter == null) {
            return -1;
        }
        List<RowSorter.SortKey> sortKeys = rowSorter.getSortKeys();
        return sortKeys.isEmpty() ? 0 : sortKeys.get(0).getColumn();
    }

    public boolean isSortAscending() {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter == null) {
            return true;
        }
        List<RowSorter.SortKey> sortKeys = rowSorter.getSortKeys();
        return sortKeys.isEmpty() ? true : sortKeys.get(0).getSortOrder() != SortOrder.DESCENDING;
    }

    public void setColumnSelectorAvailable(boolean isAvailable) {
        TableHelper.setColumnSelectorAvailable(this, isAvailable);
    }

    public boolean isColumnSelectorAvailable() {
        return TableHelper.isColumnSelectorAvailable(this);
    }

    public void setSelectColumnsAction(Action selectColumn) {
        TableHelper.setSelectColumnsAction(this, selectColumn);
    }

    public Action getSelectColumnsAction() {
        return TableHelper.getSelectColumnsAction(this);
    }

    public void setColumnSelectorActions(Action ... actions) {
        TableHelper.setColumnSelectorActions(this, actions);
    }

    public Action[] getColumnSelectorActions() {
        return TableHelper.getColumnSelectorActions(this);
    }

    public JPopupMenu createSelectorMenu() {
        ColumnSelector cs = TableHelper.getColumnSelector(this);
        return cs.getPopupMenu();
    }

    public void setHiddenColumns(int ... hiddenColumns) {
        ColumnSelector cs = TableHelper.getColumnSelector(this);
        cs.setHiddenColumns(hiddenColumns);
    }

    public int[] getHiddenColumns() {
        ColumnSelector cs = TableHelper.getColumnSelector(this);
        return cs.getHiddenColumns();
    }

    private final Map getHiddenColumnsMap() {
        ColumnSelector cs = TableHelper.getColumnSelector(this);
        return cs.getHiddenColumnsMap();
    }

    public void setHiddenColumnsVisible(int[] columns) {
        ColumnSelector cs = TableHelper.getColumnSelector(this);
        cs.setHiddenColumnsVisible(columns);
    }

    public void setColumnSelectorToolTipText(String text) {
        ColumnSelector cs = TableHelper.getColumnSelector(this);
        cs.setToolTipText(text);
    }

    public String getColumnSelectorToolTipText() {
        ColumnSelector cs = TableHelper.getColumnSelector(this);
        return cs.getToolTipText();
    }

    public void setNoEntryInstructionText(String text) {
        TableHelper.setNoEntryInstructionText(this, text);
    }

    public String getNoEntryInstructionText() {
        return TableHelper.getNoEntryInstructionText(this);
    }

    public void setShowToolTips(boolean showToolTips) {
        this._showToolTips = showToolTips;
    }

    public boolean isShowToolTips() {
        return this._showToolTips;
    }

    public void setResizeColumnOnDoubleClick(boolean isOn) {
        TableHelper.setResizeColumnOnDoubleClick(this, isOn);
    }

    public boolean isResizeColumnOnDoubleClick() {
        return TableHelper.isResizeColumnOnDoubleClick(this);
    }

    public void sizeTableToContents() {
        this.sizeTableToContents(null);
    }

    public void sizeTableToContents(Object[] prototypeValues) {
        TableHelper.sizeTableToContents(this, prototypeValues);
    }

    public final void autoSizeViewportToFit(Dimension min, Dimension max) {
        Dimension preferredSize = this.getPreferredSize();
        Dimension viewportSize = new Dimension();
        viewportSize.width = preferredSize.width;
        viewportSize.height = preferredSize.height;
        if (min != null) {
            viewportSize.width = Math.max(min.width, viewportSize.width);
            viewportSize.height = Math.max(min.height, viewportSize.height);
        }
        if (max != null) {
            viewportSize.width = Math.min(max.width, viewportSize.width);
            viewportSize.height = Math.min(max.height, viewportSize.height);
        }
        this.setPreferredScrollableViewportSize(viewportSize);
    }

    public void autoSizeColumnsToFit() {
        this.autoSizeColumnsToFit(null);
    }

    public void autoSizeColumnsToFit(Object[] prototypeValues) {
        for (int i = 0; i < this.getTableHeader().getColumnModel().getColumnCount(); ++i) {
            int maxWidth = TableHelper.sizeColumnToContents(this, i, this.getSortColumn() == i, -1, prototypeValues);
            TableColumn column = this.getTableHeader().getColumnModel().getColumn(i);
            if (this.getModel() instanceof GenericTableAutoSizeModel) {
                GenericTableAutoSizeModel model = (GenericTableAutoSizeModel)((Object)this.getModel());
                maxWidth = Math.min(maxWidth, model.getColumnAutoSizeMaximum(i));
            }
            column.setPreferredWidth(maxWidth);
        }
    }

    public void setVisibleRows(int rows) {
        JScrollPane pane = TableHelper.getTableScrollPane(this);
        if (pane != null) {
            TableHelper.setVisibleRows(this, pane, rows);
        }
    }

    public void setPreferredVisibleRowCount(int visibleRowCount) {
        TableHelper.setPreferredVisibleRowCount(this, visibleRowCount);
    }

    public int getPreferredVisibleRowCount() {
        return TableHelper.getPreferredVisibleRowCount(this);
    }

    public void setRowHeader(RowHeader rowHeader) {
        this.putClientProperty("tableRowHeader", rowHeader);
    }

    public RowHeader getRowHeader() {
        return (RowHeader)this.getClientProperty("tableRowHeader");
    }

    public RowHeader createDefaultRowHeader() {
        return new RowHeader(this);
    }

    public void setColumnHeaderSelectionEnabled(boolean select) {
        TableHelper.setColumnHeaderSelectionEnabled(this, select);
    }

    public boolean isColumnHeaderSelectionEnabled() {
        return TableHelper.isColumnHeaderSelectionEnabled(this);
    }

    public void setSelectAllEnabled(boolean enable) {
        if (enable != this.isSelectAllEnabled()) {
            this._selectAll = enable;
            JScrollPane pane = TableHelper.getTableScrollPane(this);
            if (pane != null) {
                TableHelper.setSelectAllEnabled(this, pane, enable);
            }
        }
    }

    public boolean isSelectAllEnabled() {
        return this._selectAll;
    }

    public void setRolloverHighlightingEnabled(boolean highlight) {
        TableHelper.setRolloverHighlightingEnabled(this, highlight);
    }

    public boolean isRolloverHighlightingEnabled() {
        return TableHelper.isRolloverHighlightingEnabled(this);
    }

    @Override
    public void setDefaultRenderer(Class<?> columnClass, TableCellRenderer renderer) {
        super.setDefaultRenderer(columnClass, renderer);
    }

    public void setUseTransferHandler(boolean useTransferHandler) {
        this._useTransferHandler = useTransferHandler;
        this._updateTransferHandler();
    }

    public boolean getUseTransferHandler() {
        return this._useTransferHandler == null || this._useTransferHandler != false;
    }

    public void setSortColumnBackgroundColor(Color c) {
        if (c != this._sortColumnBackgroundColor) {
            this._sortColumnBackgroundColor = c;
            this.repaint();
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.setSortColumnBackgroundColor(null);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setSortColumnBackgroundColor(null);
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        final Component comp = super.prepareEditor(editor, row, column);
        final KeyStroke ks = this._currKeyStroke;
        if (ks != null) {
            if (comp instanceof JTextComponent && ks.getKeyCode() != 113) {
                ((JTextComponent)comp).setText("");
            } else if (comp instanceof JComboBox) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int keyCode;
                        if (comp.isShowing() && comp.requestFocusInWindow() && Character.isLetter(keyCode = ks.getKeyCode()) && ks.getModifiers() == 0) {
                            ((JComboBox)comp).selectWithKeyChar((char)keyCode);
                        }
                    }
                });
            }
        }
        return comp;
    }

    public Color getSortColumnBackgroundColor() {
        return this._sortColumnBackgroundColor;
    }

    @Override
    public String convertValueToText(Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return null;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        JScrollPane scrollPane = TableHelper.getTableScrollPane(this);
        if (scrollPane != null) {
            JViewport viewport = scrollPane.getViewport();
            if (this.isSelectAllEnabled()) {
                TableHelper.setSelectAllEnabled(this, scrollPane, this.isSelectAllEnabled());
            }
            scrollPane.setOpaque(true);
            viewport.setOpaque(true);
            scrollPane.setBackground(this.getBackground());
            viewport.setBackground(this.getBackground());
            Border border = scrollPane.getBorder();
            if (border == null || border instanceof UIResource) {
                scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
            scrollPane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
            RowHeader rowHeader = this.getRowHeader();
            if (rowHeader != null) {
                scrollPane.setRowHeaderView(rowHeader);
            }
        }
    }

    @Override
    protected void unconfigureEnclosingScrollPane() {
        super.unconfigureEnclosingScrollPane();
        JScrollPane scrollPane = TableHelper.getTableScrollPane(this);
        if (scrollPane != null) {
            RowHeader rowHeader;
            if (this.isSelectAllEnabled()) {
                TableHelper.setSelectAllEnabled(this, scrollPane, false);
            }
            if ((rowHeader = this.getRowHeader()) != null) {
                scrollPane.setRowHeaderView(null);
            }
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String tip;
        if (!this._showToolTips) {
            return super.getToolTipText(event);
        }
        Point mousePos = event.getPoint();
        int column = this.columnAtPoint(mousePos);
        int row = this.rowAtPoint(mousePos);
        if (column != -1 && row != -1 && (tip = TableHelper.getTruncatedCellValue(this, row, column)) != null) {
            return tip;
        }
        return super.getToolTipText(event);
    }

    protected String getJTableToolTipText(MouseEvent e) {
        return super.getToolTipText(e);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (!this.isPreferredSizeSet() && this.getRowCount() == 0) {
            size.height = TableHelper.getNoEntryDefaultHeight(this);
        }
        return size;
    }

    @Override
    protected void paintComponent(Graphics g) {
        List<RowSorter.SortKey> sortKeys;
        super.paintComponent(g);
        RowSorter<? extends TableModel> sorter = this.getRowSorter();
        if (sorter != null && (sortKeys = sorter.getSortKeys()).size() > 0) {
            int column = this.convertColumnIndexToView(sortKeys.get(0).getColumn());
            switch (sortKeys.get(0).getSortOrder()) {
                case ASCENDING: 
                case DESCENDING: {
                    Rectangle rect = this.getCellRect(this.getRowCount() - 1, column, true);
                    Color c = this.getSortColumnBackgroundColor();
                    if (c == null) {
                        c = TableUIManager.SORTED_COL_BACK;
                    }
                    g.setColor(c);
                    g.fillRect(rect.x, rect.y + rect.height, rect.width, this.getHeight());
                }
            }
        }
    }

    @Override
    public void setUI(TableUI ui) {
        super.setUI(ui);
        if (this._useTransferHandler == null) {
            this._useTransferHandler = Boolean.TRUE;
        }
        this._updateTransferHandler();
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        if (columnClass == null) {
            return super.getDefaultRenderer(Object.class);
        }
        return super.getDefaultRenderer(columnClass);
    }

    @Override
    public void selectAll() {
        TableHelper.stopCellEditing(this);
        super.selectAll();
    }

    protected void setColumnVisible(TableColumn column, int modelColumn, boolean isVisible) {
        ColumnSelector cs = TableHelper.getColumnSelector(this);
        cs.setColumnVisible(column, modelColumn, isVisible);
    }

    @Override
    protected void createDefaultRenderers() {
        super.createDefaultRenderers();
        this.installGenericTableRenderer();
    }

    protected void installGenericTableRenderer() {
        TableHelper.installGenericTableRenderer(this);
    }

    private void _init() {
        this.setAutoResizeMode(1);
        JTableHeader header = this.getTableHeader();
        if (header != null) {
            header.setDefaultRenderer(new GenericTableHeaderRenderer());
            header.setFocusable(true);
        }
        this.setFillsViewportHeight(true);
        this.setRolloverHighlightingEnabled(true);
        this.setColumnHeaderSelectionEnabled(true);
        this.setGridColor(TableUIManager.TABLE_GRID_COLOR);
        this.setResizeColumnOnDoubleClick(true);
        this.setRowHeight(TableHelper.getDefaultRowHeight());
        this.setColumnSelectorAvailable(true);
    }

    private void _updateTransferHandler() {
        if (this._useTransferHandler.booleanValue()) {
            TableHelper.installTableTransferHandler(this, false);
        } else {
            this.setTransferHandler(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (pressed && condition == 1 && (ks.getKeyCode() == 27 || ks.getKeyCode() == 10) && !this.isEditing()) {
            return false;
        }
        this._currKeyStroke = ks;
        try {
            boolean retValue;
            boolean bl = retValue = super.processKeyBinding(ks, e, condition, pressed);
            return bl;
        }
        finally {
            this._currKeyStroke = null;
        }
    }

    public void scrollToSelection() {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.getParent();
        Rectangle rect = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn(), true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    public GenericTablePersistentSettings getPersistentSettings() {
        int i;
        GenericTablePersistentSettings settings = new GenericTablePersistentSettings();
        settings.setHiddenColumns(this.getHiddenColumns());
        int[] widths = new int[this.getModel().getColumnCount()];
        ArrayList<Object> order = new ArrayList<Object>();
        for (i = 0; i < this.getModel().getColumnCount(); ++i) {
            int viewColumn = this.convertColumnIndexToView(i);
            TableColumn tc = viewColumn != -1 ? this.getTableHeader().getColumnModel().getColumn(viewColumn) : (TableColumn)this.getHiddenColumnsMap().get(new Integer(i));
            widths[i] = tc.getWidth();
        }
        for (i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableColumn col = this.getColumnModel().getColumn(i);
            Object id = col.getIdentifier();
            order.add(id);
        }
        settings.setColumnWidths(widths);
        settings.setColumnPositions(order);
        settings.setSorted(this.isSorted());
        settings.setSortColumn(this.getSortColumn());
        settings.setSortAscending(this.isSortAscending());
        return settings;
    }

    public void setPersistentSettings(GenericTablePersistentSettings settings) {
        this.setHiddenColumns(settings.getHiddenColumns());
        for (int i = 0; i < settings.getColumnWidths().length; ++i) {
            int viewColumn = this.convertColumnIndexToView(i);
            TableColumn tc = viewColumn != -1 ? this.getTableHeader().getColumnModel().getColumn(viewColumn) : (TableColumn)this.getHiddenColumnsMap().get(new Integer(i));
            if (tc == null) continue;
            tc.setPreferredWidth(settings.getColumnWidths()[i]);
        }
        List positions = settings.getColumnPositions();
        if (positions != null) {
            try {
                for (int pos = 0; pos < positions.size(); ++pos) {
                    int oldPos = this.getColumnModel().getColumnIndex(positions.get(pos));
                    if (oldPos == pos) continue;
                    this.getColumnModel().moveColumn(oldPos, pos);
                }
            }
            catch (IllegalArgumentException iae) {
                return;
            }
        }
    }

    public void setSorted(boolean isSorted) {
        if (this.isSorted() != isSorted) {
            this.setRowSorter(isSorted ? new RowSorterImpl(this.getModel()) : null);
        }
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        if (this.dataModel != dataModel && !this.getAutoCreateRowSorter() && this.isSorted()) {
            this.setRowSorter(new RowSorterImpl(dataModel));
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.isEditing() && (e.getType() == 1 || e.getType() == -1)) {
            this.getCellEditor().cancelCellEditing();
        }
        super.tableChanged(e);
    }

    public boolean isSorted() {
        return this.getRowSorter() != null && !this.getRowSorter().getSortKeys().isEmpty();
    }

    public int getSelectedRowInModel() {
        int i = super.getSelectedRow();
        return i >= 0 ? this.convertRowIndexToModel(i) : i;
    }

    public int[] getSelectedRowsInModel() {
        int[] selection = super.getSelectedRows();
        for (int i = 0; i < selection.length; ++i) {
            selection[i] = this.convertRowIndexToModel(selection[i]);
        }
        return selection;
    }

    public void setSelectedRowInModel(int selectedRowInModel) {
        this.setSelectedRowsInModel(new int[]{selectedRowInModel});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedRowsInModel(int[] selectedRowsInModel) {
        try {
            this.getSelectionModel().setValueIsAdjusting(true);
            this.getSelectionModel().clearSelection();
            for (int i = 0; i < selectedRowsInModel.length; ++i) {
                int index = this.isSorted() ? this.convertRowIndexToView(selectedRowsInModel[i]) : selectedRowsInModel[i];
                this.getSelectionModel().addSelectionInterval(index, index);
            }
        }
        finally {
            this.getSelectionModel().setValueIsAdjusting(false);
        }
    }

    public void setSortColumn(int modelColumn, boolean isSortAscending) {
        if (!this.isSorted()) {
            this.setSorted(true);
        }
        if (modelColumn >= 0 && modelColumn < this.getColumnCount()) {
            this.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(modelColumn, isSortAscending ? SortOrder.ASCENDING : SortOrder.DESCENDING)));
            this.scrollToSelection();
        }
    }

    public void reSort() {
        if (this.isSorted()) {
            this.setSortColumn(this.getSortColumn(), this.isSortAscending());
        }
    }

    protected static Color getDarker(Color c) {
        return new Color(Math.max(0, c.getRed() - 8), Math.max(0, c.getGreen() - 8), Math.max(0, c.getBlue() - 8));
    }

    private class RowSorterImpl
    extends TableRowSorter {
        private final TableModel _model;

        RowSorterImpl(TableModel model) {
            super(model);
            this._model = model;
        }

        @Override
        public Comparator getComparator(int column) {
            Comparator<?> comparator = this._getComparator(column);
            return comparator != null ? comparator : super.getComparator(column);
        }

        private final Comparator _getComparator(int column) {
            Comparator comparator;
            if (this._model instanceof GenericBaseTableModel && (comparator = ((GenericBaseTableModel)this._model).getColumnSortComparator(column)) != null) {
                return comparator;
            }
            if (this._model instanceof LegacyTableModel && (comparator = ((LegacyTableModel)((Object)this._model)).getColumnSortComparator(column)) != null) {
                return comparator;
            }
            return null;
        }

        @Override
        protected boolean useToString(int column) {
            Comparator comparator = this._getComparator(column);
            return comparator == null && super.useToString(column);
        }
    }
}

