/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.htmlBrowser;

import ice.pilots.html4.ThePilot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.bali.ewt.plaf.UIUtils;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;
import oracle.help.htmlBrowser.ICEBrowser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MouseEvent;

public class ICEToolTipManager
implements EventListener,
AncestorListener {
    private String _currentAltText = null;
    private Point _lastPoint = new Point();
    private ToolTipTask _currentTask = null;
    private BrowserToolTip _theTip = new BrowserToolTip();
    private ICEBrowser _browser;
    private JLayeredPane _currentOwner;
    private static final int TOOLTIP_DELAY = 500;
    private static final int CURSOR_SIZE = 18;
    private static final String EVENT_MOUSE_OVER = "mouseover";
    private static final String EVENT_MOUSE_OUT = "mouseout";
    private static final String EVENT_MOUSE_MOVE = "mousemove";
    private static final String ATTR_ALT = "alt";
    private static final String ATTR_TITLE = "title";

    public ICEToolTipManager(ICEBrowser iCEBrowser) {
        this._browser = iCEBrowser;
        this._browser.addAncestorListener(this);
    }

    public void registerToolTipListeners(ThePilot thePilot) {
        if (thePilot != null) {
            thePilot.addPersistentDOMEventListener(EVENT_MOUSE_OVER, (EventListener)this, true);
            thePilot.addPersistentDOMEventListener(EVENT_MOUSE_OUT, (EventListener)this, true);
            thePilot.addPersistentDOMEventListener(EVENT_MOUSE_MOVE, (EventListener)this, true);
        }
    }

    public void handleEvent(Event event) {
        String string = event.getType();
        if (string != null) {
            if (EVENT_MOUSE_OVER.equals(string)) {
                Node node;
                if (this._currentOwner != null) {
                    this._hideToolTip();
                }
                String string2 = null;
                for (Node node2 = node = (Node)((Object)event.getTarget()); node2 != null && string2 == null; node2 = node2.getParentNode()) {
                    if (!(node2 instanceof Element)) continue;
                    Element element = (Element)node2;
                    string2 = element.getAttribute(ATTR_ALT);
                    if (string2 == null) {
                        string2 = element.getAttribute(ATTR_TITLE);
                    }
                    if (string2 == null || (string2 = string2.trim()).length() != 0) continue;
                    string2 = null;
                }
                if (string2 != null) {
                    this._currentAltText = string2;
                    this._currentTask = new ToolTipTask(node);
                    TaskScheduler.getDefaultTaskScheduler().schedule((Task)this._currentTask, 500);
                }
            } else if (EVENT_MOUSE_OUT.equals(string)) {
                if (this._currentTask != null && this._currentTask.getToolTipNode() == event.getTarget()) {
                    this._hideToolTip();
                }
            } else if (EVENT_MOUSE_MOVE.equals(string)) {
                MouseEvent mouseEvent = (MouseEvent)event;
                this._lastPoint.x = mouseEvent.getClientX();
                this._lastPoint.y = mouseEvent.getClientY();
                if (this._currentOwner == null && this._currentTask != null) {
                    this._currentTask = new ToolTipTask(this._currentTask.getToolTipNode());
                    TaskScheduler.getDefaultTaskScheduler().schedule((Task)this._currentTask, 500);
                }
            }
        }
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this._hideToolTip();
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    private void _showToolTip(Task task) {
        if (task != this._currentTask) {
            return;
        }
        if (this._currentAltText != null) {
            this._theTip.setTipText(this._currentAltText);
            JRootPane jRootPane = this._browser.getRootPane();
            this._currentOwner = jRootPane.getLayeredPane();
            this._currentOwner.add((Component)this._theTip, JLayeredPane.POPUP_LAYER);
            Point point = this._translatePoint(this._browser, jRootPane, this._lastPoint.x, this._lastPoint.y);
            this._theTip.setLocation(point.x, point.y + 18);
            this._theTip.setVisible(true);
        }
    }

    private void _hideToolTip() {
        if (this._currentTask != null) {
            TaskScheduler.getDefaultTaskScheduler().cancel((Task)this._currentTask);
            this._currentTask = null;
        }
        if (this._currentOwner != null) {
            this._theTip.setVisible(false);
            this._currentOwner.remove(this._theTip);
            this._currentOwner = null;
        }
    }

    private Point _translatePoint(Component component, Component component2, int n, int n2) {
        while (component != component2) {
            Point point = component.getLocation();
            n += point.x;
            n2 += point.y;
            component = component.getParent();
        }
        return new Point(n, n2);
    }

    private class BrowserToolTip
    extends JComponent {
        private JLabel _tipLabel = new JLabel("");

        public BrowserToolTip() {
            this.setLayout(new BorderLayout());
            this.add((Component)this._tipLabel, "Center");
            this.setBackground(UIManager.getColor("ToolTip.background"));
            this.setForeground(UIManager.getColor("ToolTip.foreground"));
            this.setBorder(UIManager.getBorder("ToolTip.border"));
        }

        public void setTipText(String string) {
            this._tipLabel.setText(" " + string + " ");
            Dimension dimension = this._tipLabel.getPreferredSize();
            this.setSize(dimension.width + 8, dimension.height + 8);
        }

        protected void paintComponent(Graphics graphics) {
            UIUtils.fillBackground((Graphics)graphics, (JComponent)this);
        }
    }

    private class ToolTipTask
    implements Task {
        private Node _node;

        public ToolTipTask(Node node) {
            this._node = node;
        }

        public void runTask(TaskEvent taskEvent) {
            ICEToolTipManager.this._showToolTip(this);
        }

        public Node getToolTipNode() {
            return this._node;
        }
    }
}

