/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.gallery.GalleryProvider;
import oracle.ide.gallery.GalleryProviderAdapter;
import oracle.ide.gallery.GalleryProviderInfo;
import oracle.ide.gallery.ObjectGalleryAddin;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;

final class GalleryProviderHandler {
    private static final String PROCESS_ALL_LAZY_PROVIDERS = "call-all-lazy-gallery-providers";
    private List<GalleryProviderInfo> _galleryProviders;

    GalleryProviderHandler() {
    }

    void registerItems(boolean forceLazyItemsToLoad) {
        List<GalleryProviderInfo> providerInfos = this.getGalleryProviders();
        GalleryManager galleryManager = GalleryManager.getGalleryManager();
        for (GalleryProviderInfo info : providerInfos) {
            if (!forceLazyItemsToLoad && !info.getFolders().isEmpty()) continue;
            try {
                GalleryProvider galleryProvider = info.getGalleryProvider();
                galleryProvider.registerElementInfos(galleryManager);
            }
            catch (Exception e) {
                Logger.getLogger(GalleryProviderHandler.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    boolean registerAllDeferredItems() {
        return this.registerDeferredItemsForFolder(PROCESS_ALL_LAZY_PROVIDERS);
    }

    boolean registerDeferredItemsForFolder(String folderName) {
        GalleryManager galleryManager = GalleryManager.getGalleryManager();
        for (GalleryProviderInfo info : this.getGalleryProviders()) {
            if (info.getFolders().isEmpty() || !info.getFolders().contains(folderName) && !PROCESS_ALL_LAZY_PROVIDERS.equals(folderName)) continue;
            try {
                GalleryProvider provider = info.getGalleryProvider();
                provider.registerElementInfos(galleryManager);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        if (galleryManager instanceof ObjectGalleryAddin) {
            return ((ObjectGalleryAddin)galleryManager).addPendingGalleryItems();
        }
        return false;
    }

    private List<GalleryProviderInfo> getGalleryProviders() {
        if (this._galleryProviders == null) {
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            HashStructureHook galleryProviderHook = (HashStructureHook)er.getHook(GalleryProviderAdapter.NAME);
            HashStructure hashStructure = galleryProviderHook.getHashStructure();
            GalleryProviderAdapter providerAdapter = GalleryProviderAdapter.getInstance(hashStructure);
            this._galleryProviders = providerAdapter.getGalleryProviderInfos().getProviderInfos();
        }
        return this._galleryProviders;
    }

    boolean isPopulatedByGalleryProvider(String folderName) {
        Iterator<GalleryProviderInfo> i$ = this.getGalleryProviders().iterator();
        if (i$.hasNext()) {
            GalleryProviderInfo info = i$.next();
            return !info.getFolders().isEmpty() && info.getFolders().contains(folderName);
        }
        return false;
    }
}

