/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ide.extension.Extension;
import javax.ide.wizard.spi.WizardHook;
import javax.ide.wizard.spi.WizardInfo;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.FolderInfo;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GalleryHandler;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.gallery.GalleryProviderHandler;
import oracle.ide.gallery.GalleryXMLDataNode;
import oracle.ide.gallery.JavaxIdeElementInfo;
import oracle.ide.gallery.ObjectGalleryAddin;
import oracle.ide.gallery.ObjectGalleryPanel;
import oracle.ide.gallery.RootGalleryFolder;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.XMLDataNode;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.resource.GalleryArb;
import oracle.ide.usages.UsageData;
import oracle.ide.usages.UsagesTracker;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.wizard.Invokable;
import oracle.ide.wizard.TriggerInvokable;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.ideimpl.gallery.MruItems;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public final class ObjectGallery {
    private static final String XML_FILENAME = "gallery.xml";
    private static final String HELP_TOPIC_ID = "f1_idenewobjectgallery_html";
    private final DialogRunnerCallback _dialogCallback = new SizeKeeperCallback("new.gallery", TDialogLauncher.getPreferredDefaultInitialSize());
    private XMLDataNode _model;
    private Context _context;
    private JEWTFinishDialog _dlg;
    private GalleryElement _selItem;
    private ObjectGalleryPanel _panel;
    private boolean _loadedHook = false;
    private GalleryProviderHandler _galleryProviderHandler;

    public ObjectGallery() {
        File xmlFile = new File(Ide.getLibDirectory(), XML_FILENAME);
        URL url = URLFactory.newFileURL((File)xmlFile);
        this._model = new GalleryXMLDataNode(url);
    }

    public GalleryFolder getModel() {
        return (GalleryFolder)this._model.getData();
    }

    public void runDialog(Context context) {
        this.runDialog(context, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDialog(Context context, String initialFolder, String initialSelection) {
        if (this._context != null) {
            return;
        }
        try {
            this._context = context;
            this.loadGalleryData();
            this._dlg = new JEWTFinishDialog((Frame)Ide.getMainWindow(), GalleryArb.getString((int)6), 7);
            RootGalleryFolder rootFolder = (RootGalleryFolder)this._model.getData();
            rootFolder.setDeferredProviderHandler(this.getGalleryProviderHandler());
            this._panel = new ObjectGalleryPanel(rootFolder, context);
            HelpSystem.getHelpSystem().registerTopic((JComponent)this._panel, HELP_TOPIC_ID);
            EventAdapter eventAdapter = new EventAdapter();
            this._panel.itemsList.addListSelectionListener(eventAdapter);
            this._panel.addActionListener(eventAdapter);
            this._dlg.setOKButtonEnabled(false);
            this._dlg.setContent(this._panel);
            this._dlg.setResizable(true);
            this._panel.setInitialSelection(initialFolder, initialSelection);
            this.setCanAdvance();
            this._dialogCallback.dialogAboutToRun((JDialog)((Object)this._dlg));
            boolean finished = WizardLauncher.runDialog((JDialog)((Object)this._dlg));
            rootFolder.setMainDividerLocation(this._panel.getMainDividerLocation());
            if (finished) {
                this.invokeWizard(this._selItem, this._context);
            }
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
        }
        finally {
            this._context = null;
            this._dlg = null;
            this._selItem = null;
            this._panel = null;
        }
    }

    public void loadGalleryData() {
        this.loadGalleryData(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGalleryData(boolean forceLazyItemsToLoad) {
        GalleryManager mgr = GalleryManager.getGalleryManager();
        if (!this._loadedHook) {
            try {
                this.loadFromGalleryHook(mgr);
                this.loadFromWizardHook(mgr);
            }
            finally {
                this._loadedHook = true;
            }
        }
        this.getGalleryProviderHandler().registerItems(forceLazyItemsToLoad);
        try {
            this._model.open();
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
            return;
        }
        PrintStream ps = this.getDebugOutputStream();
        try {
            this.flushPendingGalleryItems(ps);
        }
        finally {
            IdeUtil.close((Closeable)ps);
        }
    }

    private void loadFromWizardHook(GalleryManager mgr) {
        WizardHook wizHook = (WizardHook)ExtensionRegistry.getExtensionRegistry().getHook(WizardHook.ELEMENT);
        Collection classes = wizHook.getAllWizardClasses();
        Iterator classIterator = classes.iterator();
        while (classIterator.hasNext()) {
            try {
                WizardInfo wi = wizHook.getWizardInfo((String)classIterator.next());
                mgr.registerGalleryElement(new JavaxIdeElementInfo(wi));
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromGalleryHook(GalleryManager mgr) {
        GalleryHandler galleryHandler = GalleryHandler.get();
        Set<FolderInfo> folders = galleryHandler.getFolders();
        ((ObjectGalleryAddin)mgr).registerFolders(folders);
        Set<ElementInfo> items = galleryHandler.getItems();
        PrintStream debugLog = this.getDebugOutputStream();
        try {
            if (debugLog != null) {
                debugLog.println("Found " + items.size() + " Hook items");
                debugLog.println();
            }
            for (ElementInfo item : items) {
                try {
                    String nameInfo;
                    mgr.registerGalleryElement(item);
                    if (debugLog == null || item.getPath().length != 2) continue;
                    String[] pathInfo = item.getPath();
                    String string = nameInfo = item.getName() == null ? item.getInvokableClassName() : item.getName();
                    if (nameInfo == null) {
                        nameInfo = "";
                    }
                    debugLog.println("Registering: " + pathInfo[0] + ": " + pathInfo[1] + ": " + nameInfo);
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
        }
        finally {
            IdeUtil.close((Closeable)debugLog);
        }
    }

    void invokeWizard(GalleryElement element, Context context) {
        if (element != null) {
            boolean initialized = ObjectGallery.owningExtensionInitialized(element);
            Context ctx = new Context(context);
            Invokable invokable = element.getInvokable();
            if (invokable != null) {
                if (!initialized && invokable instanceof TriggerInvokable) {
                    Wizard.setWizardId((Context)ctx, (String)element.getId());
                    TriggerInvokable ti = (TriggerInvokable)invokable;
                    if (!ti.canInvoke(ctx)) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)ti.getInvalidStateMessage(ctx), (String)GalleryArb.format((int)332, (Object)element.getName()), null);
                        return;
                    }
                }
                ObjectGallery.reportCreateDocument(element, invokable);
                ObjectGallery.maybeUpdateProjectMru(ctx, element);
                String[] wizParams = element.getWizardParameters();
                String[] techKeys = element.getTechnologyKeys();
                String id = element.getId();
                TechnologyScope techScope = new TechnologyScope();
                techScope.setTechnologyKeys(techKeys);
                TechnologyRegistry.getInstance().initializeOwningExtensions(techScope);
                WizardManager.getInstance().invokeSecondaryWizard(invokable, ctx, id, wizParams, techKeys);
            }
        }
    }

    private static boolean owningExtensionInitialized(GalleryElement element) {
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        Extension x = extReg.findExtensionByClassLoader(element.getInvokableClassLoader());
        return extReg.isFullyLoaded(x);
    }

    private static void reportCreateDocument(GalleryElement galleryElement, Invokable wizard) {
        String wizardClassName = galleryElement.getInvokableClass() != null ? galleryElement.getInvokableClass() : wizard.getClass().getName();
        UsagesTracker tracker = UsagesTracker.getUsagesTracker();
        UsageData data = tracker.createUsageData();
        data.setEventId("CREATE_DOCUMENT");
        data.setEventSource(wizardClassName);
        data.setProperty("wizard-label", galleryElement.getShortLabel());
        tracker.report(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setCanAdvance() {
        if (this._dlg != null) {
            try {
                GalleryElement sel;
                this._selItem = sel = this._panel.getSelectedItem();
                this._dlg.setOKButtonEnabled(this._selItem != null ? this._selItem.isAvailable(this._context) : false);
            }
            catch (Exception ex) {
                try {
                    this._selItem = null;
                    this._dlg.setOKButtonEnabled(this._selItem != null ? this._selItem.isAvailable(this._context) : false);
                }
                catch (Throwable throwable) {
                    this._dlg.setOKButtonEnabled(this._selItem != null ? this._selItem.isAvailable(this._context) : false);
                    throw throwable;
                }
            }
        }
    }

    private void flushPendingGalleryItems(PrintStream log) {
        GalleryManager galleryManager = GalleryManager.getGalleryManager();
        Assert.check((boolean)(galleryManager instanceof ObjectGalleryAddin));
        if (galleryManager instanceof ObjectGalleryAddin) {
            ObjectGalleryAddin galleryAddin = (ObjectGalleryAddin)galleryManager;
            galleryAddin.removePendingGalleryItems(log);
            galleryAddin.addPendingGalleryItems(log);
        }
        this.printDebugInfo(log);
    }

    private void printDebugInfo(PrintStream log) {
        GalleryFolder f;
        if (log != null && (f = this.getModel()) != null) {
            TreeMap techMap = new TreeMap();
            Context context = this._context;
            if (context != null) {
                log.println();
                log.println("Context Info");
                log.println("--------------------");
                log.println("Project: " + (context.getProject() != null ? context.getProject().getShortLabel() : "<null>"));
                log.println("Element: " + (context.getElement() != null ? context.getElement().toString() : "<null>"));
                log.println("View: " + (context.getView() != null ? context.getView().getId() : "<null>"));
                log.println("Node: " + (context.getNode() != null ? context.getNode().getShortLabel() : "<null>"));
                log.println("Workspace: " + (context.getWorkspace() != null ? context.getWorkspace().getLongLabel() : "<null>"));
            }
            log.println();
            log.println("Technologies By Item");
            log.println("--------------------");
            f.debugLogTechnologies(log, null, techMap);
            log.println();
            log.println("Items By Technology");
            log.println("-------------------");
            for (Map.Entry entry : techMap.entrySet()) {
                String tech = (String)entry.getKey();
                log.println();
                log.println(tech + ":");
                List l = (List)entry.getValue();
                Iterator it2 = l.iterator();
                while (it2.hasNext()) {
                    log.println("  " + (String)it2.next());
                }
            }
        }
    }

    private PrintStream getDebugOutputStream() {
        String property;
        PrintStream log = null;
        Object value = System.getProperties().get("jdev.debug.technology.log");
        if (value instanceof OutputStream) {
            log = new PrintStream((OutputStream)value);
        } else if (value instanceof String && ModelUtil.hasLength((String)(property = value.toString()))) {
            System.out.println();
            System.out.println("GALLERY DEBUGGING ENABLED (System property jdev.debug.technology.log=" + property + ")");
            if (Boolean.parseBoolean(property)) {
                log = System.out;
            } else if (property.equals("System.out")) {
                log = System.out;
            } else if (property.equals("System.err")) {
                log = System.err;
            } else {
                try {
                    log = new PrintStream(new FileOutputStream(property));
                }
                catch (FileNotFoundException ex) {
                    System.err.println("ERROR opening technology log: " + property + ". Logging to System.err instead.");
                    log = System.err;
                }
            }
        }
        return log;
    }

    private GalleryProviderHandler getGalleryProviderHandler() {
        if (this._galleryProviderHandler == null) {
            this._galleryProviderHandler = new GalleryProviderHandler();
        }
        return this._galleryProviderHandler;
    }

    private static void maybeUpdateProjectMru(Context context, GalleryElement element) {
        if (context.getProject() != null && element.isAddToNewMenu()) {
            if (element.getInvokableClass() != null) {
                MruItems.getInstance(context.getProject()).recentlyCreated(element.getInvokableClass(), element.getId());
            } else {
                Assert.println((String)("GalleryElement.getInvokableClass() == null for " + element.getName() + "; cannot add to New submenu."));
            }
        }
    }

    private static final class JEWTFinishDialog
    extends JEWTDialog {
        private static final String DFT_SYMBOL = "new-gallery";

        public JEWTFinishDialog(Frame f, String s, int i) {
            super(f, s, i);
            this.setName(DFT_SYMBOL);
            this.setSize(600, 400);
        }

        public void finish() {
            this.dismissDialog(false);
        }
    }

    private final class EventAdapter
    implements ActionListener,
    ListSelectionListener {
        private EventAdapter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ObjectGallery.this._selItem != null && ObjectGallery.this._selItem.isAvailable(ObjectGallery.this._context)) {
                ObjectGallery.this._dlg.finish();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ObjectGallery.this.setCanAdvance();
            }
        }
    }
}

