/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.FolderInfo;
import oracle.ide.gallery.GalleryElementActionFactory;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GalleryHandler;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.gallery.ObjectGallery;
import oracle.ide.gallery.RootGalleryFolder;

final class ObjectGalleryAddin
extends GalleryManager {
    private static final Logger LOGGER = Logger.getLogger(ObjectGalleryAddin.class.getName());
    private ObjectGallery _gallery;
    private Collection<ElementInfo> _galleryAddItems;
    private Collection<ElementInfo> _galleryRemoveItems;
    private Map<String, MetaClass> _generators;
    private Collection<FolderInfo> _foldersAdd;

    @Override
    public synchronized ObjectGallery getGallery() {
        if (this._gallery == null) {
            this._gallery = new ObjectGallery();
        }
        return this._gallery;
    }

    @Override
    public void registerGalleryElement(ElementInfo info) {
        if (info == null) {
            LOGGER.log(Level.SEVERE, "ElementInfo cannot be null.", new NullPointerException());
            return;
        }
        if (this._galleryAddItems == null) {
            this._galleryAddItems = new ArrayList<ElementInfo>();
        }
        if (!this.removeFromQueue(this._galleryRemoveItems, info) && !this._galleryAddItems.contains(info)) {
            this._galleryAddItems.add(info);
            GalleryElementActionFactory.getInstance().itemRegistered(info);
        }
    }

    @Override
    public void unregisterGalleryElement(ElementInfo info) {
        if (this._galleryRemoveItems == null) {
            this._galleryRemoveItems = new ArrayList<ElementInfo>();
        }
        if (!this.removeFromQueue(this._galleryAddItems, info)) {
            this._galleryRemoveItems.add(info);
            GalleryElementActionFactory.getInstance().itemUnregistered(info);
        }
    }

    private void registerBuilderMap(Map<String, MetaClass> map) {
        if (this._generators == null) {
            this._generators = new LinkedHashMap<String, MetaClass>();
        }
        this._generators.putAll(map);
    }

    @Override
    public Map<String, MetaClass> getBuilderMap() {
        this.registerBuilderMap(GalleryHandler.get().getGenerators());
        if (this._generators != null) {
            if (this.getRootFolder().getGeneratorMap() != null) {
                this._generators.putAll(this.getRootFolder().getGeneratorMap());
            }
            this.getRootFolder().setGeneratorMap(this._generators);
            this._generators = null;
        }
        return this.getRootFolder().getGeneratorMap();
    }

    void registerFolders(Collection<FolderInfo> folders) {
        if (this._foldersAdd == null) {
            this._foldersAdd = new LinkedHashSet<FolderInfo>();
        }
        this._foldersAdd.addAll(folders);
    }

    public void initialize() {
    }

    protected boolean addPendingGalleryItems(PrintStream log) {
        if (log != null) {
            log.println();
            log.println("Adding Items");
            log.println("--------------");
        }
        if (this._galleryAddItems != null) {
            boolean itemAdded = false;
            if (!this._galleryAddItems.isEmpty()) {
                GalleryHandler galleryHandler = GalleryHandler.get();
                Iterator<ElementInfo> iter = this._galleryAddItems.iterator();
                while (iter.hasNext()) {
                    ElementInfo info = iter.next();
                    if (!galleryHandler.accept(info)) {
                        iter.remove();
                        continue;
                    }
                    try {
                        if (log != null && info.getPath().length == 2) {
                            String nameInfo;
                            String[] pathInfo = info.getPath();
                            String string = nameInfo = info.getName() == null ? info.getInvokableClassName() : info.getName();
                            if (nameInfo == null) {
                                nameInfo = "";
                            }
                            log.println("Adding: " + pathInfo[0] + ": " + pathInfo[1] + ": " + nameInfo);
                        }
                        itemAdded = this.addGalleryElement(info) || itemAdded;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            this._galleryAddItems = null;
            return itemAdded;
        }
        return false;
    }

    protected boolean addPendingGalleryItems() {
        return this.addPendingGalleryItems(null);
    }

    protected void removePendingGalleryItems(PrintStream log) {
        if (log != null) {
            log.println();
            log.println("Removing Items");
            log.println("--------------");
        }
        if (this._galleryRemoveItems != null) {
            for (ElementInfo info : this._galleryRemoveItems) {
                String nameInfo;
                this.removeGalleryElement(info);
                if (log == null || info.getPath().length != 2) continue;
                String[] pathInfo = info.getPath();
                String string = nameInfo = info.getName() == null ? info.getInvokableClassName() : info.getName();
                if (nameInfo == null) {
                    nameInfo = "";
                }
                log.println(pathInfo[0] + ": " + pathInfo[1] + ": " + nameInfo + " removed");
            }
            this._galleryRemoveItems = null;
        }
    }

    protected void removePendingGalleryItems() {
        this.removePendingGalleryItems(null);
    }

    private RootGalleryFolder getRootFolder() {
        this.addFolders();
        return (RootGalleryFolder)this.getGallery().getModel();
    }

    private void addFolders() {
        RootGalleryFolder rootfolder = (RootGalleryFolder)this.getGallery().getModel();
        if (this._foldersAdd != null) {
            GalleryHandler galleryHandler = GalleryHandler.get();
            Iterator<FolderInfo> it = this._foldersAdd.iterator();
            while (it.hasNext()) {
                FolderInfo folder = it.next();
                if (!galleryHandler.accept(folder)) {
                    it.remove();
                    continue;
                }
                GalleryFolder gf = folder.getCategory() == null ? rootfolder.createFolder(folder.getName()) : rootfolder.createFolder(new String[]{folder.getCategory(), folder.getName()});
                gf.setLabel(folder.getLabel());
                gf.setUnsorted(folder.isUnsorted());
            }
            this._foldersAdd = null;
        }
    }

    private boolean addGalleryElement(ElementInfo info) {
        RootGalleryFolder rf = this.getRootFolder();
        GalleryFolder f = rf.createFolder(info.getPath());
        return f.addElement(info);
    }

    private boolean removeGalleryElement(ElementInfo info) {
        RootGalleryFolder rf = this.getRootFolder();
        GalleryFolder f = rf.getFolder(info.getPath());
        if (f == null) {
            return false;
        }
        return f.removeElement(info);
    }

    void invokeGallery(Context context) {
        this.getGallery().runDialog(context);
    }

    private boolean removeFromQueue(Collection items, ElementInfo info) {
        if (items == null) {
            return false;
        }
        boolean removed = false;
        if (!items.isEmpty() && items.contains(info)) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                ElementInfo next = (ElementInfo)it.next();
                if (!next.equals(info)) continue;
                it.remove();
                removed = true;
                break;
            }
        }
        return removed;
    }
}

