/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.util.Map;
import java.util.Properties;
import javax.ide.util.MetaClass;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GalleryProviderHandler;
import oracle.ide.model.Attributes;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.resource.GalleryArb;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;

public final class RootGalleryFolder
extends GalleryFolder
implements Dirtyable {
    private int _mainDividerLocation;
    private TreePath _selectedCategoryPath;
    private String _lastSelItem;
    private boolean _showDescriptions;
    private boolean _dirty;
    private Map<String, MetaClass> _generatorMap;
    private static final ElementAttributes _attributes = new ElementAttributes(ElementAttributes.OPEN_AS_TEXT);
    private static final String SHOW_ALL_DESCRIPTIONS_KEY = RootGalleryFolder.class.getName() + ".SHOW_ALL_DESCRIPTIONS";
    private GalleryProviderHandler _deferredProviderHandler;

    public RootGalleryFolder() {
        super(GalleryArb.getString((int)12));
    }

    @Deprecated
    public int getLastSelItem() {
        return -1;
    }

    @Deprecated
    public void setLastSelItem(int newItem) {
    }

    public String getLastSelectedItem() {
        return this._lastSelItem;
    }

    public void setLastSelectedItem(String newItem) {
        if (ModelUtil.areDifferent((Object)this._lastSelItem, (Object)newItem)) {
            this._lastSelItem = newItem;
        }
    }

    @Deprecated
    public Properties getGenerators() {
        return new Properties();
    }

    @Deprecated
    public void setGenerators(Properties prop) {
    }

    public Map<String, MetaClass> getGeneratorMap() {
        return this._generatorMap;
    }

    public void setGeneratorMap(Map<String, MetaClass> generatorMap) {
        this._generatorMap = generatorMap;
    }

    @Deprecated
    public int getLastSelCategory() throws TransientMarker {
        return -1;
    }

    @Deprecated
    public void setLastSelCategory(int newCategory) {
    }

    @Override
    public Attributes getAttributes() {
        return _attributes;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void markDirty(boolean dirty) {
        this._dirty = dirty;
    }

    protected TreePath getSelectedCategoryPath() {
        return this._selectedCategoryPath;
    }

    protected void setSelectedCategoryPath(TreePath selectedCategoryPath) {
        if (ModelUtil.areDifferent((Object)selectedCategoryPath, (Object)this._selectedCategoryPath)) {
            this._selectedCategoryPath = selectedCategoryPath;
        }
    }

    protected int getMainDividerLocation() {
        return this._mainDividerLocation;
    }

    protected void setMainDividerLocation(int mainDividerLocation) {
        this._mainDividerLocation = mainDividerLocation;
    }

    protected void setShowDescriptions(boolean showDescriptions) {
        if (this._showDescriptions != showDescriptions) {
            this._showDescriptions = showDescriptions;
            DTCache dtCache = Ide.getDTCache();
            dtCache.putBoolean(SHOW_ALL_DESCRIPTIONS_KEY, this._showDescriptions);
        }
    }

    protected boolean isShowDescriptions() {
        DTCache dtCache = Ide.getDTCache();
        this._showDescriptions = dtCache.getBoolean(SHOW_ALL_DESCRIPTIONS_KEY, false);
        return this._showDescriptions;
    }

    GalleryFolder getFolder(String[] path) {
        GalleryFolder f = this;
        for (int i = 0; i < path.length; ++i) {
            if ((f = f.getFolder(path[i])) != null) continue;
            return null;
        }
        return f;
    }

    GalleryFolder createFolder(String[] path) {
        GalleryFolder f = this;
        GalleryFolder owner = f.findFolder(path[path.length - 1]);
        if (owner != null) {
            if (path.length >= 2) {
                GalleryFolder parent = f.findFolder(path[0]);
                if (parent != null && parent.containsChild((Element)owner)) {
                    return owner;
                }
            } else {
                return owner;
            }
        }
        for (int i = 0; i < path.length; ++i) {
            if ((f = f.createFolder(path[i])) != null) continue;
            return null;
        }
        return f;
    }

    void setDeferredProviderHandler(GalleryProviderHandler lazyGalleryProvider) {
        this._deferredProviderHandler = lazyGalleryProvider;
    }

    boolean registerAllDeferredItems() {
        if (this._deferredProviderHandler != null) {
            return this._deferredProviderHandler.registerAllDeferredItems();
        }
        return false;
    }

    boolean registerDeferredItems(String folder) {
        if (this._deferredProviderHandler != null) {
            return this._deferredProviderHandler.registerDeferredItemsForFolder(folder);
        }
        return false;
    }

    boolean isFolderPopulatedLazily(String folderName) {
        return this._deferredProviderHandler.isPopulatedByGalleryProvider(folderName);
    }
}

