/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.gallery;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureRegistry;
import oracle.ide.gallery.GalleryElementActionFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.ide.util.Assert;
import oracle.ideimpl.gallery.GalleryElementReference;
import oracle.ideimpl.gallery.MruItem;
import oracle.ideimpl.gallery.MruItems;
import oracle.ideimpl.gallery.NewMenuHook;
import oracle.javatools.data.PropertyStorage;

final class NewMenuListenerForProject
implements ContextMenuListener {
    private final Map<String, List<JMenuItem>> _mruItemsCache = new HashMap<String, List<JMenuItem>>();
    private final Map<String, List<JMenuItem>> _featureItemsCache = new HashMap<String, List<JMenuItem>>();

    NewMenuListenerForProject() {
        Project.addProjectChangeListener((String)"project-level-mru-items", (ProjectChangeListener)new MruItemsStructureListener());
        Project.addProjectChangeListener((String)TechnologyScopeConfiguration.DATA_KEY, (ProjectChangeListener)new FeatureStructureListener());
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (context != null && context.getProject() != null) {
            this.addFeatureBasedMenuItems(contextMenu);
            if (!(context.getNode() instanceof Workspace)) {
                this.addProjectMruMenuItems(context.getProject(), contextMenu);
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void populate(ContextMenu contextMenu, List<JMenuItem> items, float sectionWeight) {
        for (JMenuItem menuItem : items) {
            contextMenu.add((Component)menuItem, sectionWeight);
        }
    }

    private void addProjectMruMenuItems(Project project, ContextMenu menu) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        String key = project.getLongLabel();
        if (this._mruItemsCache.containsKey(key) && !this._mruItemsCache.get(key).isEmpty()) {
            items.addAll((Collection)this._mruItemsCache.get(key));
        } else {
            ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
            this._mruItemsCache.put(key, menuItems);
            GalleryElementActionFactory actionFactory = GalleryElementActionFactory.getInstance();
            int maxItems = MruItems.MAX_ITEMS;
            List<MruItem> recentItems = MruItems.getInstance(project).recentlyCreatedItemsList();
            for (MruItem item : recentItems) {
                if (maxItems == 0) break;
                IdeAction action = actionFactory.actionForItemNamed(item.invokableClassName(), item.id());
                if (action == null || menu.getIndexOfCommandId(menu.getGUI(false), action.getCommandId()) != -1) continue;
                JMenuItem menuItem = menu.createMenuItem((ToggleAction)action, Integer.valueOf(item.position()).floatValue());
                menu.add((Component)menuItem, 7.077f);
                menuItems.add(menuItem);
                --maxItems;
            }
            items.addAll(menuItems);
        }
        this.populate(menu, items, 7.077f);
    }

    private void addFeatureBasedMenuItems(ContextMenu contextMenu) {
        Project project = contextMenu.getContext().getProject();
        Assert.check((project != null ? 1 : 0) != 0);
        List<JMenuItem> featureMenuItems = this.featureMenuItems(project, contextMenu);
        this.populate(contextMenu, featureMenuItems, 5.077f);
    }

    private Feature featureFor(TechId techId) {
        String key;
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        FeatureRegistry featureRegistry = extensionRegistry.getFeatureRegistry();
        Feature technologyFeature = featureRegistry.getFeatureAssociatedWithTechnology(key = techId.getKey());
        if (technologyFeature != null) {
            return technologyFeature;
        }
        if (!"General".equals(key)) {
            Logger.getLogger(NewMenuListenerForProject.class.getName()).log(Level.WARNING, techId + " technology is not associated with a Feature.");
        }
        return null;
    }

    private List<JMenuItem> featureMenuItems(Project project, ContextMenu contextMenu) {
        String key = project.getLongLabel();
        if (this._featureItemsCache.containsKey(key)) {
            return this._featureItemsCache.get(key);
        }
        TechnologyScopeConfiguration techConfig = TechnologyScopeConfiguration.getInstance((PropertyStorage)project);
        TechId[] techIds = techConfig.getTechnologyScope().toArray();
        HashSet dependencies = new HashSet();
        for (TechId tech : techIds) {
            dependencies.addAll(tech.getDependencies());
        }
        ArrayList<Feature> leafFeatures = new ArrayList<Feature>();
        for (TechId tech : techIds) {
            Feature feature;
            if (dependencies.contains(tech) || (feature = this.featureFor(tech)) == null) continue;
            leafFeatures.add(feature);
        }
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        for (Feature f : leafFeatures) {
            GalleryElementActionFactory actionFactory = GalleryElementActionFactory.getInstance();
            List memberExtensionIds = f.getMembers();
            for (String xId : memberExtensionIds) {
                List<GalleryElementReference> galleryItems = NewMenuHook.getGalleryItems(xId);
                for (GalleryElementReference item : galleryItems) {
                    IdeAction action = actionFactory.actionForItemNamed(item.getName(), item.getId());
                    if (action == null) continue;
                    JMenuItem menuItem = contextMenu.createMenuItem((ToggleAction)action);
                    contextMenu.add((Component)menuItem, 7.077f);
                    menuItems.add(menuItem);
                }
            }
        }
        this._featureItemsCache.put(key, menuItems);
        return menuItems;
    }

    private class FeatureStructureListener
    extends ProjectChangeListener {
        private FeatureStructureListener() {
        }

        public void projectPropertiesChanged(ProjectChangeEvent e) {
            String key = e.getProject().getLongLabel();
            if (NewMenuListenerForProject.this._featureItemsCache.containsKey(key)) {
                NewMenuListenerForProject.this._featureItemsCache.remove(key);
            }
        }
    }

    private class MruItemsStructureListener
    extends ProjectChangeListener {
        private MruItemsStructureListener() {
        }

        public void projectPropertiesChanged(ProjectChangeEvent e) {
            String key = e.getProject().getLongLabel();
            if (NewMenuListenerForProject.this._mruItemsCache.containsKey(key)) {
                NewMenuListenerForProject.this._mruItemsCache.remove(key);
            }
        }
    }
}

