/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.gallery;

import java.awt.Component;
import java.awt.Container;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.resource.GalleryArb;
import oracle.ide.util.Assert;
import oracle.ide.util.MnemonicSolver;
import oracle.ideimpl.extension.OldStyleMenuUtil;

final class NewMenuManager
implements Addin {
    static final float NEW_MENU_CUSTOMIZATIONS_SECTION_ID = 3.077f;
    static final float FEATURE_SECTION_ID = 5.077f;
    static final float MRU_SECTION_ID = 7.077f;
    private static final String FILE_NEW_SUBMENU_KEY = "file-new-submenu";
    private static final String PROJECT_SITE = "project-new-menu";
    private static final String APPLICATION_SITE = "app-new-menu";
    private static JMenuItem _newMenuItem;
    private static final ContextMenu PROJECT_CONTEXT_MENU;
    private static final ContextMenu APPLICATION_CONTEXT_MENU;
    private JMenu _newContextMenu;
    private MenuListener _newSubmenuListener;

    NewMenuManager() {
        if (!NewMenuManager.enhancedNewMenuIsSupported()) {
            return;
        }
        if (!NewMenuManager.newAction().isEnabled()) {
            return;
        }
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        ContextMenuListenersHook hook = (ContextMenuListenersHook)er.getHook(ContextMenuListenersHook.ELEMENT);
        if (hook != null) {
            ContextMenuListener appCML;
            ContextMenuListener pCML = hook.getListener(PROJECT_SITE);
            if (pCML != null) {
                PROJECT_CONTEXT_MENU.addContextMenuListener(pCML);
            }
            if ((appCML = hook.getListener(APPLICATION_SITE)) != null) {
                APPLICATION_CONTEXT_MENU.addContextMenuListener(appCML);
            }
        }
    }

    public void initialize() {
        JMenu fileMenu;
        if (!NewMenuManager.enhancedNewMenuIsSupported()) {
            return;
        }
        if (NewMenuManager.newAction().isEnabled()) {
            NavigatorManager navMgr = NavigatorManager.getApplicationNavigatorManager();
            if (navMgr != null) {
                NewContextMenuListener contextMenuListener = new NewContextMenuListener(null){

                    @Override
                    public void menuWillShow(ContextMenu contextMenu) {
                        if (this._menu == null) {
                            this._menu = NewMenuManager.this.getDynamicNewMenu((MenuManager)contextMenu);
                            Ide.getMenubar().sortSectionByName((JComponent)this._menu, 5.077f);
                        }
                        super.menuWillShow(contextMenu);
                    }
                };
                navMgr.addContextMenuListener((ContextMenuListener)contextMenuListener, null);
            }
            NewMenuManager.newAction().setLabelUpdater((LabelUpdater)new NewSubMenuLabelUpdater());
        }
        Assert.check(((fileMenu = MenuManager.getJMenu((String)"File")) != null ? 1 : 0) != 0, (String)"File menu was not found.");
        this.maybeAddNewSubMenu(fileMenu);
        fileMenu.addMenuListener(new FileMenuListener());
    }

    static boolean enhancedNewMenuIsSupported() {
        OldStyleMenuUtil util = OldStyleMenuUtil.getInstance();
        return util == null || !util.isOldStyleMenu();
    }

    private static IdeAction newAction() {
        return IdeAction.get((int)GalleryManager.OBJECT_GALLERY_CMD_ID);
    }

    private void maybeAddNewSubMenu(JMenu fileMenu) {
        JMenu fileNewSubmenu;
        if (NewMenuManager.newAction().isEnabled() && (fileNewSubmenu = MenuManager.getJMenu((String)FILE_NEW_SUBMENU_KEY)) == null) {
            Menubar menubar = Ide.getMenubar();
            fileNewSubmenu = menubar.createSubMenu(GalleryArb.getString((int)3), GalleryArb.getInteger((int)4), MenuConstants.WEIGHT_FILE_NEW_GALLERY);
            MenuManager.putJMenu((String)FILE_NEW_SUBMENU_KEY, (JMenu)fileNewSubmenu);
            menubar.add((Component)fileNewSubmenu, fileMenu, 1.0f);
        }
    }

    private void maybeAttachNewSubmenuListener(JMenu fileMenu) {
        if (NewMenuManager.newAction().isEnabled() && this._newSubmenuListener == null) {
            JMenu fileNewSubmenu = MenuManager.getJMenu((String)FILE_NEW_SUBMENU_KEY);
            this._newSubmenuListener = new FileNewSubmenuListener();
            fileNewSubmenu.addMenuListener(this._newSubmenuListener);
            Menubar menubar = Ide.getMenubar();
            Component newMenuItem = menubar.getChildById((Container)fileMenu, NewMenuManager.newAction().getCommandId());
            if (newMenuItem != null) {
                fileMenu.remove(newMenuItem);
            }
        }
    }

    private JMenu getDynamicNewMenu(MenuManager menuMgr) {
        if (this._newContextMenu == null) {
            Integer mnemonic = StringUtils.getMnemonicKeyCode((String)GalleryArb.getString((int)3));
            String label = StringUtils.stripMnemonic((String)GalleryArb.getString((int)3));
            this._newContextMenu = menuMgr.createSubMenu(label, mnemonic, Float.MIN_VALUE);
            menuMgr.sortSectionByName((JComponent)this._newContextMenu, 5.077f);
        }
        return this._newContextMenu;
    }

    static void populateNewMenuForContext(Context context, JMenu menu) {
        menu.removeAll();
        NewMenuManager.addNewMenuAction(menu);
        NewMenuManager.populateContextMenu(APPLICATION_SITE, context, menu, false);
        NewMenuManager.populateContextMenu(PROJECT_SITE, context, menu, false);
        NewMenuManager.newAction().putValue("label-as-new", null);
        NewMenuManager.newAction().updateAction(context);
    }

    private static void populateContextMenu(String site, Context context, JMenu menu, boolean destructive) {
        Component[] components;
        ContextMenu contextMenu;
        if (destructive) {
            menu.removeAll();
            NewMenuManager.addNewMenuAction(menu);
        }
        Menubar menubar = Ide.getMenubar();
        if (APPLICATION_SITE.equals(site)) {
            contextMenu = APPLICATION_CONTEXT_MENU;
        } else {
            contextMenu = PROJECT_CONTEXT_MENU;
            Container container = contextMenu.getGUI(false);
            if (container == null) {
                menubar.sortSectionByName((JComponent)PROJECT_CONTEXT_MENU.getGUI(true), 5.077f);
            }
        }
        contextMenu.prepareShow(context);
        for (Component ct : components = contextMenu.getGUI(false).getComponents()) {
            menubar.add(ct, menu);
        }
        NewMenuManager.resolveMnemonics(menu);
    }

    private static void resolveMnemonics(JMenu menu) {
        MnemonicSolver solver = new MnemonicSolver();
        for (Component c : menu.getMenuComponents()) {
            solver.addMenuLabel(c, true);
        }
        solver.solve();
    }

    private static void addNewMenuAction(JMenu menu) {
        Menubar menubar = Ide.getMenubar();
        if (_newMenuItem == null) {
            _newMenuItem = menubar.createMenuItem((ToggleAction)NewMenuManager.newAction(), MenuConstants.WEIGHT_FILE_NEW_GALLERY);
        }
        menubar.add((Component)_newMenuItem, menu, Float.MAX_VALUE);
    }

    static {
        PROJECT_CONTEXT_MENU = new ContextMenu(new MnemonicSolver());
        APPLICATION_CONTEXT_MENU = new ContextMenu(new MnemonicSolver());
    }

    private static class NewSubMenuLabelUpdater
    implements LabelUpdater {
        static final String USE_ORIGINAL_LABEL = "label-as-new";

        private NewSubMenuLabelUpdater() {
        }

        public String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
            if (Boolean.TRUE.equals(action.getValue(USE_ORIGINAL_LABEL))) {
                return originalLabel;
            }
            return GalleryArb.getString((int)333);
        }

        public String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
            return this.labelWhenEnabled(context, action, originalLabel);
        }

        public void setEnabledFormat(String format) {
        }

        public void setDisabledFormat(String format) {
        }
    }

    private final class FileMenuListener
    implements MenuListener {
        private FileMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            NewMenuManager.this.maybeAttachNewSubmenuListener((JMenu)e.getSource());
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }

    private final class FileNewSubmenuListener
    implements MenuListener {
        private FileNewSubmenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent event) {
            Context context;
            JMenu menu = (JMenu)event.getSource();
            Context ideContext = Context.newIdeContext();
            if (ideContext.getView() != null) {
                context = new Context(ideContext.getView().getContext((EventObject)event));
            } else {
                context = ideContext;
                context.setEvent((EventObject)event);
            }
            NewMenuManager.populateNewMenuForContext(context, menu);
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            JMenu fileNewSubMenu = (JMenu)e.getSource();
            fileNewSubMenu.removeAll();
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            menu.removeAll();
        }
    }

    private class NewContextMenuListener
    implements ContextMenuListener {
        volatile JMenu _menu;
        MenuListener _listener;

        NewContextMenuListener(JMenu menu) {
            this._menu = menu;
        }

        public void menuWillShow(ContextMenu contextMenu) {
            boolean populated = false;
            Context context = contextMenu.getContext();
            if (context != null) {
                if (context.getNode() instanceof Workspace) {
                    NewMenuManager.populateContextMenu(NewMenuManager.APPLICATION_SITE, context, this._menu, true);
                    populated = true;
                } else if (this.showProjectContextMenu(context)) {
                    NewMenuManager.populateContextMenu(NewMenuManager.PROJECT_SITE, context, this._menu, true);
                    populated = true;
                }
                if (populated) {
                    contextMenu.add((Component)this._menu, 1.0f);
                    Container menu = contextMenu.getGUI(false);
                    int index = contextMenu.getIndexOfCommandId(menu, GalleryManager.OBJECT_GALLERY_CMD_ID);
                    if (index != -1) {
                        menu.remove(index);
                    }
                }
            }
            NewMenuManager.newAction().putValue("label-as-new", (Object)(populated ? null : Boolean.TRUE));
        }

        private boolean showProjectContextMenu(Context context) {
            Element[] element;
            String id;
            if (context.getNode() instanceof Project) {
                return true;
            }
            return context.getView() != null && (id = context.getView().getId()).indexOf("ApplicationNavigatorWindow") != -1 && id.indexOf("ApplicationNavigatorName") != -1 && (element = context.getSelection()) != null && element.length == 1 && element[0].mayHaveChildren();
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }
}

