/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.postgresql;

import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;

public class PostgreSQLCaptureQueries
implements CaptureQueries {
    private static String CAPTURE_CATALOGS_QUERY = "select distinct(catalog_name) \"CATALOG\" from information_schema.schemata";
    private static final String CAPTURE_SCHEMAS_QUERY = "SELECT DISTINCT(SCHEMA_NAME) FROM INFORMATION_SCHEMA.SCHEMATA";
    private static final String CAPTURE_TABLES_QUERY = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES";

    public String getQueryForType(String string, MigrationObjectFilter migrationObjectFilter) {
        if (string.equals("MD_CATALOGS")) {
            return CAPTURE_CATALOGS_QUERY;
        }
        if (string.equals("MD_SCHEMAS")) {
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() != 0) {
                return "SELECT DISTINCT(SCHEMA_NAME) FROM INFORMATION_SCHEMA.SCHEMATA " + migrationObjectFilter.toWhereClause("SCHEMA_NAME");
            }
            return "SELECT DISTINCT(SCHEMA_NAME) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME IN (" + migrationObjectFilter.getSelectedDatabaseListString() + ")";
        }
        if (string.equals("MD_TABLES")) {
            if (migrationObjectFilter != null) {
                return "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES " + migrationObjectFilter.toWhereClause("TABLE_NAME") + " AND TABLE_SCHEMA = '${schema}'" + " AND TABLE_TYPE = 'BASE TABLE'";
            }
            return "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '${schema}' AND TABLE_TYPE = 'BASE TABLE'";
        }
        return null;
    }
}

