/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.csv.EHAVT;
import oracle.dbtools.crest.exports.csv.EHAttribute;
import oracle.dbtools.crest.exports.csv.EHCheckConstraint;
import oracle.dbtools.crest.exports.csv.EHClassificationType;
import oracle.dbtools.crest.exports.csv.EHColumn;
import oracle.dbtools.crest.exports.csv.EHComments;
import oracle.dbtools.crest.exports.csv.EHCommentsRDBMS;
import oracle.dbtools.crest.exports.csv.EHConstrIndexColumns;
import oracle.dbtools.crest.exports.csv.EHDomain;
import oracle.dbtools.crest.exports.csv.EHDomainAVT;
import oracle.dbtools.crest.exports.csv.EHDomainCheckConstraint;
import oracle.dbtools.crest.exports.csv.EHDomainValueRanges;
import oracle.dbtools.crest.exports.csv.EHEntity;
import oracle.dbtools.crest.exports.csv.EHEntityView;
import oracle.dbtools.crest.exports.csv.EHForeignKey;
import oracle.dbtools.crest.exports.csv.EHIndex;
import oracle.dbtools.crest.exports.csv.EHKey;
import oracle.dbtools.crest.exports.csv.EHKeyAttributes;
import oracle.dbtools.crest.exports.csv.EHLogicalToNative;
import oracle.dbtools.crest.exports.csv.EHLogicalType;
import oracle.dbtools.crest.exports.csv.EHMappings;
import oracle.dbtools.crest.exports.csv.EHModel;
import oracle.dbtools.crest.exports.csv.EHNativeToLogical;
import oracle.dbtools.crest.exports.csv.EHNotes;
import oracle.dbtools.crest.exports.csv.EHPKOidColumns;
import oracle.dbtools.crest.exports.csv.EHProcessAttributes;
import oracle.dbtools.crest.exports.csv.EHProcessEntities;
import oracle.dbtools.crest.exports.csv.EHRDBMSSites;
import oracle.dbtools.crest.exports.csv.EHRelation;
import oracle.dbtools.crest.exports.csv.EHSpatialColumnDefinition;
import oracle.dbtools.crest.exports.csv.EHSpatialDimension;
import oracle.dbtools.crest.exports.csv.EHTable;
import oracle.dbtools.crest.exports.csv.EHTableConstraints;
import oracle.dbtools.crest.exports.csv.EHTableIncludeScripts;
import oracle.dbtools.crest.exports.csv.EHTableView;
import oracle.dbtools.crest.exports.csv.EHValueRanges;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.exports.csv.SelectCSVExportDialog;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.ExportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class CSVExporter {
    private ApplicationView appView;
    private ProgressDialog monitor;
    private ExportLogger exportLog;
    private String exportFolder;
    private List ehList;
    private List designPartObjects = null;
    private List notes = new ArrayList();
    private List comments = new ArrayList();
    private List commentsRDBMS = new ArrayList();
    private Design design;
    private static final Logger LOGGER = new Logger(CSVExporter.class);

    public CSVExporter(ApplicationView view) {
        this.appView = view;
        this.design = this.appView.getCurrentDesign();
        this.exportLog = new ExportLogger("CSV");
    }

    protected boolean isModelSelected(DesignPart designPart) {
        if (this.designPartObjects != null) {
            for (SelectCSVExportDialog.ExpObject next : this.designPartObjects) {
                if (next.getObject() != designPart) continue;
                return next.isSelected();
            }
        }
        return false;
    }

    private void initExportHandlers() {
        this.ehList = new ArrayList();
        this.ehList.add(new EHModel(this));
        this.ehList.add(new EHDomain(this));
        this.ehList.add(new EHDomainCheckConstraint(this));
        this.ehList.add(new EHDomainValueRanges(this));
        this.ehList.add(new EHDomainAVT(this));
        this.ehList.add(new EHClassificationType(this));
        this.ehList.add(new EHEntity(this));
        this.ehList.add(new EHAttribute(this));
        this.ehList.add(new EHKey(this));
        this.ehList.add(new EHKeyAttributes(this));
        this.ehList.add(new EHRelation(this));
        this.ehList.add(new EHEntityView(this));
        this.ehList.add(new EHTable(this));
        this.ehList.add(new EHColumn(this));
        this.ehList.add(new EHIndex(this));
        this.ehList.add(new EHForeignKey(this));
        this.ehList.add(new EHTableView(this));
        this.ehList.add(new EHPKOidColumns(this));
        this.ehList.add(new EHConstrIndexColumns(this));
        this.ehList.add(new EHSpatialColumnDefinition(this));
        this.ehList.add(new EHSpatialDimension(this));
        this.ehList.add(new EHTableIncludeScripts(this));
        this.ehList.add(new EHTableConstraints(this));
        this.ehList.add(new EHCheckConstraint(this));
        this.ehList.add(new EHValueRanges(this));
        this.ehList.add(new EHAVT(this));
        this.ehList.add(new EHMappings(this));
        this.ehList.add(new EHRDBMSSites(this));
        this.ehList.add(new EHLogicalType(this));
        this.ehList.add(new EHLogicalToNative(this));
        this.ehList.add(new EHNativeToLogical(this));
        this.ehList.add(new EHProcessEntities(this));
        this.ehList.add(new EHProcessAttributes(this));
        this.ehList.add(new EHNotes(this));
        this.ehList.add(new EHComments(this));
        this.ehList.add(new EHCommentsRDBMS(this));
    }

    private void initNumIDs() {
        ModelIDObject next;
        ModelIDObject next2;
        int counter = 1;
        Iterator it = this.design.getDomainSet().iterator();
        while (it.hasNext()) {
            next2 = (ModelIDObject)it.next();
            next2.setNumID(counter);
            ++counter;
        }
        it = this.design.getLogicalDatatypeSet().iterator();
        while (it.hasNext()) {
            next2 = (ModelIDObject)it.next();
            next2.setNumID(counter);
            ++counter;
        }
        LogicalDesign logDesign = this.design.getLogicalDesign();
        if (this.isModelSelected(logDesign)) {
            ModelIDObject next3;
            logDesign.setNumID(counter);
            ++counter;
            it = logDesign.getEntitySet().iterator();
            while (it.hasNext()) {
                next3 = (ModelIDObject)it.next();
                next3.setNumID(counter);
                ++counter;
            }
            it = logDesign.getAttributeSet().iterator();
            while (it.hasNext()) {
                next3 = (ModelIDObject)it.next();
                next3.setNumID(counter);
                ++counter;
            }
            it = logDesign.getGlobalCandidateKeySet().iterator();
            while (it.hasNext()) {
                next3 = (ModelIDObject)it.next();
                next3.setNumID(counter);
                ++counter;
            }
            it = logDesign.getRelationSet().iterator();
            while (it.hasNext()) {
                next3 = (ModelIDObject)it.next();
                next3.setNumID(counter);
                ++counter;
            }
            it = logDesign.getEntityViewSet().iterator();
            while (it.hasNext()) {
                next3 = (ModelIDObject)it.next();
                next3.setNumID(counter);
                ++counter;
            }
            it = logDesign.getAttributeViewSet().iterator();
            while (it.hasNext()) {
                next3 = (ModelIDObject)it.next();
                next3.setNumID(counter);
                ++counter;
            }
        }
        Iterator iter = this.design.getRelationalDesigns().iterator();
        while (iter.hasNext()) {
            RelationalDesign phDesign = (RelationalDesign)iter.next();
            if (!this.isModelSelected(phDesign)) continue;
            phDesign.setNumID(counter);
            ++counter;
            it = phDesign.getTableSet().iterator();
            while (it.hasNext()) {
                next = (ModelIDObject)it.next();
                next.setNumID(counter);
                ++counter;
            }
            it = phDesign.getColumnSet().iterator();
            while (it.hasNext()) {
                next = (ModelIDObject)it.next();
                next.setNumID(counter);
                ++counter;
            }
            it = phDesign.getGlobalIndexSet().iterator();
            while (it.hasNext()) {
                next = (ModelIDObject)it.next();
                next.setNumID(counter);
                ++counter;
            }
            it = phDesign.getFKIndexAssociationSet().iterator();
            while (it.hasNext()) {
                next = (ModelIDObject)it.next();
                next.setNumID(counter);
                ++counter;
            }
            it = phDesign.getTableViewSet().iterator();
            while (it.hasNext()) {
                next = (ModelIDObject)it.next();
                next.setNumID(counter);
                ++counter;
            }
            it = phDesign.getColumnViewSet().iterator();
            while (it.hasNext()) {
                next = (ModelIDObject)it.next();
                next.setNumID(counter);
                ++counter;
            }
        }
        DataTypesDesign dtDesign = this.design.getDataTypesDesign();
        if (this.isModelSelected(dtDesign)) {
            dtDesign.setNumID(counter);
            ++counter;
            it = dtDesign.getStructuredTypeSet().iterator();
            while (it.hasNext()) {
                next = (ModelIDObject)it.next();
                next.setNumID(counter);
                ++counter;
            }
            it = dtDesign.getCollectionTypeSet().iterator();
            while (it.hasNext()) {
                next = (ModelIDObject)it.next();
                next.setNumID(counter);
                ++counter;
            }
            it = dtDesign.getDistinctTypeSet().iterator();
            while (it.hasNext()) {
                next = (ModelIDObject)it.next();
                next.setNumID(counter);
                ++counter;
            }
        }
        ProcessModel processModel = this.design.getProcessModel();
        it = processModel.getDataFlowDesigns().iterator();
        while (it.hasNext()) {
            DataFlowDesign dfd = (DataFlowDesign)it.next();
            dfd.setNumID(++counter);
            Iterator dfdit = dfd.getProcessSet().iterator();
            while (dfdit.hasNext()) {
                Process process = (Process)dfdit.next();
                process.setNumID(++counter);
            }
            dfdit = dfd.getFlowSet().iterator();
            while (dfdit.hasNext()) {
                Flow flow = (Flow)dfdit.next();
                flow.setNumID(++counter);
            }
        }
    }

    private void deleteDB() {
        File file = new File(this.exportFolder, "csvDB");
        if (file.exists() && !this.deleteDir(file)) {
            MessageDialogs.showWarningMessage(MessageFormat.format(Messages.getString("CSVExporter.InternalDatabaseFolderCanNotBeDeleted"), file.getAbsoluteFile()));
        }
    }

    public boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public void execute() {
        new Thread(new Runner()).start();
    }

    public String getExportFolder() {
        return this.exportFolder;
    }

    public void setExportFolder(String exportFolder) {
        this.exportFolder = exportFolder;
    }

    public Design getDesign() {
        return this.design;
    }

    public void setDesignPartObjects(List designPartObjects) {
        this.designPartObjects = designPartObjects;
    }

    public List getNotes() {
        return this.notes;
    }

    public List getComments() {
        return this.comments;
    }

    public List getCommentsRDBMS() {
        return this.commentsRDBMS;
    }

    public void addNote(String objectID, int numOID, String type, String text) {
        this.notes.add(new ObjDesc(objectID, numOID, type, text));
    }

    public void addComment(String objectID, int numOID, String type, String text) {
        this.comments.add(new ObjDesc(objectID, numOID, type, text));
    }

    public void addCommentRDBMS(String objectID, int numOID, String type, String text) {
        this.commentsRDBMS.add(new ObjDesc(objectID, numOID, type, text));
    }

    public ApplicationView getAppView() {
        return this.appView;
    }

    class ObjDesc {
        String objectID;
        int numOID;
        String type;
        String text;

        public ObjDesc(String objectID, int numOID, String type, String text) {
            this.objectID = objectID;
            this.numOID = numOID;
            this.type = type;
            this.text = text;
        }

        public String getObjectID() {
            return this.objectID;
        }

        public int getNumOID() {
            return this.numOID;
        }

        public String getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
            try {
                CSVExporter.this.monitor = new ProgressDialog(CSVExporter.this.appView, "", 0, 100);
                try {
                    CSVExporter.this.deleteDB();
                    CSVExporter.this.monitor.setNote(Messages.getString("CSVExporter.Initializing"));
                    CSVExporter.this.monitor.setProgress(1);
                    CSVExporter.this.initExportHandlers();
                    CSVExporter.this.initNumIDs();
                    CSVExporter.this.monitor.setNote(Messages.getString("CSVExporter.Export"));
                    CSVExporter.this.monitor.setProgress(10);
                    double pos = 10.0;
                    int length = CSVExporter.this.ehList.size();
                    Iterator it = CSVExporter.this.ehList.iterator();
                    while (it.hasNext()) {
                        CSVExporter.this.monitor.setProgress((int)(pos += 90.0 / (double)length));
                        ExportHandler eh = (ExportHandler)it.next();
                        eh.Export();
                    }
                }
                finally {
                    CSVExporter.this.monitor.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error Exporting to CSV: ", e);
                CSVExporter.this.exportLog.addError(e.toString());
            }
            finally {
                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                LogReport logPanel = new LogReport(CSVExporter.this.appView);
                logPanel.setLog(CSVExporter.this.exportLog.generateReport(CSVExporter.this.appView));
                logPanel.showDialog(new Dimension(750, 550));
            }
        }
    }
}

