/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSType;

public class EHCheckConstraint
extends ExportHandler {
    private List elements = new ArrayList();

    public EHCheckConstraint(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        Iterator it;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("DataElement_ID").append(",");
        sb.append("Num_DataElement_ID").append(",");
        sb.append("Type").append(",");
        sb.append("Sequence").append(",");
        sb.append("Constraint_Name").append(",");
        sb.append("Text").append(",");
        sb.append("Database_Type").append(",");
        sb.append("Container_Name").append(",");
        sb.append("DataElement_Name");
        lines.add(sb.toString());
        LogicalDesign logDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logDesign)) {
            it = logDesign.getAttributeSet().iterator();
            while (it.hasNext()) {
                this.elements.add(it.next());
            }
        }
        it = this.getDesign().getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign phDesign = (RelationalDesign)it.next();
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            Iterator cit = phDesign.getColumnSet().iterator();
            while (cit.hasNext()) {
                this.elements.add(cit.next());
            }
        }
        for (ContainedObject element : this.elements) {
            CheckConstraint check = element.getCheck();
            int seq = 0;
            if (check == null) continue;
            String generic = check.getGenericConstraint();
            if (generic != null && !"".equalsIgnoreCase(generic)) {
                ++seq;
                sb = new StringBuffer();
                sb.append(element.getObjectID()).append(",");
                sb.append(element.getNumID()).append(",");
                if (element instanceof Attribute) {
                    sb.append("Attribute").append(",");
                } else {
                    sb.append("Column").append(",");
                }
                sb.append(seq).append(",");
                sb.append(this.replaceAndQuoteString(check.getName())).append(",");
                sb.append(this.replaceAndQuoteString(generic)).append(",");
                sb.append(check.getSelectedRDBMSType().getName()).append(",");
                sb.append(element.getContainer().getName()).append(",");
                sb.append(this.replaceAndQuoteString(element.getName())).append(",");
                lines.add(sb.toString());
            }
            Object[] types = check.getTypes();
            for (int i = 0; i < types.length; ++i) {
                RDBMSType type = (RDBMSType)types[i];
                String text = check.getImplementationFor(type);
                if (text == null || "".equalsIgnoreCase(text)) continue;
                ++seq;
                sb = new StringBuffer();
                sb.append(element.getObjectID()).append(",");
                sb.append(element.getNumID()).append(",");
                if (element instanceof Attribute) {
                    sb.append("Attribute").append(",");
                } else {
                    sb.append("Column").append(",");
                }
                sb.append(seq).append(",");
                sb.append(this.replaceAndQuoteString(check.getName())).append(",");
                sb.append(this.replaceAndQuoteString(text)).append(",");
                sb.append(this.replaceAndQuoteString(type.getName())).append(",");
                sb.append(element.getContainer().getName()).append(",");
                sb.append(this.replaceAndQuoteString(element.getName())).append(",");
                lines.add(sb.toString());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Check_Constraints.csv";
    }
}

