/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class EHConstrIndexColumns
extends ExportHandler {
    public EHConstrIndexColumns(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Index_ID").append(",");
        sb.append("Num_Index_ID").append(",");
        sb.append("ColumnID").append(",");
        sb.append("Num_ColumnID").append(",");
        sb.append("Table_ID").append(",");
        sb.append("Num_Table_ID").append(",");
        sb.append("Index_Name").append(",");
        sb.append("Table_Name").append(",");
        sb.append("Column_Name").append(",");
        sb.append("Sequence").append(",");
        sb.append("Sort_Order");
        lines.add(sb.toString());
        Iterator it = this.getDesign().getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign phDesign = (RelationalDesign)it.next();
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            Iterator indexit = phDesign.getGlobalIndexSet().iterator();
            while (indexit.hasNext()) {
                Index index = (Index)indexit.next();
                ContainedObject[] columns = index.getElements();
                for (int i = 0; i < columns.length; ++i) {
                    ContainedObject column = columns[i];
                    sb = new StringBuffer();
                    sb.append(index.getObjectID()).append(",");
                    sb.append(index.getNumID()).append(",");
                    sb.append(column.getObjectID()).append(",");
                    sb.append(column.getNumID()).append(",");
                    sb.append(index.getContainerObject().getObjectID()).append(",");
                    sb.append(index.getContainerObject().getNumID()).append(",");
                    sb.append(this.replaceAndQuoteString(index.getName())).append(",");
                    sb.append(this.replaceAndQuoteString(index.getContainerObject().getName())).append(",");
                    sb.append(this.replaceAndQuoteString(column.getName())).append(",");
                    sb.append(i + 1).append(",");
                    sb.append(index.getColumnSortOrder(column)).append(",");
                    lines.add(sb.toString());
                }
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Constr_Index_Columns.csv";
    }
}

