/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;

public class EHKey
extends ExportHandler {
    public EHKey(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Key_Name").append(",");
        sb.append("ObjectID").append(",");
        sb.append("NumOID").append(",");
        sb.append("ImportID").append(",");
        sb.append("ContainerID").append(",");
        sb.append("Num_ContainerID").append(",");
        sb.append("State Type").append(",");
        sb.append("Synonyms").append(",");
        sb.append("Entity_Name");
        lines.add(sb.toString());
        LogicalDesign logDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logDesign)) {
            Iterator it = logDesign.getGlobalCandidateKeySet().iterator();
            while (it.hasNext()) {
                CandidateKey key = (CandidateKey)it.next();
                sb = new StringBuffer();
                sb.append(this.replaceAndQuoteString(key.getName())).append(",");
                sb.append(key.getObjectID()).append(",");
                sb.append(key.getNumID()).append(",");
                sb.append(key.getImportedId() != null ? key.getImportedId() : "").append(",");
                sb.append(key.getContainerObject().getObjectID()).append(",");
                sb.append(key.getContainerObject().getNumID()).append(",");
                sb.append(key.getKeyState()).append(",");
                sb.append(this.quotedString(key.getSynonym())).append(",");
                sb.append(this.replaceAndQuoteString(key.getContainerObject().getName())).append(",");
                lines.add(sb.toString());
                this.getCsvExporter().addNote(key.getObjectID(), key.getNumID(), "Key", key.getNotes());
                this.getCsvExporter().addComment(key.getObjectID(), key.getNumID(), "Key", key.getComment());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Keys.csv";
    }
}

