/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.RDBMSType;

public class EHLogicalToNative
extends ExportHandler {
    public EHLogicalToNative(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Logical_Type_ID").append(",");
        sb.append("LT_Name").append(",");
        sb.append("Native_Type").append(",");
        sb.append("RDBMS_Type").append(",");
        sb.append("RDBMS_Version").append(",");
        sb.append("Has_Size").append(",");
        sb.append("Has_Precision").append(",");
        sb.append("Has_Scale");
        lines.add(sb.toString());
        Iterator it = this.getDesign().getLogicalDatatypeSet().iterator();
        while (it.hasNext()) {
            LogicalDatatype ldt = (LogicalDatatype)it.next();
            Map m = ldt.getToPhysical();
            Iterator tit = this.getDesign().getDefaultRDBMSTypeSet().iterator();
            while (tit.hasNext()) {
                RDBMSType type = (RDBMSType)tit.next();
                MDDataType mdt = ldt.createDataType(type.getName(), m);
                if (mdt == null) continue;
                sb = new StringBuffer();
                sb.append(ldt.getObjectID()).append(",");
                sb.append(this.replaceAndQuoteString(ldt.getName())).append(",");
                sb.append(this.replaceAndQuoteString(mdt.getName())).append(",");
                sb.append(type.getProductName()).append(",");
                sb.append(type.getVersionName()).append(",");
                sb.append(mdt.hasSize() && this.hasSize(mdt.getSize()) ? "Y" : "N").append(",");
                sb.append(mdt.hasPrecision() && mdt.getPrecision() > 0 ? "Y" : "N").append(",");
                sb.append(mdt.hasScale() && mdt.getScale() > 0 ? "Y" : "N").append(",");
                lines.add(sb.toString());
            }
        }
        this.saveToFile(lines);
    }

    private boolean hasSize(String size) {
        if (size != null && !"".equalsIgnoreCase(size)) {
            return !"0".equalsIgnoreCase(size);
        }
        return false;
    }

    @Override
    public String getFileName() {
        return "DM_Logical_To_Native.csv";
    }
}

