/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.RDBMSType;

public class EHNativeToLogical
extends ExportHandler {
    public EHNativeToLogical(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("RDBMS_Type").append(",");
        sb.append("RDBMS_Version").append(",");
        sb.append("Native_Type").append(",");
        sb.append("LT_Name").append(",");
        sb.append("Logical_Type_ID");
        lines.add(sb.toString());
        Iterator it = this.getDesign().getDefaultRDBMSTypeSet().iterator();
        while (it.hasNext()) {
            RDBMSType type = (RDBMSType)it.next();
            String[] dataTypes = StandardDatatypeNames.getAllPossibleDatatypes(type);
            for (int j = 0; j < dataTypes.length; ++j) {
                String dt = dataTypes[j];
                if (dt.equalsIgnoreCase("UNKNOWN")) continue;
                String usedtype = StandardDatatypeNames.getUsedDatatypeName(dt);
                if (!dt.equals(usedtype = StandardDatatypeNames.getTransformedDatatypeName(usedtype, type))) continue;
                LogicalDatatype ltype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(type, usedtype);
                if (ltype == null) {
                    ltype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(type, dt);
                }
                if (ltype == null) continue;
                sb = new StringBuffer();
                sb.append(type.getProductName()).append(",");
                sb.append(type.getVersionName()).append(",");
                sb.append(dt).append(",");
                sb.append(this.replaceAndQuoteString(ltype.getName())).append(",");
                sb.append(ltype.getObjectID()).append(",");
                lines.add(sb.toString());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Native_To_Logical.csv";
    }
}

