/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;

public class EHSpatialDimension
extends ExportHandler {
    public EHSpatialDimension(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Definition_ID").append(",");
        sb.append("Definition_Name").append(",");
        sb.append("Low_Boundary").append(",");
        sb.append("Upper_Boundary").append(",");
        sb.append("Tolerance");
        lines.add(sb.toString());
        Iterator it = this.getDesign().getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign phDesign = (RelationalDesign)it.next();
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            Iterator tit = phDesign.getTableSet().iterator();
            while (tit.hasNext()) {
                Table table = (Table)tit.next();
                for (SpatialColumnDefObject sd : table.getSpatialDefinitions()) {
                    for (SpatialColumnDefObject.TableDimension dimension : sd.getTableDimensions()) {
                        sb = new StringBuffer();
                        sb.append(sd.getId()).append(",");
                        sb.append(this.replaceAndQuoteString(dimension.getName())).append(",");
                        sb.append(dimension.getLowBoundary()).append(",");
                        sb.append(dimension.getUpperBoundary()).append(",");
                        sb.append(dimension.getTolerance()).append(",");
                        lines.add(sb.toString());
                    }
                }
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Spatial_Dimensions.csv";
    }
}

