/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;

public class EHTableConstraints
extends ExportHandler {
    public EHTableConstraints(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("ObjectID").append(",");
        sb.append("NumOID").append(",");
        sb.append("Sequence").append(",");
        sb.append("Constraint_Name").append(",");
        sb.append("Text").append(",");
        sb.append("Table_Name");
        lines.add(sb.toString());
        Iterator it = this.getDesign().getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign phDesign = (RelationalDesign)it.next();
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            Iterator tit = phDesign.getTableSet().iterator();
            while (tit.hasNext()) {
                Table table = (Table)tit.next();
                Iterator tlcit = table.getCheckConstraints().iterator();
                int seq = 0;
                while (tlcit.hasNext()) {
                    ++seq;
                    TableLevelConstraint constraint = (TableLevelConstraint)tlcit.next();
                    sb = new StringBuffer();
                    sb.append(table.getObjectID()).append(",");
                    sb.append(table.getNumID()).append(",");
                    sb.append(seq).append(",");
                    sb.append(this.replaceAndQuoteString(constraint.getName())).append(",");
                    sb.append(this.replaceAndQuoteString(constraint.getRule())).append(",");
                    sb.append(this.replaceAndQuoteString(table.getName())).append(",");
                    lines.add(sb.toString());
                }
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Table_Constraints.csv";
    }
}

