/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;

public class EHTableIncludeScripts
extends ExportHandler {
    public EHTableIncludeScripts(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("ObjectID").append(",");
        sb.append("NumOID").append(",");
        sb.append("Type").append(",");
        sb.append("Sequence").append(",");
        sb.append("Text");
        lines.add(sb.toString());
        Iterator it = this.getDesign().getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign phDesign = (RelationalDesign)it.next();
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            Iterator tit = phDesign.getTableSet().iterator();
            while (tit.hasNext()) {
                Table table = (Table)tit.next();
                this.addScript(table, lines, "Before Drop/Rename", this.replaceString(table.getBeforeDrop()));
                this.addScript(table, lines, "Before Create", this.replaceString(table.getBeforeCreate()));
                this.addScript(table, lines, "After Create", this.replaceString(table.getAfterCreate()));
                this.addScript(table, lines, "End of Script", this.replaceString(table.getEndOfScript()));
            }
        }
        this.saveToFile(lines);
    }

    private void addScript(Table table, List lines, String type, String text) {
        if (!"".equalsIgnoreCase(text)) {
            int seq = 0;
            while (text.length() > 2000) {
                ++seq;
                String t1 = text.substring(0, 2000);
                text = text.substring(2000);
                StringBuffer sb = new StringBuffer();
                sb.append(table.getObjectID()).append(",");
                sb.append(table.getNumID()).append(",");
                sb.append(type).append(",");
                sb.append(seq).append(",");
                sb.append(this.quotedString(t1)).append(",");
                lines.add(sb.toString());
            }
            if (text.length() > 0) {
                ++seq;
                StringBuffer sb = new StringBuffer();
                sb.append(table.getObjectID()).append(",");
                sb.append(table.getNumID()).append(",");
                sb.append(type).append(",");
                sb.append(seq).append(",");
                sb.append(this.quotedString(text));
                lines.add(sb.toString());
            }
        }
    }

    @Override
    public String getFileName() {
        return "DM_Table_Include_Scripts.csv";
    }
}

