/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBDataBaseDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBFKeyDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBStorageGroupDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBTableDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBTableSpaceDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBViewDB2v70;

public class DDLGenerator {
    public static final String TYPE_DROP_GEN = "DropGen";
    private String label = "Default";
    private SQLStatementBuilder first;

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    protected void initChainOfResponsibility() {
        this.append(new SSBTableDB2v70());
        this.append(new SSBFKeyDB2v70());
        this.append(new SSBDataBaseDB2v70());
        this.append(new SSBStorageGroupDB2v70());
        this.append(new SSBTableSpaceDB2v70());
        this.append(new SSBViewDB2v70());
    }

    public SQLStatementBuilder getFirst() {
        if (this.first == null) {
            this.initChainOfResponsibility();
        }
        return this.first;
    }

    public String getDDLFor(Object object) {
        StringBuffer buffer = new StringBuffer();
        this.appendDDLFor(buffer, object);
        return buffer.toString();
    }

    public StringBuffer appendDDLFor(StringBuffer buffer, Object object) {
        SQLStatementBuilder ssb = this.getFirst();
        if (ssb == null) {
            buffer.append("DDL Generator not initialized");
        } else if (ssb != null) {
            ssb.appendTo(buffer, object, true);
        }
        return buffer;
    }

    public void append(SQLStatementBuilder ssb) {
        if (this.first == null) {
            this.first = ssb;
        } else {
            this.first.append(ssb);
        }
        ssb.setDDLGenerator(this);
    }

    public void clearTemporaryObjects() {
        for (SQLStatementBuilder sb = this.getFirst(); sb != null; sb = sb.getSuccessor()) {
            sb.clearTemporaryObjects();
        }
    }

    public void doOnFinish(StringBuffer buffer) {
        for (SQLStatementBuilder sb = this.getFirst(); sb != null; sb = sb.getSuccessor()) {
            sb.doOnFinish(buffer);
        }
    }
}

