/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class SQLAnalyzer {
    public static final String TYPE_TABLE = "table";
    public static final String TYPE_FUNCTION = "function";
    public static final String TYPE_PACKAGE = "package";
    private static final String t_ref = "table_reference";
    private static final String u_funct = "user_defined_function";
    private static final String dml_table = "aliased_dml_table_expression_clause";
    private static final String function_call = "function_call";
    private static final String prm_spec_type = "prm_spec_unconstrained_type";

    private static boolean hasString(String[] split, String str) {
        for (int i = 1; i < split.length; ++i) {
            if (!str.equals(split[i].trim())) continue;
            return true;
        }
        return false;
    }

    private static String getContent(ParseNode pn, List<LexerToken> src) {
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = pn.from; i < pn.to; ++i) {
                sb.append(src.get((int)i).content);
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static void parseContentForTable(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        try {
            int p = 0;
            for (int i = pn.from; i < pn.to; ++i) {
                String temp = src.get((int)i).content;
                if (p == 0) {
                    if (temp.startsWith("(")) break;
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    pd.valid = true;
                } else if (p == 1) {
                    if (!".".equals(temp)) break;
                    pd.schema = pd.name;
                    pd.name = null;
                } else if (p == 2) {
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    break;
                }
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    private static void parseContentForParameterSpec(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        try {
            boolean percentFound = false;
            String colName = null;
            int p = 0;
            for (int i = pn.from; i < pn.to; ++i) {
                String temp = src.get((int)i).content;
                if (percentFound) {
                    if (temp.equalsIgnoreCase("TYPE")) {
                        if (pd.name != null) {
                            pd.valid = true;
                        }
                    } else if (temp.equalsIgnoreCase("ROWTYPE")) {
                        pd.schema = pd.name;
                        pd.name = colName;
                        pd.valid = true;
                    }
                    break;
                }
                if (p == 0) {
                    colName = Token.getValBetweenDoubleQuotes(temp);
                } else if (p == 2) {
                    pd.name = colName;
                    colName = Token.getValBetweenDoubleQuotes(temp);
                } else if (p == 4) {
                    pd.schema = pd.name;
                    pd.name = colName;
                    colName = Token.getValBetweenDoubleQuotes(temp);
                } else if ("%".equals(temp)) {
                    percentFound = true;
                } else if (!".".equals(temp)) break;
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    private static void parseContentForFunction(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        int p = 0;
        try {
            for (int i = pn.from; i < pn.to; ++i) {
                String temp = src.get((int)i).content;
                if (temp.startsWith("(")) {
                    pd.valid = p > 0;
                    return;
                }
                if (p == 0) {
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                } else if (".".equals(temp)) {
                    if (p == 1) {
                        pd.schema = pd.name;
                        pd.name = null;
                    } else if (p == 3) {
                        pd.pack = pd.name;
                        pd.name = null;
                    }
                } else if (p == 2 || p == 4) {
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    if (p == 4) break;
                }
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    public static List<PDescriptor> getTablesAndFunctions(String sql) {
        HashMap<String, PDescriptor> tmap = null;
        HashMap<String, PDescriptor> fmap = null;
        ArrayList<PDescriptor> list = new ArrayList<PDescriptor>();
        SqlEarley earley = SqlEarley.getInstance();
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        try {
            earley.parse(src, matrix);
            ParseNode root = earley.forest(src, matrix);
            if (root != null) {
                for (ParseNode n : root.descendants()) {
                    String name;
                    PDescriptor pd;
                    String tostr = n.toString();
                    String[] split = tostr.split("  ");
                    if (split.length <= 1) continue;
                    if (SQLAnalyzer.hasString(split, t_ref) || SQLAnalyzer.hasString(split, dml_table)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        SQLAnalyzer.parseContentForTable(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap<String, PDescriptor>();
                        }
                        if (tmap.get(name) != null) continue;
                        list.add(pd);
                        tmap.put(name, pd);
                        continue;
                    }
                    if (SQLAnalyzer.hasString(split, u_funct) || SQLAnalyzer.hasString(split, function_call)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_FUNCTION;
                        SQLAnalyzer.parseContentForFunction(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (fmap == null) {
                            fmap = new HashMap<String, PDescriptor>();
                        }
                        if (fmap.get(name) != null) continue;
                        list.add(pd);
                        fmap.put(name, pd);
                        continue;
                    }
                    if (!split[1].trim().equals(prm_spec_type)) continue;
                    pd = new PDescriptor();
                    pd.type = TYPE_TABLE;
                    SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                    if (!pd.valid) continue;
                    name = pd.toString();
                    if (tmap == null) {
                        tmap = new HashMap();
                    }
                    if (tmap.get(name) != null) continue;
                    list.add(pd);
                    tmap.put(name, pd);
                }
            }
        }
        catch (StackOverflowError exc) {
            // empty catch block
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        String sql = Service.readFile((String)"D:/testaa.sql");
        SqlEarley earley = SqlEarley.getInstance();
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(src, matrix);
        ParseNode root = earley.forest(src, matrix);
        for (ParseNode n : root.descendants()) {
            PDescriptor pd;
            String cont;
            String tostr = n.toString();
            String[] split = tostr.split("  ");
            if (SQLAnalyzer.hasString(split, t_ref) || SQLAnalyzer.hasString(split, dml_table)) {
                cont = SQLAnalyzer.getContent(n, src);
                pd = new PDescriptor();
                pd.element = cont;
                SQLAnalyzer.parseContentForTable(n, src, pd);
                System.out.println("table " + cont);
                System.out.println("table " + String.valueOf(pd.schema) + "." + pd.name + "  - valid " + pd.valid);
                continue;
            }
            if (!SQLAnalyzer.hasString(split, u_funct) && !SQLAnalyzer.hasString(split, function_call) || (cont = n.content(src)).indexOf("(") <= 0) continue;
            pd = new PDescriptor();
            pd.element = cont;
            pd.type = TYPE_FUNCTION;
            SQLAnalyzer.parseContentForFunction(n, src, pd);
            System.out.println("function " + cont);
            System.out.println("function " + String.valueOf(pd.schema) + "." + String.valueOf(pd.pack) + "." + pd.name);
        }
    }

    public static class PDescriptor {
        public String element;
        public String type;
        public String schema;
        public String name;
        public String pack;
        boolean valid = false;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(String.valueOf(this.schema)).append(".").append(String.valueOf(this.pack)).append(".").append(this.name);
            return sb.toString().toUpperCase();
        }
    }
}

