/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseDB2v70
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;
    private static final String INDEX_BP = "INDEXBP";

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseDB2 && ((DataBaseDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        DataBaseDB2 database = (DataBaseDB2)object;
        if (!database.isNullInstance()) {
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(database);
            this.appendComment(buffer, database);
            this.appendCreate(buffer);
            SSBDataBaseDB2v70.appendStringWithSpace(buffer, "DATABASE");
            SSBDataBaseDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(database.getLongNameDDL()));
            this.appendBufferPool(buffer, database, prettyPrint);
            this.appendIndexBufferPool(buffer, database, prettyPrint);
            this.appendType(buffer, database, prettyPrint);
            this.appendStogroup(buffer, database, prettyPrint);
            this.appendCcsid(buffer, database, prettyPrint);
            SSBDataBaseDB2v70.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementCreateDatabase();
        }
    }

    protected void appendBufferPool(StringBuffer buffer, DataBaseDB2 dataBase, boolean prettyPrint) {
        BufferPoolDB2 bufferPool = dataBase.getBufferPool();
        if (bufferPool != null) {
            SSBDataBaseDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseDB2v70.appendStringWithSpace(buffer, "BUFFERPOOL");
            SSBDataBaseDB2v70.appendString(buffer, this.storageDesign.getFormatedName(bufferPool.getName()));
        }
    }

    protected void appendIndexBufferPool(StringBuffer buffer, DataBaseDB2 dataBase, boolean prettyPrint) {
        BufferPoolDB2 indexBufferPool = dataBase.getIndexBufferPool();
        if (indexBufferPool != null) {
            SSBDataBaseDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseDB2v70.appendStringWithSpace(buffer, INDEX_BP);
            SSBDataBaseDB2v70.appendString(buffer, this.storageDesign.getFormatedName(indexBufferPool.getName()));
        }
    }

    protected void appendType(StringBuffer buffer, DataBaseDB2 dataBase, boolean prettyPrint) {
        if (!dataBase.getType().equalsIgnoreCase("USUAL")) {
            SSBDataBaseDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseDB2v70.appendStringWithSpace(buffer, "AS");
            SSBDataBaseDB2v70.appendStringWithSpace(buffer, dataBase.getType());
            if (!dataBase.getMember().trim().equalsIgnoreCase("")) {
                SSBDataBaseDB2v70.appendStringWithSpace(buffer, "FOR");
                SSBDataBaseDB2v70.appendString(buffer, dataBase.getMember());
            }
        }
    }

    protected void appendStogroup(StringBuffer buffer, DataBaseDB2 dataBase, boolean prettyPrint) {
        StorageGroupDB2 stogroup = dataBase.getStorageGroup();
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (stogroup != null) {
                SSBDataBaseDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBDataBaseDB2v70.appendStringWithSpace(buffer, "STOGROUP");
                SSBDataBaseDB2v70.appendString(buffer, this.storageDesign.getFormatedName(stogroup.getName()));
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBDataBaseDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBDataBaseDB2v70.appendStringWithSpace(buffer, "STOGROUP");
                SSBDataBaseDB2v70.appendString(buffer, "SYSDEFLT");
            }
        }
    }

    protected void appendCcsid(StringBuffer buffer, DataBaseDB2 dataBase, boolean prettyPrint) {
        String type = dataBase.getType();
        if (!(type.equalsIgnoreCase("WORKFILE") || type.equalsIgnoreCase("TEMP") || "".equalsIgnoreCase(dataBase.getCcsid()))) {
            SSBDataBaseDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseDB2v70.appendStringWithSpace(buffer, "CCSID");
            SSBDataBaseDB2v70.appendString(buffer, dataBase.getCcsid());
        }
    }
}

