/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBStorageGroupDB2v70
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof StorageGroupDB2 && ((StorageGroupDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        StorageGroupDB2 storageGroup = (StorageGroupDB2)object;
        if (!storageGroup.isNullInstance()) {
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(storageGroup);
            if (storageGroup.getVolumes() == null || "".equalsIgnoreCase(storageGroup.getVolumes().trim())) {
                SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("-- Warning - STOGROUP ");
                buffer.append(this.storageDesign.getFormatedName(storageGroup.getName()));
                buffer.append(" has no volumes");
                SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("-- Volumes are set to SMS managed ('*')");
                SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("-- If the database is not SMS Managed");
                SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("-- the volumes will not be accepted");
                SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 0);
                this.appendComment(buffer, storageGroup);
                this.appendCreate(buffer);
                SSBStorageGroupDB2v70.appendStringWithSpace(buffer, "STOGROUP");
                SSBStorageGroupDB2v70.appendString(buffer, this.storageDesign.getFormatedName(storageGroup.getLongNameDDL()));
                this.appendVolumes(buffer, "'*'", prettyPrint);
                this.appendVCat(buffer, storageGroup, prettyPrint);
                SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                DDLFileMaker.incrementCreateStoGroup();
                DDLFileMaker.incrementWarnings();
            } else {
                this.appendComment(buffer, storageGroup);
                this.appendCreate(buffer);
                SSBStorageGroupDB2v70.appendStringWithSpace(buffer, "STOGROUP");
                SSBStorageGroupDB2v70.appendString(buffer, this.storageDesign.getFormatedName(storageGroup.getLongNameDDL()));
                this.appendVolumes(buffer, storageGroup, prettyPrint);
                this.appendVCat(buffer, storageGroup, prettyPrint);
                SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                DDLFileMaker.incrementCreateStoGroup();
                this.appendUsePrivileges(buffer, storageGroup, prettyPrint);
            }
        }
    }

    private void appendVolumes(StringBuffer buffer, StorageGroupDB2 storageGroup, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(storageGroup.getVolumes())) {
            SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBStorageGroupDB2v70.appendStringWithSpace(buffer, "VOLUMES");
            SSBStorageGroupDB2v70.appendStringWithSpace(buffer, '(');
            if (storageGroup.isSMSManaged()) {
                SSBStorageGroupDB2v70.appendStringWithSpace(buffer, storageGroup.getAsteriskVolumes());
            } else {
                SSBStorageGroupDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(storageGroup.getVolumesNames()));
            }
            SSBStorageGroupDB2v70.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendVolumes(StringBuffer buffer, String volumes, boolean prettyPrint) {
        SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 1);
        SSBStorageGroupDB2v70.appendStringWithSpace(buffer, "VOLUMES");
        SSBStorageGroupDB2v70.appendStringWithSpace(buffer, '(');
        SSBStorageGroupDB2v70.appendStringWithSpace(buffer, volumes);
        SSBStorageGroupDB2v70.appendStringWithSpace(buffer, ')');
    }

    private void appendVCat(StringBuffer buffer, StorageGroupDB2 storageGroup, boolean prettyPrint) {
        if (storageGroup.getVCat() != null) {
            SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBStorageGroupDB2v70.appendStringWithSpace(buffer, "VCAT");
            this.appendString(buffer, storageGroup.getVCat());
        }
    }

    private void appendUsePrivileges(StringBuffer buffer, StorageGroupDB2 storageGroup, boolean prettyPrint) {
        if (!storageGroup.getUsers().equalsIgnoreCase("")) {
            SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 0);
            SSBStorageGroupDB2v70.appendStringWithSpace(buffer, "GRANT");
            SSBStorageGroupDB2v70.appendStringWithSpace(buffer, "USE");
            SSBStorageGroupDB2v70.appendStringWithSpace(buffer, "OF");
            SSBStorageGroupDB2v70.appendStringWithSpace(buffer, "STOGROUP");
            SSBStorageGroupDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(storageGroup.getName()));
            SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBStorageGroupDB2v70.appendStringWithSpace(buffer, "TO");
            SSBStorageGroupDB2v70.appendStringWithSpace(buffer, storageGroup.getUserNames());
            if ("YES".equalsIgnoreCase(storageGroup.getGrantOption())) {
                SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBStorageGroupDB2v70.appendStringWithSpace(buffer, "WITH GRANT OPTION");
            }
            SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBStorageGroupDB2v70.appendNewLine(buffer, prettyPrint, 0);
        }
    }
}

