/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSpaceDB2v70
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;
    private static final String DSSIZE = "DSSIZE";
    private static final String SEGSIZE = "SEGSIZE";
    private static final String NUMPARTS = "NUMPARTS";
    private static final String LOCKSIZE = "LOCKSIZE";
    private static final String LOCKMAX = "LOCKMAX";
    private static final String LOCKPART = "LOCKPART";
    private static final String MAXROWS = "MAXROWS";

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableSpaceDB2 && ((TableSpaceDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableSpaceDB2 tableSpace = (TableSpaceDB2)object;
        if (!tableSpace.isNullInstance() && tableSpace != null) {
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(tableSpace);
            this.appendComment(buffer, tableSpace);
            this.appendCreate(buffer);
            this.appendLob(buffer, tableSpace);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "TABLESPACE");
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace.getLongNameDDL()));
            this.appendDataBase(buffer, tableSpace, prettyPrint);
            this.appendUsingBlock(buffer, tableSpace.getStorageTemplate(), prettyPrint);
            this.appendFreeBlock(buffer, tableSpace.getStorageTemplate(), tableSpace, prettyPrint);
            this.appendGbpCacheBlock(buffer, tableSpace.getStorageTemplate(), prettyPrint);
            this.appendTrackMod(buffer, tableSpace.getStorageTemplate(), prettyPrint);
            this.appendLog(buffer, tableSpace, prettyPrint);
            this.appendDefine(buffer, tableSpace.getStorageTemplate(), prettyPrint);
            this.appendDSSize(buffer, tableSpace, prettyPrint);
            this.appendClusterOptions(buffer, tableSpace, prettyPrint);
            this.appendBufferPool(buffer, tableSpace, prettyPrint);
            this.appendLockSize(buffer, tableSpace, prettyPrint);
            this.appendLockMax(buffer, tableSpace, prettyPrint);
            this.appendClose(buffer, tableSpace, prettyPrint);
            this.appendCompress(buffer, tableSpace, prettyPrint);
            this.appendCcsid(buffer, tableSpace, prettyPrint);
            this.appendLockPart(buffer, tableSpace, prettyPrint);
            this.appendMaxRows(buffer, tableSpace, prettyPrint);
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementCreateTablespace();
            this.appendUsePrivileges(buffer, tableSpace, prettyPrint);
        }
    }

    protected void appendLob(StringBuffer buffer, TableSpaceDB2 tableSpace) {
        if (tableSpace.getType().equalsIgnoreCase("LOB")) {
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "LOB");
        }
    }

    protected void appendDataBase(StringBuffer buffer, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        DataBaseDB2 dataBase = tableSpace.getDataBase();
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (dataBase != null) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "IN");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(dataBase.getLongNameDDL()));
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "IN");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "DSNDB04");
            }
        }
    }

    protected void appendUsingBlock(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            VCatDB2 vcat = st.getVCat();
            if (vcat != null) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "USING");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "VCAT");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(vcat.getName()));
            } else {
                StorageGroupDB2 stogroup = st.getStorageGroup();
                if (stogroup != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                    SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "USING");
                    SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "STOGROUP");
                    SSBTableSpaceDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(stogroup.getLongNameDDL()));
                    SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                    if (st.getSgPriqty() > 0) {
                        SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "PRIQTY");
                        this.appendStringWithSpace(buffer, st.getSgPriqty());
                        SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                    }
                    if (st.getSgSeqty() > 0) {
                        SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "SECQTY");
                        this.appendStringWithSpace(buffer, st.getSgSeqty());
                        SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                    }
                    SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "ERASE");
                    SSBTableSpaceDB2v70.appendStringWithSpace(buffer, st.isSgErase() ? "YES" : "NO");
                }
            }
        }
    }

    protected void appendFreeBlock(StringBuffer buffer, StorageTemplateDB2 st, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "FREEPAGE");
            this.appendStringWithSpace(buffer, st.getFreePage());
            String type = tableSpace.getType();
            if (!type.equalsIgnoreCase("LOB")) {
                DataBaseDB2 db = tableSpace.getDataBase();
                if (db == null) {
                    SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "PCTFREE");
                    this.appendStringWithSpace(buffer, st.getPctFree());
                } else {
                    String dbtype = db.getType();
                    if (!dbtype.equalsIgnoreCase("WORKFILE") && !dbtype.equalsIgnoreCase("TEMP")) {
                        SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                        SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "PCTFREE");
                        this.appendStringWithSpace(buffer, st.getPctFree());
                    }
                }
            }
        }
    }

    protected void appendGbpCacheBlock(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (!st.getGbCache().equalsIgnoreCase("") && !st.getGbCache().equalsIgnoreCase("CHANGED")) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "GBPCACHE");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, st.getGbCache());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "GBPCACHE");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "CHANGED");
            }
        }
    }

    protected void appendTrackMod(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (!st.isTrackMode()) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "TRACKMOD");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "NO");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "TRACKMOD");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "YES");
            }
        }
    }

    protected void appendLog(StringBuffer buffer, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        if (tableSpace.getType().equalsIgnoreCase("LOB") && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
            if (!tableSpace.isLobLogging()) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "LOG");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "NO");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "LOG");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "YES");
            }
        }
    }

    protected void appendDefine(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (!st.isDefine()) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "DEFINE");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "NO");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "DEFINE");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "YES");
            }
        }
    }

    protected void appendDSSize(StringBuffer buffer, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        if (!tableSpace.getDsSize().equalsIgnoreCase("")) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, DSSIZE);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, tableSpace.getDsSize());
        }
    }

    protected void appendClusterOptions(StringBuffer buffer, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        if (tableSpace.getType().equalsIgnoreCase("PARTITIONED")) {
            this.appendPartitions(buffer, tableSpace, prettyPrint);
        } else if (Integer.parseInt(tableSpace.getSegSize()) > 0) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, SEGSIZE);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, tableSpace.getSegSize());
        }
        if ("YES".equalsIgnoreCase(tableSpace.getClustered())) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "MEMBER");
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "CLUSTER");
        }
    }

    protected void appendPartitions(StringBuffer buffer, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        PartitionDB2[] partitions = tableSpace.getPartitions();
        if (partitions.length > 0) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, NUMPARTS);
            this.appendStringWithSpace(buffer, partitions.length);
            if (partitions.length > 0) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, '(');
                for (int i = 0; i < partitions.length; ++i) {
                    PartitionDB2 partition = partitions[i];
                    SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "PART");
                    this.appendStringWithSpace(buffer, partition.getPartNumber());
                    this.appendUsingBlock(buffer, partition.getStorageTemplate(), prettyPrint);
                    this.appendFreeBlock(buffer, partition.getStorageTemplate(), tableSpace, prettyPrint);
                    this.appendGbpCacheBlock(buffer, partition.getStorageTemplate(), prettyPrint);
                    this.appendTrackMod(buffer, partition.getStorageTemplate(), prettyPrint);
                    this.appendPartitionCompress(buffer, partition, prettyPrint);
                    if (i >= partitions.length - 1) continue;
                    this.appendComma(buffer);
                }
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendPartitionCompress(StringBuffer buffer, PartitionDB2 partition, boolean prettyPrint) {
        if (partition != null) {
            if (partition.isCompress()) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "COMPRESS");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "YES");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "COMPRESS");
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "NO");
            }
        }
    }

    protected void appendBufferPool(StringBuffer buffer, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        BufferPoolDB2 bufferPool = tableSpace.getBufferPool();
        if (bufferPool != null) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "BUFFERPOOL");
            this.appendStringWithSpace(buffer, tableSpace.getBufferPool());
        }
    }

    protected void appendLockSize(StringBuffer buffer, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, LOCKSIZE);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, tableSpace.getLockSize());
        }
    }

    protected void appendLockMax(StringBuffer buffer, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            int lockMax = tableSpace.getLockMax();
            String locksize = tableSpace.getLockSize();
            if ("ANY".equalsIgnoreCase(locksize)) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, LOCKMAX);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "SYSTEM");
            } else if ("PAGE".equalsIgnoreCase(locksize) || "ROW".equalsIgnoreCase(locksize) || "LOB".equalsIgnoreCase(locksize)) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, LOCKMAX);
                if (lockMax == -1) {
                    SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "SYSTEM");
                } else {
                    this.appendStringWithSpace(buffer, lockMax);
                }
            }
        }
    }

    protected void appendClose(StringBuffer buffer, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        if (!tableSpace.isClose()) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "CLOSE");
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "NO");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "CLOSE");
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "YES");
        }
    }

    protected void appendCompress(StringBuffer buffer, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        if (tableSpace.isCompress()) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "COMPRESS");
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "YES");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 2);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "COMPRESS");
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "NO");
        }
    }

    protected void appendCcsid(StringBuffer buffer, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        if (!tableSpace.getCcsid().equalsIgnoreCase("")) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "CCSID");
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, tableSpace.getCcsid());
        }
    }

    protected void appendLockPart(StringBuffer buffer, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        if (!tableSpace.isLockPart()) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, LOCKPART);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, tableSpace.isLockPart() ? "YES" : "NO");
        }
    }

    protected void appendMaxRows(StringBuffer buffer, TableSpaceDB2 tableSpace, boolean prettyPrint) {
        if (!tableSpace.getType().equalsIgnoreCase("LOB")) {
            DataBaseDB2 db2 = tableSpace.getDataBase();
            if (db2 != null) {
                if (!db2.getType().equalsIgnoreCase("WORKFILE")) {
                    if (tableSpace.getMaxRows() > 0 && tableSpace.getMaxRows() != 255) {
                        SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableSpaceDB2v70.appendStringWithSpace(buffer, MAXROWS);
                        this.appendStringWithSpace(buffer, tableSpace.getMaxRows());
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableSpaceDB2v70.appendStringWithSpace(buffer, MAXROWS);
                        SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "255");
                    }
                }
            } else if (tableSpace.getMaxRows() > 0 && tableSpace.getMaxRows() != 255) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, MAXROWS);
                this.appendStringWithSpace(buffer, tableSpace.getMaxRows());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, MAXROWS);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "255");
            }
        }
    }

    private void appendUsePrivileges(StringBuffer buffer, TableSpaceDB2 ts, boolean prettyPrint) {
        if (!ts.getUsers().equalsIgnoreCase("")) {
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "GRANT");
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "USE");
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "OF");
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "TABLESPACE");
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts.getName()));
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "TO");
            if (!ts.getUsers().equalsIgnoreCase("")) {
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, ts.getUsers());
            }
            if ("YES".equalsIgnoreCase(ts.getGrantOption())) {
                SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceDB2v70.appendStringWithSpace(buffer, "WITH GRANT OPTION");
            }
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBTableSpaceDB2v70.appendNewLine(buffer, prettyPrint, 0);
        }
    }
}

