/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.exports.ddl.db2.v80.SSBIndexDB2v80;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeDB2;
import oracle.dbtools.crest.model.design.storage.db2.InstanceDescriptorColumnDB2;
import oracle.dbtools.crest.model.design.storage.db2.TablePartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnIdentityDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableDB2v80
extends AbstractSSBDB2 {
    private StorageDesignDB2v80 storageDesign;
    private SSBIndexDB2v80 ssbIndex = new SSBIndexDB2v80();
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxy;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        Table table = null;
        TableProxyDB2v80 tableProxy = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            table = (Table)object;
            this.storageDesign = (StorageDesignDB2v80)this.getStorageDesign(object);
            tableProxy = (TableProxyDB2v80)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxyDB2v80) {
            tableProxy = (TableProxyDB2v80)object;
            table = (Table)tableProxy.getObject();
            this.storageDesign = (StorageDesignDB2v80)this.getStorageDesign(object);
        }
        if (tableProxy != null && !tableProxy.isMarkedGenerate()) {
            this.appendIndexes(buffer, tableProxy, prettyPrint);
            return;
        }
        if (table != null && table.getElementsCollection().size() > 0) {
            if (tableProxy != null) {
                this.appendSetCurrentRules(buffer, tableProxy, prettyPrint);
            }
            if (tableProxy != null && tableProxy.isCommentChanged()) {
                this.appendComment(buffer, tableProxy);
            } else {
                this.appendComment(buffer, table);
            }
            if (tableProxy != null && tableProxy.getName().length() > tableProxy.getMaxNameLength()) {
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                SSBTableDB2v80.appendStringWithSpace(buffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
            this.appendBeforeCreateScript(buffer, prettyPrint, table);
            this.appendCreate(buffer);
            if (tableProxy == null) {
                SSBTableDB2v80.appendStringWithSpace(buffer, "TABLE");
                SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(table));
                this.appendElementList(buffer, table, null, prettyPrint);
            } else {
                SSBTableDB2v80.appendStringWithSpace(buffer, "TABLE");
                String tableName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
                SSBTableDB2v80.appendStringWithSpace(buffer, tableName);
                this.appendElementList(buffer, table, tableProxy, prettyPrint);
                this.appendInDb(buffer, tableProxy, prettyPrint);
                this.appendPartitioningClause(buffer, tableProxy, prettyPrint);
                this.appendEditProc(buffer, tableProxy, prettyPrint);
                this.appendValidProc(buffer, tableProxy, prettyPrint);
                this.appendAudit(buffer, tableProxy, prettyPrint);
                this.appendObid(buffer, tableProxy, prettyPrint);
                this.appendDataCapture(buffer, tableProxy, prettyPrint);
                this.appendWithRestrict(buffer, tableProxy, prettyPrint);
                this.appendCcid(buffer, tableProxy, prettyPrint);
                this.appendVolatile(buffer, tableProxy, prettyPrint);
            }
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementCreateTable();
            this.appendAfterCreateScript(buffer, prettyPrint, table);
            if (tableProxy != null) {
                this.appendLabelOn(buffer, tableProxy, prettyPrint);
                ColumnProxy[] columns = tableProxy.getColumnProxies();
                for (int i = 0; i < columns.length; ++i) {
                    this.appendLabelOnColumn(buffer, (ColumnProxyDB2v80)columns[i], prettyPrint);
                }
            }
            this.appendColumnCheckConstraints(buffer, tableProxy, prettyPrint);
            this.appendTableCheckConstraints(buffer, tableProxy, prettyPrint);
            SSBTableDB2v80.appendExistenceDependencyConstraints(buffer, tableProxy, prettyPrint, this, String.valueOf(DB2_UDB_STATEMENT_TERMINATION_CHAR), 128);
            SSBTableDB2v80.appendOptionalFKCheckConstraints(buffer, tableProxy, prettyPrint, this, String.valueOf(';'), 30);
            if (this.getArcConstrHandler() != null) {
                this.getArcConstrHandler().appendArcConstraints(buffer, tableProxy, prettyPrint);
            }
            if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendTableCommentOn(buffer, table, tableProxy, prettyPrint);
            }
            if (tableProxy != null) {
                this.appendIndexes(buffer, tableProxy, prettyPrint);
            }
        } else if (table != null) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("-- Error - Table ");
            buffer.append(this.storageDesign.getFormatedName(table));
            buffer.append(" has no columns");
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendIndexes(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        Iterator it = tableProxy.getIndexes().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (!this.ssbIndex.canHandle(object)) continue;
            this.ssbIndex.doAppend(buffer, object, prettyPrint);
        }
        this.appendIndexesForConstraints(buffer, (Table)tableProxy.getObject(), tableProxy);
    }

    protected void appendTableCommentOn(StringBuffer buffer, Table table, TableProxyDB2v80 tableProxy, boolean prettyPrint) {
        block6: {
            block5: {
                if (tableProxy == null) break block5;
                this.appendCommentOn(buffer, tableProxy, prettyPrint);
                ColumnProxy[] columnProxies = tableProxy.getColumnProxies();
                ColumnProxy col = null;
                for (int i = 0; i < columnProxies.length; ++i) {
                    String name;
                    col = columnProxies[i];
                    String comment = "";
                    if (col.getCommentInRDBMS() != null && col.isCommentInRDBMSChanged()) {
                        comment = col.getCommentInRDBMS();
                        name = col.getLongName();
                    } else {
                        comment = col.getObject().getCommentInRDBMS();
                        name = ((Column)col.getObject()).getLongName();
                    }
                    if (comment.equalsIgnoreCase("")) continue;
                    SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableDB2v80.appendStringWithSpace(buffer, "COMMENT ON");
                    SSBTableDB2v80.appendStringWithSpace(buffer, "COLUMN");
                    SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(name));
                    SSBTableDB2v80.appendStringWithSpace(buffer, "IS");
                    SSBTableDB2v80.appendString(buffer, '\'');
                    SSBTableDB2v80.appendString(buffer, comment);
                    SSBTableDB2v80.appendStringWithSpace(buffer, '\'');
                    SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                }
                break block6;
            }
            if (table == null) break block6;
            if (table.getCommentInRDBMS() != null && !"".equalsIgnoreCase(table.getCommentInRDBMS())) {
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                SSBTableDB2v80.appendStringWithSpace(buffer, "COMMENT ON");
                SSBTableDB2v80.appendStringWithSpace(buffer, "TABLE");
                SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(table));
                SSBTableDB2v80.appendStringWithSpace(buffer, "IS");
                SSBTableDB2v80.appendString(buffer, '\'');
                SSBTableDB2v80.appendString(buffer, table.getCommentInRDBMS());
                SSBTableDB2v80.appendStringWithSpace(buffer, '\'');
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
            }
            ContainedObject[] columns = table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                Column col = (Column)columns[i];
                if (col.getCommentInRDBMS() == null || "".equalsIgnoreCase(col.getCommentInRDBMS())) continue;
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                SSBTableDB2v80.appendStringWithSpace(buffer, "COMMENT ON");
                SSBTableDB2v80.appendStringWithSpace(buffer, "COLUMN");
                SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(col.getLongName()));
                SSBTableDB2v80.appendStringWithSpace(buffer, "IS");
                SSBTableDB2v80.appendString(buffer, '\'');
                SSBTableDB2v80.appendString(buffer, col.getCommentInRDBMS());
                SSBTableDB2v80.appendStringWithSpace(buffer, '\'');
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
            }
        }
    }

    private void appendSetCurrentRules(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        boolean hasAUXTable = this.hasAUXTables(tableProxy);
        SSBTableDB2v80.appendStringWithSpace(buffer, "SET CURRENT RULES");
        SSBTableDB2v80.appendStringWithSpace(buffer, '=');
        SSBTableDB2v80.appendString(buffer, '\'');
        SSBTableDB2v80.appendString(buffer, hasAUXTable ? "DB2" : "STD");
        SSBTableDB2v80.appendStringWithSpace(buffer, '\'');
        this.appendLineFinisher(buffer, prettyPrint);
    }

    private void appendElementList(StringBuffer buffer, Table table, TableProxyDB2v80 tableProxy, boolean prettyPrint) {
        List columns = table.getAllNestedElements();
        Column column = null;
        ColumnProxyDB2v80 columnProxy = null;
        Object[] instCols = null;
        if (tableProxy != null) {
            instCols = tableProxy.getInstDescriptorCols().toArray();
        }
        SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
        if (tableProxy == null || tableProxy.getMaterializedQuery().equalsIgnoreCase("NO")) {
            if (columns.size() == 0 && (instCols == null || instCols.length == 0)) {
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v80.appendStringWithSpace(buffer, "-- No columns");
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            } else {
                for (int i = 0; i < columns.size(); ++i) {
                    if (i == 0) {
                        SSBTableDB2v80.appendStringWithSpace(buffer, '(');
                    } else {
                        this.appendComma(buffer);
                    }
                    SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                    column = (Column)columns.get(i);
                    if (tableProxy == null) continue;
                    columnProxy = (ColumnProxyDB2v80)tableProxy.getColumnProxy(column.getObjectID());
                    if (columnProxy.getName().length() > columnProxy.getMaxNameLength()) {
                        SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                        SSBTableDB2v80.appendStringWithSpace(buffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxy.getMaxNameLength() + ")");
                        SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    if (columnProxy.isCommentChanged() && !"".equalsIgnoreCase(columnProxy.getComment())) {
                        this.appendComment(buffer, columnProxy);
                    } else if (!"".equalsIgnoreCase(columnProxy.getObject().getComment())) {
                        this.appendComment(buffer, columnProxy.getObject());
                    }
                    this.appendColumnDefinition(buffer, columnProxy, prettyPrint);
                }
                InstanceDescriptorColumnDB2 instCol = null;
                for (int i = 0; i < instCols.length; ++i) {
                    instCol = (InstanceDescriptorColumnDB2)instCols[i];
                    if (columns.size() == 0 && i == 0) {
                        SSBTableDB2v80.appendString(buffer, '(');
                    } else {
                        buffer.append(", ");
                    }
                    SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(instCol));
                    SSBTableDB2v80.appendStringWithSpace(buffer, instCol.getDataType());
                }
                this.appendPKDefinition(buffer, table, tableProxy, prettyPrint);
                this.appendTableConstraintsDefinition(buffer, table, prettyPrint);
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v80.appendStringWithSpace(buffer, ')');
            }
        } else {
            this.appendMaterializedQuery(buffer, table, tableProxy, prettyPrint);
        }
    }

    protected void appendColumnDefinition(StringBuffer buffer, ColumnProxyDB2v80 columnProxy, boolean prettyPrint) {
        SSBTableDB2v80.appendString(buffer, ' ');
        SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
        DistinctTypeDB2 distType = columnProxy.getDistinctType();
        if (distType != null) {
            this.appendStringWithSpace(buffer, distType);
        } else {
            String datatype = columnProxy.getDatatypeString();
            SSBTableDB2v80.appendStringWithSpace(buffer, datatype);
            if (datatype.equalsIgnoreCase("unknown")) {
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                SSBTableDB2v80.appendStringWithSpace(buffer, "--  ERROR: Datatype UNKNOWN is not allowed");
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 5);
                DDLFileMaker.incrementErrors();
            }
        }
        this.appendBitDataDefinition(buffer, columnProxy);
        this.appendNotNullDefinition(buffer, columnProxy);
        this.appendWithDefaultDefinition(buffer, columnProxy);
        this.appendIdentityDefinition(buffer, columnProxy, prettyPrint);
        this.appendColumnConstraints(buffer, columnProxy.getColumn(), columnProxy);
        this.appendFieldProcDefinition(buffer, columnProxy);
    }

    protected void appendLabelOnColumn(StringBuffer buffer, ColumnProxyDB2v80 columnProxy, boolean prettyPrint) {
        if (!columnProxy.getLabel().equalsIgnoreCase("")) {
            SSBTableDB2v80.appendStringWithSpace(buffer, "LABEL");
            SSBTableDB2v80.appendStringWithSpace(buffer, "ON");
            SSBTableDB2v80.appendStringWithSpace(buffer, "COLUMN");
            SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getLongName()));
            SSBTableDB2v80.appendStringWithSpace(buffer, "IS");
            SSBTableDB2v80.appendStringWithSpace(buffer, "'" + columnProxy.getLabel() + "'");
            this.appendLineFinisher(buffer, prettyPrint);
        }
    }

    protected void appendBitDataDefinition(StringBuffer buffer, ColumnProxyDB2v80 columnProxy) {
        String bitdata = columnProxy.getBitData();
        if (!"".equalsIgnoreCase(bitdata)) {
            SSBTableDB2v80.appendStringWithSpace(buffer, "FOR");
            SSBTableDB2v80.appendStringWithSpace(buffer, bitdata);
            SSBTableDB2v80.appendStringWithSpace(buffer, "DATA");
        }
    }

    protected void appendNotNullDefinition(StringBuffer buffer, ColumnProxyDB2v80 columnProxy) {
        if (!columnProxy.getColumn().getNullsAllowed()) {
            SSBTableDB2v80.appendStringWithSpace(buffer, "NOT NULL");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableDB2v80.appendStringWithSpace(buffer, "NULL");
        }
    }

    private void appendWithDefaultDefinition(StringBuffer buffer, ColumnProxyDB2v80 columnProxy) {
        String defaultConstant = columnProxy.getDefaultValueConstant();
        boolean isSDOpen = columnProxy.getStorageDesign().isOpen();
        String defaultValue = "";
        Column column = columnProxy.getColumn();
        boolean isDefault = columnProxy.getDefault();
        if (!isSDOpen) {
            defaultValue = column.getDefaultValue();
            isDefault = column.getUsesDefaultValue();
        } else {
            defaultValue = columnProxy.getDefaultValue();
        }
        if (isDefault) {
            SSBTableDB2v80.appendStringWithSpace(buffer, "WITH");
            SSBTableDB2v80.appendStringWithSpace(buffer, "DEFAULT");
            if (!"".equalsIgnoreCase(defaultValue)) {
                if (defaultValue.equalsIgnoreCase(ColumnProxyDB2.getDefaultValueChoices()[1])) {
                    if (!"".equalsIgnoreCase(defaultConstant)) {
                        String dt = columnProxy.getColumn().getDatatypeString("DB2/390 8");
                        String df = this.addQuotesToDefault(dt, defaultConstant);
                        SSBTableDB2v80.appendStringWithSpace(buffer, df);
                    }
                } else if (defaultValue.equalsIgnoreCase(ColumnProxyDB2.getDefaultValueChoices()[4])) {
                    SSBTableDB2v80.appendStringWithSpace(buffer, defaultConstant);
                } else {
                    String dt = columnProxy.getColumn().getDatatypeString("DB2/390 8");
                    String df = this.addQuotesToDefault(dt, defaultValue);
                    SSBTableDB2v80.appendStringWithSpace(buffer, df);
                }
            }
        }
    }

    protected void appendIdentityDefinition(StringBuffer buffer, ColumnProxyDB2v80 columnProxy, boolean prettyPrint) {
        ColumnIdentityDB2v80 identity;
        Column column = columnProxy.getColumn();
        if (column.isIdentityColumn() && columnProxy.isUseIdentity() && (identity = (ColumnIdentityDB2v80)columnProxy.getColumnIdentity()) != null) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "GENERATED");
            SSBTableDB2v80.appendStringWithSpace(buffer, identity.getGenerate());
            SSBTableDB2v80.appendStringWithSpace(buffer, "AS");
            SSBTableDB2v80.appendStringWithSpace(buffer, "IDENTITY");
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 2);
            SSBTableDB2v80.appendStringWithSpace(buffer, '(');
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 2);
            SSBTableDB2v80.appendStringWithSpace(buffer, "START");
            SSBTableDB2v80.appendStringWithSpace(buffer, "WITH");
            SSBTableDB2v80.appendStringWithSpace(buffer, identity.getStartWith());
            this.appendComma(buffer);
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 2);
            SSBTableDB2v80.appendStringWithSpace(buffer, "INCREMENT");
            SSBTableDB2v80.appendStringWithSpace(buffer, "BY");
            this.appendStringWithSpace(buffer, identity.getIncrementBy());
            if (!"".equalsIgnoreCase(identity.getMinValue().trim())) {
                this.appendComma(buffer);
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBTableDB2v80.appendStringWithSpace(buffer, "MINVALUE");
                SSBTableDB2v80.appendStringWithSpace(buffer, identity.getMinValue());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                this.appendComma(buffer);
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBTableDB2v80.appendStringWithSpace(buffer, "NO");
                SSBTableDB2v80.appendStringWithSpace(buffer, "MINVALUE");
            }
            if (!"".equalsIgnoreCase(identity.getMaxValue().trim())) {
                this.appendComma(buffer);
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBTableDB2v80.appendStringWithSpace(buffer, "MAXVALUE");
                SSBTableDB2v80.appendStringWithSpace(buffer, identity.getMaxValue());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                this.appendComma(buffer);
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBTableDB2v80.appendStringWithSpace(buffer, "NO");
                SSBTableDB2v80.appendStringWithSpace(buffer, "MAXVALUE");
            }
            if (identity.isCycle()) {
                this.appendComma(buffer);
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBTableDB2v80.appendStringWithSpace(buffer, "CYCLE");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                this.appendComma(buffer);
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBTableDB2v80.appendStringWithSpace(buffer, "NO");
                SSBTableDB2v80.appendStringWithSpace(buffer, "CYCLE");
            }
            this.appendComma(buffer);
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 2);
            if (identity.getCache() == 0) {
                SSBTableDB2v80.appendStringWithSpace(buffer, "NO");
                SSBTableDB2v80.appendStringWithSpace(buffer, "CACHE");
            } else {
                SSBTableDB2v80.appendStringWithSpace(buffer, "CACHE");
                this.appendStringWithSpace(buffer, identity.getCache());
            }
            if (identity.getOrder().equalsIgnoreCase("YES")) {
                this.appendComma(buffer);
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBTableDB2v80.appendStringWithSpace(buffer, "ORDER");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                this.appendComma(buffer);
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBTableDB2v80.appendStringWithSpace(buffer, "NO");
                SSBTableDB2v80.appendStringWithSpace(buffer, "ORDER");
            }
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 2);
            SSBTableDB2v80.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendFieldProcDefinition(StringBuffer buffer, ColumnProxyDB2v80 columnProxy) {
        String program;
        if (!(columnProxy.getDefault() || (program = columnProxy.getProgram()) == null || program.trim().equals("") || program.trim().equalsIgnoreCase("NULL"))) {
            SSBTableDB2v80.appendStringWithSpace(buffer, "FIELDPROC");
            SSBTableDB2v80.appendStringWithSpace(buffer, program);
            String constant = columnProxy.getConstant();
            if (constant != null && !constant.trim().equals("") && !constant.trim().equalsIgnoreCase("NULL")) {
                SSBTableDB2v80.appendStringWithSpace(buffer, '(');
                SSBTableDB2v80.appendStringWithSpace(buffer, constant);
                SSBTableDB2v80.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendColumnConstraints(StringBuffer buffer, Column column, ColumnProxyDB2 columnProxy) {
        String text;
        if (column.hasConstraintsDefinedForDDL() && !"".equals(text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy)))) {
            String cname = column.getConstraintName();
            if (column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                if (!cname.equals("") && cname.length() <= 18) {
                    SSBTableDB2v80.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
                }
                SSBTableDB2v80.appendStringWithSpace(buffer, "CHECK");
                SSBTableDB2v80.appendStringWithSpace(buffer, '(');
                SSBTableDB2v80.appendStringWithSpace(buffer, text);
                SSBTableDB2v80.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendPKDefinition(StringBuffer buffer, Table table, TableProxyDB2 tableProxy, boolean prettyPrint) {
        Index[] indexes;
        int i;
        Column[] columns;
        KeyObject pk = table.getPK();
        if (pk != null && pk.isMarkedGenerate() && (columns = (Column[])pk.getElements()).length > 0) {
            this.appendComma(buffer);
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            if (tableProxy != null) {
                SSBTableDB2v80.appendString(buffer, ' ');
                SSBTableDB2v80.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                SSBTableDB2v80.appendStringWithSpace(buffer, "PRIMARY KEY");
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v80.appendString(buffer, '(');
                for (i = 0; i < columns.length; ++i) {
                    if (i != 0) {
                        this.appendComma(buffer);
                    }
                    SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableDB2v80.appendString(buffer, " " + this.storageDesign.getFormatedName(columns[i]));
                }
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v80.appendString(buffer, ')');
            }
        }
        if ((indexes = (Index[])table.getKeys()).length > 0) {
            for (i = 0; i < indexes.length; ++i) {
                Column[] indexColumns;
                Index index = indexes[i];
                if (!index.getIndexState().equalsIgnoreCase("Unique Constraint") || !index.isMarkedGenerate() || (indexColumns = (Column[])index.getElements()).length <= 0) continue;
                this.appendComma(buffer);
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v80.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index));
                SSBTableDB2v80.appendStringWithSpace(buffer, "UNIQUE");
                SSBTableDB2v80.appendString(buffer, '(');
                for (int j = 0; j < indexColumns.length; ++j) {
                    if (j != 0) {
                        this.appendComma(buffer);
                    }
                    buffer.append(this.storageDesign.getFormatedName(indexColumns[j]));
                }
                SSBTableDB2v80.appendString(buffer, ')');
            }
        }
    }

    private void appendTableConstraintsDefinition(StringBuffer buffer, Table table, boolean prettyPrint) {
        if (table.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
            for (TableLevelConstraint constraint : table.getCheckConstraints()) {
                this.appendComma(buffer);
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v80.appendString(buffer, ' ');
                SSBTableDB2v80.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(constraint));
                SSBTableDB2v80.appendStringWithSpace(buffer, "CHECK");
                SSBTableDB2v80.appendString(buffer, '(');
                SSBTableDB2v80.appendString(buffer, constraint.getRule());
                SSBTableDB2v80.appendString(buffer, ')');
            }
        }
    }

    private void appendMaterializedQuery(StringBuffer buffer, Table table, TableProxyDB2v80 tableProxy, boolean prettyPrint) {
        if (tableProxy != null) {
            Column[] columns = (Column[])table.getElements();
            Column column = null;
            ColumnProxyDB2v80 columnProxy = null;
            for (int i = 0; i < columns.length; ++i) {
                if (i == 0) {
                    SSBTableDB2v80.appendStringWithSpace(buffer, '(');
                } else {
                    this.appendComma(buffer);
                }
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                column = columns[i];
                columnProxy = (ColumnProxyDB2v80)tableProxy.getColumnProxy(column.getObjectID());
                SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            }
            if (columns.length > 0) {
                SSBTableDB2v80.appendStringWithSpace(buffer, ')');
            }
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "AS");
            SSBTableDB2v80.appendStringWithSpace(buffer, '(');
            SSBTableDB2v80.appendStringWithSpace(buffer, tableProxy.getMqQueryDefinition());
            SSBTableDB2v80.appendStringWithSpace(buffer, ')');
            if (tableProxy.getMqStatus().equalsIgnoreCase(TableProxyDB2v80.MQ_STATUS_STATES[1])) {
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v80.appendStringWithSpace(buffer, "WITH");
                SSBTableDB2v80.appendStringWithSpace(buffer, "NO");
                SSBTableDB2v80.appendStringWithSpace(buffer, "DATA");
                this.appendCopyOptions(buffer, tableProxy, prettyPrint);
            } else {
                this.appendRefreshableTableOptions(buffer, tableProxy, prettyPrint);
            }
        }
    }

    private void appendRefreshableTableOptions(StringBuffer buffer, TableProxyDB2v80 tableProxy, boolean prettyPrint) {
        SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
        SSBTableDB2v80.appendStringWithSpace(buffer, "DATA");
        SSBTableDB2v80.appendStringWithSpace(buffer, "INITIALLY");
        SSBTableDB2v80.appendStringWithSpace(buffer, "DEFERRED");
        SSBTableDB2v80.appendStringWithSpace(buffer, "DATA");
        SSBTableDB2v80.appendStringWithSpace(buffer, "REFRESH");
        SSBTableDB2v80.appendStringWithSpace(buffer, "DEFERRED");
        SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
        SSBTableDB2v80.appendStringWithSpace(buffer, "MAINTAINED");
        SSBTableDB2v80.appendStringWithSpace(buffer, tableProxy.getMqMaintenance());
        SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
        SSBTableDB2v80.appendStringWithSpace(buffer, tableProxy.getMqQueryOptimization());
        SSBTableDB2v80.appendStringWithSpace(buffer, "QUERY");
        SSBTableDB2v80.appendStringWithSpace(buffer, "OPTIMIZATION");
    }

    private void appendCopyOptions(StringBuffer buffer, TableProxyDB2v80 tableProxy, boolean prettyPrint) {
        if (tableProxy.getMqIdentityColumnAttr().equalsIgnoreCase(TableProxyDB2v80.MQ_IDENTITY_COLUMN_ATTR_STATES[0])) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "EXCLUDING");
        } else {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "INCLUDING");
        }
        SSBTableDB2v80.appendStringWithSpace(buffer, "IDENTITY");
    }

    private void appendInDb(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        DataBaseDB2 database = tableProxy.getDataBase();
        TableSpaceDB2 tableSpace = tableProxy.getTableSpace();
        if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "IN");
            if (database != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                SSBTableDB2v80.appendString(buffer, this.storageDesign.getFormatedName(database.getLongNameDDL()));
                SSBTableDB2v80.appendString(buffer, '.');
            }
            SSBTableDB2v80.appendString(buffer, this.storageDesign.getFormatedName(tableSpace.getLongNameDDL()));
        } else if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (database != null) {
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v80.appendStringWithSpace(buffer, "IN");
                SSBTableDB2v80.appendString(buffer, this.storageDesign.getFormatedName(database.getLongNameDDL()));
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v80.appendStringWithSpace(buffer, "IN");
                SSBTableDB2v80.appendStringWithSpace(buffer, "DSNDB04");
            }
        }
    }

    private void appendPartitioningClause(StringBuffer buffer, TableProxyDB2v80 tableProxy, boolean prettyPrint) {
        if (tableProxy.getPartitioned().equalsIgnoreCase("YES")) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "PARTITION");
            SSBTableDB2v80.appendStringWithSpace(buffer, "BY");
            SSBTableDB2v80.appendStringWithSpace(buffer, '(');
            StringTokenizer st = new StringTokenizer(tableProxy.getPartitioningKey().trim(), ",");
            while (st.hasMoreTokens()) {
                ColumnProxy column;
                String col = st.nextToken();
                String order = null;
                if (st.hasMoreTokens()) {
                    order = st.nextToken();
                }
                if ((column = tableProxy.getColumnProxy(col)) == null) continue;
                SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(column));
                if (order != null) {
                    SSBTableDB2v80.appendStringWithSpace(buffer, order);
                }
                if (!st.hasMoreTokens()) continue;
                this.appendComma(buffer);
            }
            SSBTableDB2v80.appendStringWithSpace(buffer, ')');
            this.appendPartitions(buffer, tableProxy, prettyPrint);
        }
    }

    protected void appendPartitions(StringBuffer buffer, TableProxyDB2v80 tableProxy, boolean prettyPrint) {
        SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
        SSBTableDB2v80.appendStringWithSpace(buffer, '(');
        TablePartitionDB2[] partitions = tableProxy.getPartitions();
        for (int i = 0; i < partitions.length; ++i) {
            TablePartitionDB2 partition = partitions[i];
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "PARTITION");
            this.appendStringWithSpace(buffer, partition.getPartNumber());
            SSBTableDB2v80.appendStringWithSpace(buffer, "ENDING");
            SSBTableDB2v80.appendStringWithSpace(buffer, '(');
            SSBTableDB2v80.appendStringWithSpace(buffer, partition.getPartConstants());
            SSBTableDB2v80.appendStringWithSpace(buffer, ')');
            if (i >= partitions.length - 1) continue;
            this.appendComma(buffer);
        }
        SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
        SSBTableDB2v80.appendStringWithSpace(buffer, ')');
    }

    private void appendEditProc(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (!tableProxy.getEditProc().equalsIgnoreCase("")) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "EDITPROC");
            SSBTableDB2v80.appendStringWithSpace(buffer, tableProxy.getEditProc());
        }
    }

    private void appendValidProc(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (!tableProxy.getValidProc().equalsIgnoreCase("")) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "VALIDPROC");
            SSBTableDB2v80.appendStringWithSpace(buffer, tableProxy.getValidProc());
        }
    }

    private void appendAudit(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (!tableProxy.getAudit().equalsIgnoreCase("NONE")) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "AUDIT");
            SSBTableDB2v80.appendStringWithSpace(buffer, tableProxy.getAudit());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "AUDIT");
            SSBTableDB2v80.appendStringWithSpace(buffer, "NONE");
        }
    }

    private void appendObid(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (tableProxy.getObid() > 0) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "OBID");
            this.appendStringWithSpace(buffer, tableProxy.getObid());
        }
    }

    private void appendDataCapture(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (tableProxy.getDataCapture()) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "DATA CAPTURE");
            if (tableProxy.getDataCapture()) {
                SSBTableDB2v80.appendStringWithSpace(buffer, "CHANGES");
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "DATA CAPTURE");
            SSBTableDB2v80.appendStringWithSpace(buffer, "NONE");
        }
    }

    private void appendWithRestrict(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (tableProxy.getDropRestrict()) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "WITH RESTRICT ON DROP");
        }
    }

    private void appendCcid(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (!tableProxy.getCcsid().equalsIgnoreCase("")) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "CCSID");
            SSBTableDB2v80.appendStringWithSpace(buffer, tableProxy.getCcsid());
        }
    }

    private void appendVolatile(StringBuffer buffer, TableProxyDB2v80 tableProxy, boolean prettyPrint) {
        if (tableProxy.getTableAccess().equalsIgnoreCase("YES")) {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "VOLATILE");
        } else {
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "NOT");
            SSBTableDB2v80.appendStringWithSpace(buffer, "VOLATILE");
        }
    }

    private void appendLabelOn(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (!tableProxy.getLabel().equalsIgnoreCase("")) {
            SSBTableDB2v80.appendStringWithSpace(buffer, "LABEL");
            SSBTableDB2v80.appendStringWithSpace(buffer, "ON");
            SSBTableDB2v80.appendStringWithSpace(buffer, "TABLE");
            SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            SSBTableDB2v80.appendStringWithSpace(buffer, "IS");
            SSBTableDB2v80.appendStringWithSpace(buffer, "'" + tableProxy.getLabel() + "'");
            this.appendLineFinisher(buffer, prettyPrint);
        }
    }

    private void appendColumnCheckConstraints(StringBuffer buffer, TableProxy tableProxy, boolean prettyPrint) {
        ColumnProxy[] colProxies = tableProxy.getColumnProxies();
        for (int i = 0; i < colProxies.length; ++i) {
            String text;
            ColumnProxy columnProxy = colProxies[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefinedForDDL() || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC() || "".equals(text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy)))) continue;
            String cname = column.getConstraintName();
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
            SSBTableDB2v80.appendStringWithSpace(buffer, "ALTER");
            SSBTableDB2v80.appendStringWithSpace(buffer, "TABLE");
            SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "ADD");
            if (!"".equals(text) && !"".equals(cname) && cname.length() <= 128) {
                SSBTableDB2v80.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
            }
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v80.appendStringWithSpace(buffer, "CHECK");
            SSBTableDB2v80.appendStringWithSpace(buffer, '(');
            SSBTableDB2v80.appendStringWithSpace(buffer, text);
            SSBTableDB2v80.appendStringWithSpace(buffer, ')');
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendTableCheckConstraints(StringBuffer buffer, TableProxy tableProxy, boolean prettyPrint) {
        Table table = (Table)tableProxy.getObject();
        if (!table.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
            for (TableLevelConstraint constraint : table.getCheckConstraints()) {
                String text = constraint.getRule();
                if ("".equals(text)) continue;
                String cname = constraint.getName();
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                SSBTableDB2v80.appendStringWithSpace(buffer, "ALTER");
                SSBTableDB2v80.appendStringWithSpace(buffer, "TABLE");
                SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v80.appendStringWithSpace(buffer, "ADD");
                if (!"".equals(cname) && cname.length() <= 128) {
                    SSBTableDB2v80.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
                }
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v80.appendStringWithSpace(buffer, "CHECK");
                SSBTableDB2v80.appendStringWithSpace(buffer, '(');
                SSBTableDB2v80.appendStringWithSpace(buffer, text);
                SSBTableDB2v80.appendStringWithSpace(buffer, ')');
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementAlterTable();
            }
        }
    }

    private boolean hasAUXTables(TableProxyDB2 tableProxy) {
        try {
            Iterator it = ((AbstractStorageDesignDB2)tableProxy.getStorageDesign()).getAUXTableSet().iterator();
            while (it.hasNext()) {
                AUXTableDB2 auxTable = (AUXTableDB2)it.next();
                if (!tableProxy.getName().trim().equalsIgnoreCase(auxTable.getTable().getName())) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void appendIndexesForConstraints(StringBuffer oldbuffer, Table table, TableProxy tableProxy) {
        KeyObject[] keys = table.getKeys();
        boolean genPK = table.getDesign().getDesignLevelSettings().isAutomaticPKGeneration();
        boolean genUK = table.getDesign().getDesignLevelSettings().isAutomaticUKGeneration();
        boolean genFK = table.getDesign().getDesignLevelSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keys.length; ++i) {
            Index ind;
            ContainedObject[] cols;
            Index index = (Index)keys[i];
            if (!(genPK && "Primary Constraint".equals(index.getIndexState()) || genUK && "Unique Constraint".equals(index.getIndexState())) && (!index.isFK() || !genFK) || (cols = index.getElements()).length <= 0 || (ind = this.getIndexForColumns(table, index, cols, false)) != null) continue;
            this.ssbIndex.appendIndexForConstraint(oldbuffer, index, tableProxy, true);
        }
    }

    private Index getIndexForColumns(Table table, Index index, ContainedObject[] cols, boolean ascending) {
        Object[] inds = table.getIndexes().toArray();
        for (int i = 0; i < inds.length; ++i) {
            DesignObjectPlaceHolder dph = (DesignObjectPlaceHolder)inds[i];
            Index ind = (Index)dph.getDesignObject();
            ContainedObject[] icols = ind.getElements();
            if (cols.length != icols.length) continue;
            boolean brflag = false;
            for (int j = 0; j < cols.length; ++j) {
                String so;
                if (cols[j] != icols[j]) {
                    brflag = true;
                    break;
                }
                if (!ascending || "ASC".equalsIgnoreCase(so = ind.getColumnSortOrder(icols[j]).trim()) || "".equalsIgnoreCase(so)) continue;
                brflag = true;
                break;
            }
            if (brflag || ind == index) continue;
            return ind;
        }
        return null;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }
}

