/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBArcFKOracle
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    public SSBArcFKOracle(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof FKArc;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        Table arcTable;
        FKArc arc = (FKArc)object;
        if (arc.isMarkedGenerate() && arc.isReverse() && arc.getDesign().getAppView().getSettings().isGenerateFKArcTriggers() && (arcTable = arc.getTable()) != null && arc.getFkeys().size() > 1) {
            for (FKIndexAssociation fkey : arc.getFkeys()) {
                Table fkeyTable = fkey.getTable();
                TableProxy fkeyTableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(fkeyTable.getObjectID());
                if (fkeyTableProxy == null || !fkeyTableProxy.isMarkedGenerate()) continue;
                this.appendComment(oldbuffer, arc);
                this.appendArcTrigger(oldbuffer, arc, fkey, fkeyTableProxy, true);
            }
        }
    }

    private void appendArcTrigger(StringBuffer oldbuffer, FKArc arc, FKIndexAssociation fkey, TableProxy tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String fkeyTableLongName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
        String advancedComment = "create Arc constraint trigger for table " + fkeyTableLongName;
        String trName = "ARC_" + arc.getName() + "_";
        trName = this.storageDesign.getFormatedName(trName + this.getStringWithMaxLength(tableProxy.getName(), 30 - trName.length()));
        if (tableProxy.getUserSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            trName = this.storageDesign.getFormatedName(tableProxy.getUserSchema()) + '.' + trName;
        }
        String trTab = this.storageDesign.getFormatedLongNameDDL(tableProxy);
        Column[] fkeyCols = fkey.getColumns();
        String trCols = "";
        boolean first = true;
        for (int i = 0; i < fkeyCols.length; ++i) {
            Column fkeyCol = fkeyCols[i];
            if (first) {
                trCols = this.storageDesign.getFormatedName(fkeyCol);
                first = false;
                continue;
            }
            trCols = trCols + ", " + this.storageDesign.getFormatedName(fkeyCol);
        }
        if (arc.getDiscriminatorColumn() != null) {
            String arcTab = this.storageDesign.getFormatedLongNameDDL(arc.getTable());
            ContainedObject[] arcCols = fkey.getKeyObject().getElements();
            String arcDColSize = arc.getDiscriminatorColumn().getSize();
            String fkeyName = this.storageDesign.getFormatedLongNameDDL(fkey);
            if (arc.getDiscriminatorColumn().equals(fkey.getDiscriminatorColumn())) {
                String fkeyDVal = fkey.getDiscriminatorValue();
                if (fkeyDVal != null && !fkeyDVal.equals("")) {
                    SSBArcFKOracle.appendStringWithSpace(buffer, "CREATE OR REPLACE TRIGGER " + trName);
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "BEFORE INSERT OR UPDATE OF " + trCols);
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "ON " + trTab);
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "FOR EACH ROW");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "DECLARE");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "d VARCHAR2(" + arcDColSize + ");");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "BEGIN");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "SELECT A." + this.storageDesign.getFormatedName(arc.getDiscriminatorColumn()) + " INTO d");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "FROM " + arcTab + " A, " + trTab + " B");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    for (int j = 0; j < arcCols.length; ++j) {
                        if (j == 0) {
                            SSBArcFKOracle.appendStringWithSpace(buffer, "WHERE");
                        } else {
                            SSBArcFKOracle.appendStringWithSpace(buffer, "AND");
                        }
                        SSBArcFKOracle.appendStringWithSpace(buffer, "A." + this.storageDesign.getFormatedName(arcCols[j]) + " = B." + this.storageDesign.getFormatedName(fkeyCols[j]));
                        SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    }
                    SSBArcFKOracle.appendStringWithSpace(buffer, ";");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "IF (d IS NULL OR d <> '" + fkeyDVal + "') THEN");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 2);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "raise_application_error(-20223,'FK " + fkeyName + " in Table " + trTab + " violates Arc constraint on Table " + arcTab + " - only one FK is permitted');");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "END IF;");
                    SSBArcFKOracle.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(buffer, "END;");
                    this.appendBlockDefinitionToBuffer(oldbuffer, buffer, advancedComment, "/");
                    SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementCreateTrigger();
                } else {
                    SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBArcFKOracle.appendStringWithSpace(oldbuffer, "--  ERROR: No Discriminator Value found for FK " + fkey.getName() + " - constraint trigger for Arc " + arc.getName() + " cannot be generated");
                    SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
            } else {
                SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBArcFKOracle.appendStringWithSpace(oldbuffer, "--  ERROR: Discriminator Column found in FK " + fkey.getName() + " not same as in Arc " + arc.getName() + " - constraint trigger for Arc cannot be generated");
                SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
        } else {
            SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBArcFKOracle.appendStringWithSpace(oldbuffer, "--  ERROR: No Discriminator Column found in Arc " + arc.getName() + " - constraint trigger for Arc cannot be generated");
            SSBArcFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }
}

