/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBArcFK_CheckConstr
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    public SSBArcFK_CheckConstr(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof FKArc;
    }

    public void appendArcConstraints(StringBuffer oldbuffer, TableProxy tp, boolean prettyPrint) {
        Table table = (Table)tp.getObject();
        if (table != null) {
            for (FKArc arc : table.getArcs()) {
                if (arc.isReverse() && !arc.isMandatory()) continue;
                this.doAppend(oldbuffer, arc, prettyPrint);
            }
        }
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        FKArc arc = (FKArc)object;
        if (arc.isMarkedGenerate() && arc.getDesign().getAppView().getSettings().isGenerateFKArcTriggers()) {
            TableProxy tableProxy;
            Table table = arc.getTable();
            List columns = this.getColumnsInArc(arc);
            if (table != null && arc.getFkeys().size() > 1 && columns.size() > 1 && (tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID())) != null && tableProxy.isMarkedGenerate()) {
                this.appendComment(oldbuffer, arc);
                StringBuffer buffer = new StringBuffer();
                String formatedLongName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
                String advancedComment = "create Arc check constraint for table " + formatedLongName;
                if (!arc.isReverse()) {
                    this.appendArcCheckCnstraint(buffer, arc, tableProxy, columns, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementAlterTable();
                } else {
                    this.appendReverseArcCheckCnstraints(oldbuffer, arc, tableProxy, prettyPrint);
                }
            }
        }
    }

    private List getColumnsInArc(FKArc arc) {
        ArrayList<Column> list = new ArrayList<Column>();
        for (FKIndexAssociation fk : arc.getFkeys()) {
            for (Column column : fk.getLocalFKIndex().getElementsCollection()) {
                list.add(column);
            }
        }
        return list;
    }

    private List getColumnsInArc(FKArc arc, FKIndexAssociation excludeFK) {
        ArrayList<Column> list = new ArrayList<Column>();
        for (FKIndexAssociation fk : arc.getFkeys()) {
            if (fk == excludeFK) continue;
            for (Column column : fk.getLocalFKIndex().getElementsCollection()) {
                list.add(column);
            }
        }
        return list;
    }

    private void appendArcCheckCnstraint(StringBuffer buffer, FKArc arc, TableProxy tableProxy, List columns, boolean prettyPrint) {
        String constr_name = this.storageDesign.getFormatedName(arc);
        List fkeys = arc.getFkeys();
        String tableName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
        SSBArcFK_CheckConstr.appendStringWithSpace(buffer, "ALTER TABLE " + tableName);
        SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 1);
        SSBArcFK_CheckConstr.appendStringWithSpace(buffer, "ADD CONSTRAINT " + constr_name + " CHECK (");
        SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 2);
        ArrayList<Column> allColumns = new ArrayList<Column>();
        for (int i = 0; i < fkeys.size(); ++i) {
            String colname;
            Column col;
            FKIndexAssociation fk = (FKIndexAssociation)fkeys.get(i);
            Column[] fkcols = fk.getColumns();
            List othercols = this.getColumnsInArc(arc, fk);
            SSBArcFK_CheckConstr.appendStringWithSpace(buffer, "(");
            if (i > 0) {
                // empty if block
            }
            for (int k = 0; k < fkcols.length; ++k) {
                col = fkcols[k];
                if (i == 0) {
                    allColumns.add(col);
                }
                colname = this.storageDesign.getFormatedName(col);
                SSBArcFK_CheckConstr.appendString(buffer, " (" + colname + " IS NOT NULL) AND ");
                SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 2);
            }
            if (i == 0) {
                allColumns.addAll(othercols);
            }
            for (int j = 0; j < othercols.size(); ++j) {
                col = (Column)othercols.get(j);
                colname = this.storageDesign.getFormatedName(col);
                SSBArcFK_CheckConstr.appendString(buffer, " (" + colname + " IS NULL) ");
                if (j >= othercols.size() - 1) continue;
                SSBArcFK_CheckConstr.appendString(buffer, " AND ");
                SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 2);
            }
            if (i >= fkeys.size() - 1) continue;
            SSBArcFK_CheckConstr.appendStringWithSpace(buffer, ") OR");
            SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 2);
        }
        if (!arc.isMandatory()) {
            SSBArcFK_CheckConstr.appendStringWithSpace(buffer, ") OR ");
            SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 2);
            SSBArcFK_CheckConstr.appendStringWithSpace(buffer, "(");
            for (int j = 0; j < allColumns.size(); ++j) {
                Column col = (Column)allColumns.get(j);
                String colname = this.storageDesign.getFormatedName(col);
                SSBArcFK_CheckConstr.appendString(buffer, " (" + colname + " IS NULL) ");
                if (j >= allColumns.size() - 1) continue;
                SSBArcFK_CheckConstr.appendString(buffer, " AND ");
                SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 2);
            }
        }
        SSBArcFK_CheckConstr.appendStringWithSpace(buffer, ") )");
    }

    private void appendReverseArcCheckCnstraints(StringBuffer oldbuffer, FKArc arc, TableProxy tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String constrName = this.storageDesign.getFormatedName(arc);
        String tableName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
        Column discrimCol = arc.getDiscriminatorColumn();
        String advancedComment = "create Arc check constraint for table " + tableName;
        if (discrimCol != null) {
            ColumnProxy discrimColProxy = tableProxy.getColumnProxy(discrimCol.getObjectID());
            if (discrimColProxy != null) {
                if (discrimCol.getValueList() != null && !discrimCol.getValueList().isEmpty()) {
                    Set dColVals = discrimCol.getValueList().getValues();
                    List fkeys = arc.getFkeys();
                    for (int i = 0; i < fkeys.size(); ++i) {
                        FKIndexAssociation fkey = (FKIndexAssociation)fkeys.get(i);
                        String fkeyDVal = fkey.getDiscriminatorValue();
                        if (fkeyDVal != null && !fkeyDVal.equals("")) {
                            if (dColVals.contains(fkeyDVal)) continue;
                            SSBArcFK_CheckConstr.appendNewLine(oldbuffer, prettyPrint, 0);
                            SSBArcFK_CheckConstr.appendStringWithSpace(oldbuffer, "--  ERROR: Discriminator Value '" + fkeyDVal + "' in FK " + fkey.getName() + "not found in LOV for Column " + discrimColProxy.getName() + " - check constraint for Arc " + arc.getName() + " cannot be generated");
                            SSBArcFK_CheckConstr.appendNewLine(oldbuffer, prettyPrint, 0);
                            DDLFileMaker.incrementErrors();
                            continue;
                        }
                        SSBArcFK_CheckConstr.appendNewLine(oldbuffer, prettyPrint, 0);
                        SSBArcFK_CheckConstr.appendStringWithSpace(oldbuffer, "--  ERROR: No Discriminator Value found in FK " + fkey.getName() + " - check constraint for Arc " + arc.getName() + " cannot be generated");
                        SSBArcFK_CheckConstr.appendNewLine(oldbuffer, prettyPrint, 0);
                        DDLFileMaker.incrementErrors();
                    }
                } else {
                    List dVals = this.getDiscriminatorValues(arc);
                    if (!dVals.isEmpty()) {
                        SSBArcFK_CheckConstr.appendStringWithSpace(buffer, "ALTER TABLE " + tableName);
                        SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 1);
                        SSBArcFK_CheckConstr.appendStringWithSpace(buffer, "ADD CONSTRAINT " + constrName + "_LOV" + " CHECK ( " + this.storageDesign.getFormatedName(discrimColProxy));
                        SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 1);
                        SSBArcFK_CheckConstr.appendStringWithSpace(buffer, "IN (");
                        for (int i = 0; i < dVals.size(); ++i) {
                            if (i > 0) {
                                SSBArcFK_CheckConstr.appendStringWithSpace(buffer, ",");
                            }
                            SSBArcFK_CheckConstr.appendString(buffer, "'" + (String)dVals.get(i) + "'");
                        }
                        SSBArcFK_CheckConstr.appendString(buffer, " ) )");
                        this.appendToBuffer(oldbuffer, buffer, advancedComment);
                        SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 0);
                        this.appendLineFinisher(buffer, prettyPrint);
                        this.appendToBuffer(oldbuffer, buffer, advancedComment);
                        DDLFileMaker.incrementAlterTable();
                    }
                }
                if (arc.isMandatory() && discrimCol.getNullsAllowed()) {
                    SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFK_CheckConstr.appendStringWithSpace(buffer, "ALTER TABLE " + tableName);
                    SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 1);
                    SSBArcFK_CheckConstr.appendStringWithSpace(buffer, "ADD CONSTRAINT " + constrName + "_NN" + " CHECK (");
                    SSBArcFK_CheckConstr.appendString(buffer, this.storageDesign.getFormatedName(discrimColProxy) + " IS NOT NULL )");
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    SSBArcFK_CheckConstr.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementAlterTable();
                }
            }
        } else {
            SSBArcFK_CheckConstr.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBArcFK_CheckConstr.appendStringWithSpace(oldbuffer, "--  ERROR: No Discriminator Column found in Arc " + arc.getName() + " - check constraint cannot be generated");
            SSBArcFK_CheckConstr.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private List getDiscriminatorValues(FKArc arc) {
        ArrayList<String> values = new ArrayList<String>();
        List fkeys = arc.getFkeys();
        for (int i = 0; i < fkeys.size(); ++i) {
            FKIndexAssociation fk = (FKIndexAssociation)fkeys.get(i);
            String val = fk.getDiscriminatorValue();
            if (val == null || val.equals("")) continue;
            values.add(val);
        }
        return values;
    }
}

