/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.ColumnProxyOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBAutoIncrementColumnOracle
extends AbstractSSBOracle {
    private static final int MAX_OBJECT_LENGTH = 30;
    private static final String TRIGGER_SUFFIX = "TRG";
    private static final String SEQUENCE_SUFFIX = "SEQ";
    private StorageDesignOracle storageDesign;
    private static Set genSequenceSet = new HashSet();

    public static void clearGenSequenceSet() {
        genSequenceSet.clear();
    }

    public SSBAutoIncrementColumnOracle(StorageDesignOracle storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableProxyOracle || object instanceof Table;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (object instanceof TableProxyOracle && ((TableProxyOracle)object).isMarkedGenerate() || object instanceof Table && ((Table)object).isMarkedGenerate()) {
            Table table = object instanceof Table ? (Table)object : (Table)((TableProxyOracle)object).getObject();
            for (Column column : table.getElementsCollection()) {
                if (!column.isAutoIncrementColumn()) continue;
                this.appendAutoIncrementSequenceAndTrigger(buffer, column, prettyPrint);
            }
        }
    }

    public void appendAutoIncrementSequenceAndTrigger(StringBuffer buffer, Column column, boolean prettyPrint) {
        this.appendAutoIncrementSequenceAndTrigger(buffer, column, prettyPrint, true);
    }

    public void appendAutoIncrementSequenceAndTrigger(StringBuffer buffer, Column column, boolean prettyPrint, boolean tableCreated) {
        String triggerName;
        boolean genTrigger = true;
        if (this.storageDesign instanceof StorageDesignOraclev12c) {
            ColumnProxyOraclev12c columnProxy = (ColumnProxyOraclev12c)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
            if (columnProxy != null) {
                String autoIncDDL = columnProxy.getDDLTypeForAutoIncCol();
                if (autoIncDDL.equalsIgnoreCase("NONE")) {
                    return;
                }
                if (autoIncDDL.equalsIgnoreCase("TRIGGER") && !tableCreated) {
                    return;
                }
                if (autoIncDDL.equalsIgnoreCase("DEFAULT_CLAUSE")) {
                    if (tableCreated) {
                        return;
                    }
                    genTrigger = false;
                }
                if (autoIncDDL.equalsIgnoreCase("IDENTITY_CLAUSE")) {
                    String dt;
                    if (!tableCreated) {
                        return;
                    }
                    if (column.isIdentityColumn() && (dt = column.getDatatypeString(this.storageDesign.getRDBMSType().getName())).toUpperCase().indexOf("CHAR") <= -1) {
                        return;
                    }
                }
            }
        } else if (!tableCreated) {
            return;
        }
        String sequenceName = this.generateSequenceName(buffer, column, prettyPrint);
        if (column.isAutoIncrementGenerateTrigger() && genTrigger && (!StringUtilities.isNotEmpty(triggerName = column.getAutoIncrementTriggerName()) || this.storageDesign.getTriggerSet().getByName(triggerName) == null)) {
            Settings settings = column.getDesign().getAppView().getSettings();
            triggerName = this.generateAutoIncrementObjectName(triggerName, settings.getDefaultOracleTriggerName(), TRIGGER_SUFFIX, column);
            this.appendAutoIncrementTrigger(triggerName, sequenceName, column, buffer, prettyPrint);
        }
    }

    public String generateSequenceName(StringBuffer buffer, Column column, boolean prettyPrint) {
        Settings settings = column.getDesign().getAppView().getSettings();
        String sequenceName = column.getAutoIncrementSequenceName();
        if (sequenceName != null) {
            sequenceName = sequenceName.trim();
        }
        String seqLongName = this.generateAutoIncrementObjectName(sequenceName, settings.getDefaultOracleSequenceName(), SEQUENCE_SUFFIX, column);
        SequenceOracle sequence = null;
        String userName = "";
        int dotIndex = seqLongName.indexOf(46);
        if (dotIndex == -1) {
            sequenceName = seqLongName;
        } else {
            sequenceName = seqLongName.substring(dotIndex + 1);
            userName = seqLongName.substring(0, dotIndex);
            sequence = (SequenceOracle)this.storageDesign.getSequenceSet().getByUserSchemaAndName(userName, sequenceName);
        }
        if (sequence == null) {
            sequence = (SequenceOracle)this.storageDesign.getSequenceSet().getByName(sequenceName);
        }
        if (sequence != null) {
            return this.storageDesign.getFormatedLongNameDDL(sequence);
        }
        if (buffer != null && !genSequenceSet.contains(seqLongName)) {
            this.appendAutoIncrementSequence(seqLongName, column, buffer, prettyPrint);
            genSequenceSet.add(seqLongName);
        }
        return this.storageDesign.getFormatedName(seqLongName);
    }

    private String generateAutoIncrementObjectName(String objectName, String objectNameTemplate, String suffix, Column column) {
        String result;
        String schema;
        String columnName;
        String tableName;
        Table table = (Table)column.getParent();
        ColumnProxyOracle columnProxy = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
        TableProxyOracle tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy == null || columnProxy == null) {
            tableName = table.getName();
            columnName = column.getName();
            schema = table.getSchema();
        } else {
            String tableLongName;
            int userNameLength;
            tableName = tableProxy.getName();
            columnName = columnProxy.getName();
            UserOracle autoIncUser = columnProxy.getAutoIncrementUser();
            schema = autoIncUser != null ? autoIncUser.getName() : ((userNameLength = (tableLongName = tableProxy.getLongName()).length() - tableName.length() - 1) > 0 ? tableLongName.substring(0, userNameLength) : "");
        }
        if (StringUtilities.isNotEmpty(objectName)) {
            result = objectName;
        } else {
            String columnAbbr;
            String tableAbbr = table.getAbbreviation();
            if (StringUtilities.isEmpty(tableAbbr)) {
                tableAbbr = tableName;
            }
            if (StringUtilities.isEmpty(columnAbbr = column.getAbbreviation())) {
                columnAbbr = columnName;
            }
            if (StringUtilities.isNotEmpty(objectNameTemplate)) {
                result = objectNameTemplate.replaceAll("\\{table\\}", tableName).replaceAll("\\{table abbr\\}", tableAbbr).replaceAll("\\{column\\}", columnName).replaceAll("\\{column abbr\\}", columnAbbr);
            } else {
                result = tableAbbr + '_' + columnAbbr;
                if (result.length() + suffix.length() + 1 <= 30) {
                    result = result + '_' + suffix;
                }
            }
        }
        result = this.getStringWithMaxLength(result, 30);
        if (StringUtilities.isNotEmpty(schema) && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            result = schema + '.' + result;
        }
        return result;
    }

    private void appendAutoIncrementSequence(String sequenceName, Column column, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String autoIncrementStartWith = column.getAutoIncrementStartWith();
        Integer autoIncrementIncrementBy = column.getAutoIncrementIncrementBy();
        String autoIncrementMaxValue = column.getAutoIncrementMaxValue();
        String autoIncrementMinValue = column.getAutoIncrementMinValue();
        Integer autoIncrementCache = column.getAutoIncrementCache();
        SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "CREATE");
        SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "SEQUENCE");
        SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sequenceName));
        String advancedComment = buffer.toString();
        if (autoIncrementStartWith != null && !"".equals(autoIncrementStartWith)) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "START");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "WITH");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, autoIncrementStartWith);
        }
        if (autoIncrementIncrementBy != null && autoIncrementIncrementBy != 1) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "INCREMENT");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "BY");
            this.appendStringWithSpace(buffer, autoIncrementIncrementBy);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "INCREMENT");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "BY");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "1");
        }
        if (autoIncrementMinValue != null) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "MINVALUE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, autoIncrementMinValue);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "NOMINVALUE");
        }
        if (autoIncrementMaxValue != null) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "MAXVALUE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, autoIncrementMaxValue);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "NOMAXVALUE");
        }
        if (column.isAutoIncrementCycle()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "CYCLE");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "NOCYCLE");
        }
        if (column.isAutoIncrementDisableCache()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "NOCACHE");
        } else if (autoIncrementCache != null) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "CACHE");
            this.appendStringWithSpace(buffer, autoIncrementCache);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "CACHE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "20");
        }
        if (column.isAutoIncrementOrder()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "ORDER");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "NOORDER");
        }
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBAutoIncrementColumnOracle.appendNewLine(oldbuffer, prettyPrint, 0);
        DDLFileMaker.incrementCreateSequence();
    }

    private void appendAutoIncrementTrigger(String triggerName, String sequenceName, Column column, StringBuffer oldbuffer, boolean prettyPrint) {
        ColumnProxyOracle columnProxy;
        Table table = (Table)column.getParent();
        TableProxyOracle tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null && (columnProxy = (ColumnProxyOracle)tableProxy.getColumnProxy(column.getObjectID())) != null) {
            StringBuffer buffer = new StringBuffer();
            String tableLongName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
            String columnName = this.storageDesign.getFormatedName(columnProxy);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "CREATE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "OR");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "REPLACE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "TRIGGER");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(triggerName));
            String advancedComment = buffer.toString();
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "BEFORE INSERT ON " + tableLongName);
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "FOR EACH ROW");
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 0);
            if (!column.isAutoIncrementGenerateAlways()) {
                SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "WHEN (NEW." + columnName + " IS NULL)");
                SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 0);
            }
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "BEGIN");
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            if (this.storageDesign instanceof StorageDesignOraclev11g) {
                SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, ":NEW." + columnName);
                SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, ":=");
                SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, sequenceName + ".NEXTVAL;");
            } else {
                SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "SELECT " + sequenceName + ".NEXTVAL INTO :NEW." + columnName + " FROM DUAL;");
            }
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnOracle.appendString(buffer, "END");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.appendLineFinisherWithSlash(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementCreateTrigger();
        }
    }
}

