/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ContextOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBContextOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        ContextOraclev10g context = (ContextOraclev10g)object;
        this.storageDesign = context.getStorageDesign();
        this.appendPrompt(buffer, context, "CONTEXT");
        this.appendComment(oldbuffer, context);
        this.appendCreateContext(buffer);
        this.appendNamespace(buffer, context);
        advancedComment = buffer.toString();
        this.appendPackage(buffer, context, prettyPrint);
        this.appendOpitons(buffer, context, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBContextOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateContext();
    }

    private void appendCreateContext(StringBuffer buffer) {
        this.appendCreateOrReplace(buffer);
        SSBContextOraclev10g.appendStringWithSpace(buffer, "CONTEXT");
    }

    private void appendNamespace(StringBuffer buffer, ContextOraclev10g context) {
        SSBContextOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(context));
    }

    private void appendPackage(StringBuffer buffer, ContextOraclev10g context, boolean prettyPrint) {
        SSBContextOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBContextOraclev10g.appendStringWithSpace(buffer, "USING");
        SSBContextOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(context.getPackage()));
    }

    private void appendOpitons(StringBuffer buffer, ContextOraclev10g context, boolean prettyPrint) {
        if (!"NONE".equalsIgnoreCase(context.getInitialized())) {
            SSBContextOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBContextOraclev10g.appendStringWithSpace(buffer, "INITIALIZED");
            SSBContextOraclev10g.appendStringWithSpace(buffer, context.getInitialized());
        } else if (!"NO".equalsIgnoreCase(context.getAccessedGlobally())) {
            SSBContextOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBContextOraclev10g.appendStringWithSpace(buffer, "ACCESSED");
            SSBContextOraclev10g.appendStringWithSpace(buffer, "GLOBALLY");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof ContextOraclev10g && ((ContextOraclev10g)object).isMarkedGenerate();
    }
}

