/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ASMDiskOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DiskGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FailGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDiskGroupOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        SSBDiskGroupOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        DiskGroupOraclev10g dg = (DiskGroupOraclev10g)object;
        this.storageDesign = dg.getStorageDesign();
        this.appendPrompt(buffer, dg, "DISKGROUP");
        this.appendComment(oldbuffer, dg);
        this.appendCreateDiskGroup(buffer, dg);
        this.appendRedundancy(buffer, dg);
        advancedComment = buffer.toString();
        FailGroupOraclev10g[] failGroups = (FailGroupOraclev10g[])((StorageDesignOraclev10g)dg.getStorageDesign()).getFailGroupSet().toArray();
        for (int i = 0; i < failGroups.length; ++i) {
            FailGroupOraclev10g fg = failGroups[i];
            if (fg.getDiskGroup() == null || !fg.getDiskGroup().getName().equalsIgnoreCase(dg.getName())) continue;
            this.appendFailGroup(buffer, fg, prettyPrint);
        }
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBDiskGroupOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateDiskgroup();
    }

    private void appendFailGroup(StringBuffer buffer, FailGroupOraclev10g fg, boolean prettyPrint) {
        SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, "FAILGROUP");
        SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fg));
        SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, "DISK");
        ASMDiskOraclev10g[] asmDisks = (ASMDiskOraclev10g[])((StorageDesignOraclev10g)fg.getStorageDesign()).getASMDiskSet().toArray();
        for (int i = 0; i < asmDisks.length; ++i) {
            ASMDiskOraclev10g asmDisk = asmDisks[i];
            if (!asmDisk.getFailGroup().getName().equalsIgnoreCase(fg.getName())) continue;
            SSBDiskGroupOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            this.appendQualifiedDiskClause(buffer, asmDisk);
        }
    }

    private void appendQualifiedDiskClause(StringBuffer buffer, ASMDiskOraclev10g asmDisk) {
        SSBDiskGroupOraclev10g.appendString(buffer, '\'');
        SSBDiskGroupOraclev10g.appendString(buffer, asmDisk.getSearchString());
        SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, '\'');
        SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, "NAME");
        SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(asmDisk));
        this.appendSize(buffer, asmDisk);
        if (asmDisk.getForce().equalsIgnoreCase("YES")) {
            SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, "FORCE");
        } else {
            SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, "NOFORCE");
        }
    }

    private void appendSize(StringBuffer buffer, ASMDiskOraclev10g asmDisk) {
        SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, "SIZE");
        this.appendStringWithSpace(buffer, asmDisk.getSize());
        SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, asmDisk.getSizeMeasurementUnit());
    }

    private void appendRedundancy(StringBuffer buffer, DiskGroupOraclev10g dg) {
        if (!dg.getRedundancy().equalsIgnoreCase("NORMAL")) {
            SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, dg.getRedundancy());
            SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, "REDUNDANCY");
        }
    }

    private void appendCreateDiskGroup(StringBuffer buffer, DiskGroupOraclev10g dg) {
        this.appendCreate(buffer);
        SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, "DISKGROUP");
        SSBDiskGroupOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(dg));
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DiskGroupOraclev10g && ((DiskGroupOraclev10g)object).isMarkedGenerate();
    }
}

