/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SynonymOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSynonymOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        SynonymOraclev10g synonym = (SynonymOraclev10g)object;
        this.storageDesign = synonym.getStorageDesign();
        if (!synonym.getObject().trim().equalsIgnoreCase("")) {
            this.appendPrompt(buffer, synonym, "SYNONYM");
            this.appendComment(oldbuffer, synonym);
            SSBSynonymOraclev10g.appendStringWithSpace(buffer, "CREATE");
            this.appendPublic(buffer, synonym);
            SSBSynonymOraclev10g.appendStringWithSpace(buffer, "SYNONYM");
            SSBSynonymOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(synonym));
            advancedComment = buffer.toString();
            this.appendObject(buffer, synonym);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBSynonymOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementCreateSynomym();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SynonymOraclev10g && ((SynonymOraclev10g)object).isMarkedGenerate();
    }

    private void appendPublic(StringBuffer buffer, SynonymOraclev10g synonym) {
        if ("YES".equalsIgnoreCase(synonym.getPublic())) {
            SSBSynonymOraclev10g.appendStringWithSpace(buffer, "PUBLIC");
        }
    }

    private void appendObject(StringBuffer buffer, SynonymOraclev10g synonym) {
        buffer.append(NEWLINE);
        SSBSynonymOraclev10g.appendStringWithSpace(buffer, "FOR");
        if (synonym.getObjectUser() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            buffer.append(this.storageDesign.getFormatedName(synonym.getObjectUser())).append('.');
        }
        String objectName = synonym.getObject();
        objectName = synonym.getObjNameHasQuotes() ? '\"' + objectName + '\"' : this.storageDesign.getFormatedName(objectName);
        buffer.append(objectName);
        String dbLink = synonym.getDBLink();
        if (dbLink != null && dbLink.length() > 0) {
            buffer.append("@").append(dbLink);
        }
    }
}

