/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSpaceOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableSpaceOraclev10g && ((TableSpaceOraclev10g)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        TableSpaceOraclev10g tableSpace = (TableSpaceOraclev10g)object;
        this.storageDesign = tableSpace.getStorageDesign();
        if (!tableSpace.isNullInstance()) {
            List list = tableSpace.getDataFiles();
            this.appendPrompt(buffer, tableSpace, "TABLESPACE");
            this.appendComment(oldbuffer, tableSpace);
            this.appendCreate(buffer, tableSpace);
            advancedComment = buffer.toString();
            this.appendDataFiles(buffer, tableSpace, list, prettyPrint);
            this.appendMinimumExtent(buffer, tableSpace, prettyPrint);
            this.appendBlockSize(buffer, tableSpace, prettyPrint);
            this.appendLogging(buffer, tableSpace, prettyPrint);
            this.appendForceLogging(buffer, tableSpace, prettyPrint);
            this.appendStatus(buffer, tableSpace, prettyPrint);
            this.appendContents(buffer, tableSpace, prettyPrint);
            this.appendDefaultStorage(buffer, tableSpace, prettyPrint);
            this.appendExtentManagement(buffer, tableSpace, prettyPrint);
            this.appendSegmentManagement(buffer, tableSpace, prettyPrint);
            this.appendFlashBackMode(buffer, tableSpace, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementCreateTablespace();
        }
    }

    private void appendFlashBackMode(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        if (tableSpace.getFlashBack() != null) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "FLASHBACK");
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, tableSpace.getFlashBack());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "FLASHBACK");
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "ON");
        }
    }

    private void appendCreate(StringBuffer buffer, TableSpaceOraclev10g tableSpace) {
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "CREATE");
        if (!"".equals(tableSpace.getFileType())) {
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, tableSpace.getFileType());
        }
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
    }

    private void appendSegmentManagement(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        String segmentManagement;
        String contents = tableSpace.getContents();
        String extentManagement = tableSpace.getExtentManagement();
        if (contents.equalsIgnoreCase("PERMANENT") && extentManagement.equalsIgnoreCase("LOCAL") && !"".equals(segmentManagement = tableSpace.getSegmentManagement())) {
            buffer.append(NEWLINE);
            buffer.append("    ").append("SEGMENT SPACE MANAGEMENT ").append(segmentManagement);
        }
    }

    private void appendBlockSize(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        int blockSize = tableSpace.getBlockSize();
        if (blockSize > 0) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "BLOCKSIZE");
            this.appendStringWithSpace(buffer, blockSize);
        }
    }

    private void appendDataFiles(StringBuffer buffer, TableSpaceOraclev10g tableSpace, List dataFiles, boolean prettyPrint) {
        Iterator setIt = dataFiles.iterator();
        boolean b = false;
        while (setIt.hasNext()) {
            DataFileOracle dataFile = (DataFileOracle)setIt.next();
            if (!b) {
                buffer.append(NEWLINE);
                buffer.append("    ");
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "DATAFILE");
                b = true;
            } else {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, ',');
            }
            String filename = dataFile.getFileName().trim();
            if (!filename.equals("")) {
                SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, this.addQuotes(filename, true));
            }
            if (dataFile.getSize() > 0L) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "SIZE");
                this.appendStringWithSpace(buffer, dataFile.getSize());
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, dataFile.getMeasureUnit());
            }
            if (dataFile.getReuse().equalsIgnoreCase("YES") && !filename.equals("")) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "REUSE");
            }
            if ("ON".equalsIgnoreCase(dataFile.getAutoextend()) || "OFF".equalsIgnoreCase(dataFile.getAutoextend())) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, dataFile.getAutoextend());
                if (!dataFile.getAutoextend().equalsIgnoreCase("ON")) continue;
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, dataFile.getNextBlockSize());
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "K");
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "MAXSIZE");
                if (dataFile.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "UNLIMITED");
                    continue;
                }
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, dataFile.getMaxSize());
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "K");
                continue;
            }
            if (!this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) continue;
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
            if (dataFile.getSize() != 0L) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "OFF");
                continue;
            }
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "ON");
        }
    }

    private void appendMinimumExtent(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        int minExtent;
        if ("DICTIONARY".equalsIgnoreCase(tableSpace.getExtentManagement()) && (minExtent = tableSpace.getMinExtLen()) > 0) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "MINIMUM");
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "EXTENT");
            this.appendStringWithSpace(buffer, minExtent);
        }
    }

    private void appendLogging(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, tableSpace.getLogging());
        }
    }

    private void appendForceLogging(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(tableSpace.getForceLogging())) {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "FORCE");
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "LOGGING");
        }
    }

    private void appendStatus(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        String status = tableSpace.getStatus();
        SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, status);
    }

    private void appendContents(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        String contents = tableSpace.getContents();
        SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, contents);
    }

    private void appendDefaultStorage(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        String compression = tableSpace.getDSCompression();
        if ("LOCAL".equalsIgnoreCase(tableSpace.getExtentManagement())) {
            if (!compression.equals("")) {
                SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, compression);
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
        } else {
            SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
            if (!compression.equals("")) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, compression);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "STORAGE");
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, '(');
                boolean props = false;
                long initExtent = tableSpace.getDSInitialExtent();
                long nextExtent = tableSpace.getDSNextExtent();
                int minExtents = tableSpace.getDSMinExtents();
                String maxtExtents = tableSpace.getDSMaxExtents();
                int pctIncrease = tableSpace.getDSPctIncrease();
                if (initExtent > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                    this.appendStringWithSpace(buffer, initExtent);
                    props = true;
                }
                if (nextExtent > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "NEXT");
                    this.appendStringWithSpace(buffer, nextExtent);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    if (minExtents > 1) {
                        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                        this.appendStringWithSpace(buffer, minExtents);
                        props = true;
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "1");
                        props = true;
                    }
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, maxtExtents);
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                    this.appendStringWithSpace(buffer, pctIncrease);
                    props = true;
                }
                if (props) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
        }
    }

    private void appendExtentManagement(StringBuffer buffer, TableSpaceOraclev10g tableSpace, boolean prettyPrint) {
        String extentManagement = tableSpace.getExtentManagement();
        SSBTableSpaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "EXTENT");
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "MANAGEMENT");
        SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, extentManagement);
        if (extentManagement.equalsIgnoreCase("LOCAL")) {
            if (tableSpace.getEMLocalSubtype().equalsIgnoreCase("AUTOALLOCATE")) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "AUTOALLOCATE");
            } else if (tableSpace.getEMLocalSubtype().equalsIgnoreCase("UNIFORM")) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "UNIFORM");
                if (tableSpace.getEMUniformSize() > 0) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(buffer, "SIZE");
                    this.appendStringWithSpace(buffer, tableSpace.getEMUniformSize());
                }
            }
        }
    }
}

