/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTemporaryTablespaceOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        TemporaryTablespaceOraclev10g ts = (TemporaryTablespaceOraclev10g)object;
        this.storageDesign = ts.getStorageDesign();
        this.appendPrompt(buffer, ts, "TEMPORARY TABLESPACE");
        this.appendComment(oldbuffer, ts);
        this.appendCreateTemporaryTablespace(buffer, ts);
        advancedComment = buffer.toString();
        this.appendTempFiles(buffer, ts, prettyPrint);
        this.appendTableSpaceGroup(buffer, ts);
        this.appendExtent(buffer, ts, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBTemporaryTablespaceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        SSBTemporaryTablespaceOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateTablespace();
    }

    private void appendTableSpaceGroup(StringBuffer buffer, TemporaryTablespaceOraclev10g ts) {
        String gr = ts.getTableSpaceGroup();
        if (gr != null && !gr.trim().equalsIgnoreCase("")) {
            SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "GROUP");
            if (!gr.equalsIgnoreCase("")) {
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, gr);
            } else {
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "''");
            }
        }
    }

    private void appendCreateTemporaryTablespace(StringBuffer buffer, TemporaryTablespaceOraclev10g ts) {
        this.appendCreate(buffer);
        if (!"".equals(ts.getFileType())) {
            SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, ts.getFileType());
        }
        SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "TEMPORARY");
        SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
        SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
    }

    private void appendTempFiles(StringBuffer buffer, TemporaryTablespaceOraclev10g tempTS, boolean prettyPrint) {
        Iterator setIt = tempTS.getDFiles().iterator();
        boolean b = false;
        while (setIt.hasNext()) {
            boolean outputFileName;
            DataFileOraclev10g dataFile = (DataFileOraclev10g)setIt.next();
            if (!b) {
                buffer.append(NEWLINE);
                buffer.append("    ");
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "TEMPFILE");
                b = true;
            } else {
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, ',');
            }
            String filename = dataFile.getFileName().trim();
            boolean bl = outputFileName = tempTS.getOracleManagedFiles().equalsIgnoreCase("NO") && !filename.equals("");
            if (outputFileName) {
                SSBTemporaryTablespaceOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBTemporaryTablespaceOraclev10g.appendString(buffer, '\'');
                SSBTemporaryTablespaceOraclev10g.appendString(buffer, filename);
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, '\'');
            }
            if (dataFile.getSize() > 0L) {
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "SIZE");
                this.appendStringWithSpace(buffer, dataFile.getSize());
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, dataFile.getMeasureUnit());
            }
            if (outputFileName && dataFile.getReuse().equalsIgnoreCase("YES")) {
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "REUSE");
            }
            if ("ON".equalsIgnoreCase(dataFile.getAutoextend()) || "OFF".equalsIgnoreCase(dataFile.getAutoextend())) {
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, dataFile.getAutoextend());
                if (!dataFile.getAutoextend().equalsIgnoreCase("ON")) continue;
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, dataFile.getNextBlockSize());
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "K");
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "MAXSIZE");
                if (dataFile.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "UNLIMITED");
                    continue;
                }
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, dataFile.getMaxSize());
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "K");
                continue;
            }
            if (!this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) continue;
            SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
            if (dataFile.getSize() != 0L) {
                SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "OFF");
                continue;
            }
            SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "ON");
        }
    }

    private void appendExtent(StringBuffer buffer, TemporaryTablespaceOraclev10g ts, boolean prettyPrint) {
        if (ts.getUniformSize() != 0L) {
            SSBTemporaryTablespaceOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "EXTENT");
            SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "MANAGEMENT");
            SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "LOCAL");
            SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "UNIFORM");
            SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, "SIZE");
            this.appendStringWithSpace(buffer, ts.getUniformSize());
            SSBTemporaryTablespaceOraclev10g.appendStringWithSpace(buffer, ts.getMeasureUnitUniformSize());
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TemporaryTablespaceOraclev10g && ((TemporaryTablespaceOraclev10g)object).isMarkedGenerate();
    }
}

