/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v12c;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.MaskTemplate;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.TSDPPolicy;
import oracle.dbtools.crest.model.TSDPSubPolicy;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTSDPPolicyOracle
extends AbstractSSBOracle {
    private StorageDesign storageDesign;
    private Map<SensitiveType, List> map = new HashMap<SensitiveType, List>();
    private List generatedPolicies = new ArrayList();

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableProxy || object instanceof Table;
    }

    public SSBTSDPPolicyOracle(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (((ModelIDObject)object).isMarkedGenerate() && this.storageDesign.getAppView().getSettings().isIncludeTSDPInDDL()) {
            Table table = null;
            TableProxy tableProxy = null;
            if (object instanceof TableProxy) {
                tableProxy = (TableProxy)object;
                table = (Table)tableProxy.getObject();
                this.storageDesign = tableProxy.getStorageDesign();
            } else if (object instanceof Table) {
                table = (Table)object;
                Design design = table.getDesign();
                RDBMSSite site = table.getSelectedRDBMSSite();
                this.storageDesign = design.getStorageDesign(site, table);
            }
            if (table != null && table.isMarkedGenerate()) {
                this.getSensitiveTypes(table);
            }
        }
    }

    private void getSensitiveTypes(Table table) {
        Column[] columns = (Column[])table.getElements();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            SensitiveType sensitiveType = null;
            STAssociation sta = null;
            if (column.getSensitiveType() != null) {
                sensitiveType = column.getSensitiveType();
                sta = new STAssociation(column.getName(), column.getTable().getName(), column.getTable().getSchema(), column.getSensitiveTypeDescription());
            } else if (column.getUse() == 0 && column.getDomain() != null && column.getDomain().getSensitiveType() != null) {
                sensitiveType = column.getDomain().getSensitiveType();
                sta = new STAssociation(column.getName(), column.getTable().getName(), column.getTable().getSchema(), column.getDomain().getSensitiveTypeDescription());
            }
            if (sensitiveType == null) continue;
            ArrayList<STAssociation> list = this.map.get(sensitiveType);
            if (list == null) {
                list = new ArrayList<STAssociation>();
                this.map.put(sensitiveType, list);
            }
            list.add(sta);
        }
    }

    private List getTSDPPolicies(SensitiveType sensitiveType) {
        ArrayList<TSDPPolicy> list = new ArrayList<TSDPPolicy>();
        Iterator it = this.storageDesign.getAppView().getTSDPPolicySet().iterator();
        while (it.hasNext()) {
            TSDPPolicy policy = (TSDPPolicy)it.next();
            if (!policy.getSensitiveTypesList().contains(sensitiveType)) continue;
            list.add(policy);
        }
        return list;
    }

    private boolean appendTSDPPolicies(StringBuffer buffer) {
        if (this.map.size() > 0) {
            for (Map.Entry<SensitiveType, List> entry : this.map.entrySet()) {
                SensitiveType sensitiveType = entry.getKey();
                List list = entry.getValue();
                if (!sensitiveType.getGenerateInDDL()) continue;
                this.appendAddSensitiveType(buffer, sensitiveType);
                for (Object sta : list) {
                    this.appendAddSensitiveColumn(buffer, sensitiveType, (STAssociation)sta);
                }
                this.appendAddTSDPPolicies(buffer, sensitiveType);
                this.appendEnableProtectionType(buffer, sensitiveType);
            }
            return true;
        }
        return false;
    }

    private void appendAddSensitiveType(StringBuffer buffer, SensitiveType sensitiveType) {
        SSBTSDPPolicyOracle.appendString(buffer, "BEGIN");
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
        SSBTSDPPolicyOracle.appendString(buffer, "DBMS_TSDP_MANAGE.ADD_SENSITIVE_TYPE");
        SSBTSDPPolicyOracle.appendString(buffer, '(');
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "sensitive_type", 2);
        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "=>");
        SSBTSDPPolicyOracle.appendString(buffer, '\'');
        SSBTSDPPolicyOracle.appendString(buffer, sensitiveType.getName());
        SSBTSDPPolicyOracle.appendString(buffer, '\'');
        if (!"".equalsIgnoreCase(sensitiveType.getDescription())) {
            SSBTSDPPolicyOracle.appendString(buffer, ',');
            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "user_comment", 4);
            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "=>");
            SSBTSDPPolicyOracle.appendString(buffer, '\'');
            String desc = sensitiveType.getDescription();
            if (desc == null) {
                desc = "";
            }
            SSBTSDPPolicyOracle.appendString(buffer, desc);
            SSBTSDPPolicyOracle.appendString(buffer, '\'');
        }
        SSBTSDPPolicyOracle.appendString(buffer, ')');
        SSBTSDPPolicyOracle.appendString(buffer, ';');
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
        SSBTSDPPolicyOracle.appendString(buffer, "END");
        SSBTSDPPolicyOracle.appendString(buffer, ';');
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
        SSBTSDPPolicyOracle.appendString(buffer, '/');
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
    }

    private void appendAddSensitiveColumn(StringBuffer buffer, SensitiveType sensitiveType, STAssociation sta) {
        SSBTSDPPolicyOracle.appendString(buffer, "BEGIN");
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
        SSBTSDPPolicyOracle.appendString(buffer, "DBMS_TSDP_MANAGE.ADD_SENSITIVE_COLUMN");
        SSBTSDPPolicyOracle.appendString(buffer, '(');
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "schema_name", 5);
        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "=>");
        String schema = sta.getSchema();
        if (!"".equalsIgnoreCase(schema)) {
            SSBTSDPPolicyOracle.appendString(buffer, '\'');
            SSBTSDPPolicyOracle.appendString(buffer, schema);
            SSBTSDPPolicyOracle.appendString(buffer, '\'');
        } else {
            SSBTSDPPolicyOracle.appendString(buffer, "NULL");
        }
        SSBTSDPPolicyOracle.appendString(buffer, ',');
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "table_name", 6);
        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "=>");
        SSBTSDPPolicyOracle.appendString(buffer, '\'');
        SSBTSDPPolicyOracle.appendString(buffer, sta.getTableName());
        SSBTSDPPolicyOracle.appendString(buffer, '\'');
        SSBTSDPPolicyOracle.appendString(buffer, ',');
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "column_name", 5);
        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "=>");
        SSBTSDPPolicyOracle.appendString(buffer, '\'');
        SSBTSDPPolicyOracle.appendString(buffer, sta.getColumnName());
        SSBTSDPPolicyOracle.appendString(buffer, '\'');
        SSBTSDPPolicyOracle.appendString(buffer, ',');
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "sensitive_type", 2);
        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "=>");
        SSBTSDPPolicyOracle.appendString(buffer, '\'');
        SSBTSDPPolicyOracle.appendString(buffer, sensitiveType.getName());
        SSBTSDPPolicyOracle.appendString(buffer, '\'');
        String desc = sta.getDescription();
        if (desc != null && !"".equalsIgnoreCase(desc)) {
            SSBTSDPPolicyOracle.appendString(buffer, ',');
            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "user_comment", 4);
            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "=>");
            SSBTSDPPolicyOracle.appendString(buffer, '\'');
            SSBTSDPPolicyOracle.appendString(buffer, sta.getDescription());
            SSBTSDPPolicyOracle.appendString(buffer, '\'');
        }
        SSBTSDPPolicyOracle.appendString(buffer, ')');
        SSBTSDPPolicyOracle.appendString(buffer, ';');
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
        SSBTSDPPolicyOracle.appendString(buffer, "END");
        SSBTSDPPolicyOracle.appendString(buffer, ';');
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
        SSBTSDPPolicyOracle.appendString(buffer, '/');
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
    }

    private void appendAddTSDPPolicies(StringBuffer buffer, SensitiveType sensitiveType) {
        List policies = this.getTSDPPolicies(sensitiveType);
        if (policies.size() > 0) {
            for (Object obj : policies) {
                TSDPPolicy policy = (TSDPPolicy)obj;
                if (!policy.getGenerateInDDL()) continue;
                if (!this.generatedPolicies.contains(policy)) {
                    boolean isFirst = true;
                    Iterator<TSDPSubPolicy> i$ = policy.getElements().iterator();
                    while (i$.hasNext()) {
                        String propParentTable;
                        String propParentSchema;
                        int propLenght;
                        TSDPSubPolicy element;
                        TSDPSubPolicy subPolicy = element = i$.next();
                        SSBTSDPPolicyOracle.appendString(buffer, "DECLARE");
                        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "redact_feature_options");
                        SSBTSDPPolicyOracle.appendString(buffer, "DBMS_TSDP_PROTECT.FEATURE_OPTIONS");
                        SSBTSDPPolicyOracle.appendString(buffer, ';');
                        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "policy_conditions", 6);
                        SSBTSDPPolicyOracle.appendString(buffer, "DBMS_TSDP_PROTECT.POLICY_CONDITIONS");
                        SSBTSDPPolicyOracle.appendString(buffer, ';');
                        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                        SSBTSDPPolicyOracle.appendString(buffer, "BEGIN");
                        boolean hasFeatureOptions = false;
                        String expression = subPolicy.getExpression();
                        if (expression != null && !"".equalsIgnoreCase(expression)) {
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "redact_feature_options");
                            SSBTSDPPolicyOracle.appendString(buffer, '(');
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendString(buffer, "expression");
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ')', 15);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ":=");
                            expression = expression.replaceAll("'", "''");
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendString(buffer, expression);
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendString(buffer, ';');
                            hasFeatureOptions = true;
                        }
                        MaskTemplate maskTemplate = subPolicy.getMaskTemplate();
                        String mtype = subPolicy.getMaskType();
                        if (maskTemplate != null || "FULL".equalsIgnoreCase(mtype) || "RANDOM".equalsIgnoreCase(mtype)) {
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "redact_feature_options");
                            SSBTSDPPolicyOracle.appendString(buffer, '(');
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendString(buffer, "function_type");
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ')', 12);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ":=");
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            int functionType = 0;
                            if ("FULL".equalsIgnoreCase(mtype) || "RANDOM".equalsIgnoreCase(mtype)) {
                                String mt = this.getMaskTypeName(mtype);
                                SSBTSDPPolicyOracle.appendString(buffer, mt);
                            } else {
                                if (maskTemplate != null) {
                                    functionType = maskTemplate.getFunctionType();
                                }
                                SSBTSDPPolicyOracle.appendString(buffer, this.getFunctionTypeName(functionType));
                            }
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendString(buffer, ';');
                            hasFeatureOptions = true;
                            if (!"FULL".equalsIgnoreCase(mtype) && !"RANDOM".equalsIgnoreCase(mtype)) {
                                if (functionType == 0) {
                                    SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                                    SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "redact_feature_options");
                                    SSBTSDPPolicyOracle.appendString(buffer, '(');
                                    SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                    SSBTSDPPolicyOracle.appendString(buffer, "function_parameters");
                                    SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                    SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ')', 6);
                                    SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ":=");
                                    SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                    SSBTSDPPolicyOracle.appendString(buffer, maskTemplate.getFunctionParameters());
                                    SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                    SSBTSDPPolicyOracle.appendString(buffer, ';');
                                } else {
                                    String replaceString;
                                    String pattern = maskTemplate.getPattern();
                                    if (!"".equalsIgnoreCase(pattern)) {
                                        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                                        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "redact_feature_options");
                                        SSBTSDPPolicyOracle.appendString(buffer, '(');
                                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                        SSBTSDPPolicyOracle.appendString(buffer, "regexp_pattern");
                                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ')', 11);
                                        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ":=");
                                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                        SSBTSDPPolicyOracle.appendString(buffer, pattern);
                                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                        SSBTSDPPolicyOracle.appendString(buffer, ';');
                                    }
                                    if (!"".equalsIgnoreCase(replaceString = maskTemplate.getReplaceString())) {
                                        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                                        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "redact_feature_options");
                                        SSBTSDPPolicyOracle.appendString(buffer, '(');
                                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                        SSBTSDPPolicyOracle.appendString(buffer, "regexp_replace_string");
                                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ')', 4);
                                        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ":=");
                                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                        SSBTSDPPolicyOracle.appendString(buffer, replaceString);
                                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                        SSBTSDPPolicyOracle.appendString(buffer, ';');
                                    }
                                    SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                                    SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "redact_feature_options");
                                    SSBTSDPPolicyOracle.appendString(buffer, '(');
                                    SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                    SSBTSDPPolicyOracle.appendString(buffer, "regexp_position");
                                    SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                    SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ')', 10);
                                    SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ":=");
                                    SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                    this.appendString(buffer, maskTemplate.getPosition());
                                    SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                    SSBTSDPPolicyOracle.appendString(buffer, ';');
                                    SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                                    SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "redact_feature_options");
                                    SSBTSDPPolicyOracle.appendString(buffer, '(');
                                    SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                    SSBTSDPPolicyOracle.appendString(buffer, "regexp_occurrence");
                                    SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                    SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ')', 8);
                                    SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ":=");
                                    SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                    this.appendString(buffer, maskTemplate.getOccurrence());
                                    SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                    SSBTSDPPolicyOracle.appendString(buffer, ';');
                                    String matchParameter = maskTemplate.getMatchParameter();
                                    if (!"".equalsIgnoreCase(matchParameter)) {
                                        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                                        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "redact_feature_options");
                                        SSBTSDPPolicyOracle.appendString(buffer, '(');
                                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                        SSBTSDPPolicyOracle.appendString(buffer, "regexp_match_parameter");
                                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ')', 3);
                                        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ":=");
                                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                        SSBTSDPPolicyOracle.appendString(buffer, matchParameter);
                                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                                        SSBTSDPPolicyOracle.appendString(buffer, ';');
                                    }
                                }
                            }
                        }
                        if (!hasFeatureOptions) {
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "--  ERROR: There are no Feature Options defined!");
                            DDLFileMaker.incrementErrors();
                        }
                        boolean hasPolicyConditions = false;
                        String propDatatype = subPolicy.getPropertyDatatype();
                        if (propDatatype != null && !"".equalsIgnoreCase(propDatatype)) {
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "policy_conditions", 6);
                            SSBTSDPPolicyOracle.appendString(buffer, '(');
                            SSBTSDPPolicyOracle.appendString(buffer, "DBMS_TSDP_PROTECT.DATATYPE");
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ')', 1);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ":=");
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendString(buffer, propDatatype);
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendString(buffer, ';');
                            hasPolicyConditions = true;
                        }
                        if ((propLenght = subPolicy.getPropertyLenght()) > 0) {
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "policy_conditions", 6);
                            SSBTSDPPolicyOracle.appendString(buffer, '(');
                            SSBTSDPPolicyOracle.appendString(buffer, "DBMS_TSDP_PROTECT.LENGTH");
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ')', 3);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ":=");
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            this.appendString(buffer, propLenght);
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendString(buffer, ';');
                            hasPolicyConditions = true;
                        }
                        if ((propParentSchema = subPolicy.getPropertyParentSchema()) != null && !"".equalsIgnoreCase(propParentSchema)) {
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "policy_conditions", 6);
                            SSBTSDPPolicyOracle.appendString(buffer, '(');
                            SSBTSDPPolicyOracle.appendString(buffer, "DBMS_TSDP_PROTECT.PARENT_SCHEMA");
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ')', 1);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ":=");
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendString(buffer, propParentSchema);
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendString(buffer, ';');
                            hasPolicyConditions = true;
                        }
                        if ((propParentTable = subPolicy.getPropertyParentTable()) != null && !"".equalsIgnoreCase(propParentTable)) {
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "policy_conditions", 6);
                            SSBTSDPPolicyOracle.appendString(buffer, '(');
                            SSBTSDPPolicyOracle.appendString(buffer, "DBMS_TSDP_PROTECT.PARENT_TABLE");
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ')', 2);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ":=");
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendString(buffer, propParentTable);
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendString(buffer, ';');
                            hasPolicyConditions = true;
                        }
                        if (!hasPolicyConditions) {
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "--  ERROR: There are no Policy Conditions defined!");
                            DDLFileMaker.incrementErrors();
                        }
                        if (isFirst) {
                            isFirst = false;
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                            SSBTSDPPolicyOracle.appendString(buffer, "DBMS_TSDP_PROTECT.ADD_POLICY");
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                            SSBTSDPPolicyOracle.appendString(buffer, '(');
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendString(buffer, policy.getName());
                            SSBTSDPPolicyOracle.appendString(buffer, '\'');
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ',');
                            SSBTSDPPolicyOracle.appendString(buffer, "DBMS_TSDP_PROTECT.REDACT");
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ',');
                            SSBTSDPPolicyOracle.appendString(buffer, "redact_feature_options");
                            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ',');
                            SSBTSDPPolicyOracle.appendString(buffer, "policy_conditions");
                            SSBTSDPPolicyOracle.appendString(buffer, ')');
                            SSBTSDPPolicyOracle.appendString(buffer, ';');
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                            SSBTSDPPolicyOracle.appendString(buffer, "END");
                            SSBTSDPPolicyOracle.appendString(buffer, ';');
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                            SSBTSDPPolicyOracle.appendString(buffer, '/');
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                            continue;
                        }
                        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                        SSBTSDPPolicyOracle.appendString(buffer, "DBMS_TSDP_PROTECT.ALTER_POLICY");
                        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                        SSBTSDPPolicyOracle.appendString(buffer, '(');
                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                        SSBTSDPPolicyOracle.appendString(buffer, policy.getName());
                        SSBTSDPPolicyOracle.appendString(buffer, '\'');
                        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ',');
                        SSBTSDPPolicyOracle.appendString(buffer, "redact_feature_options");
                        SSBTSDPPolicyOracle.appendStringWithSpace(buffer, ',');
                        SSBTSDPPolicyOracle.appendString(buffer, "policy_conditions");
                        SSBTSDPPolicyOracle.appendString(buffer, ')');
                        SSBTSDPPolicyOracle.appendString(buffer, ';');
                        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                        SSBTSDPPolicyOracle.appendString(buffer, "END");
                        SSBTSDPPolicyOracle.appendString(buffer, ';');
                        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                        SSBTSDPPolicyOracle.appendString(buffer, '/');
                        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                        SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                    }
                    this.generatedPolicies.add(policy);
                }
                SSBTSDPPolicyOracle.appendString(buffer, "BEGIN");
                SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                SSBTSDPPolicyOracle.appendString(buffer, "DBMS_TSDP_PROTECT.ASSOCIATE_POLICY");
                SSBTSDPPolicyOracle.appendString(buffer, '(');
                SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "policy_name", 2);
                SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "=>");
                SSBTSDPPolicyOracle.appendString(buffer, '\'');
                SSBTSDPPolicyOracle.appendString(buffer, policy.getName());
                SSBTSDPPolicyOracle.appendString(buffer, '\'');
                SSBTSDPPolicyOracle.appendString(buffer, ',');
                SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "sensitive_type", 2);
                SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "=>");
                SSBTSDPPolicyOracle.appendString(buffer, '\'');
                SSBTSDPPolicyOracle.appendString(buffer, sensitiveType.getName());
                SSBTSDPPolicyOracle.appendString(buffer, '\'');
                SSBTSDPPolicyOracle.appendString(buffer, ',');
                SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
                SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "associate", 2);
                SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "=>");
                SSBTSDPPolicyOracle.appendString(buffer, "TRUE");
                SSBTSDPPolicyOracle.appendString(buffer, ')');
                SSBTSDPPolicyOracle.appendString(buffer, ';');
                SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                SSBTSDPPolicyOracle.appendString(buffer, "END");
                SSBTSDPPolicyOracle.appendString(buffer, ';');
                SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                SSBTSDPPolicyOracle.appendString(buffer, '/');
                SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
                SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
            }
        } else {
            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "--  ERROR: There are no any TSDP Policies associated with that Sensitive Type: " + sensitiveType.getName());
            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private String getFunctionTypeName(int functionType) {
        if (functionType == 1) {
            return "DBMS_REDACT.REGEXP";
        }
        return "DBMS_REDACT.PARTIAL";
    }

    private String getMaskTypeName(String maskType) {
        if ("FULL".equalsIgnoreCase(maskType)) {
            return "DBMS_REDACT.FULL";
        }
        if ("RANDOM".equalsIgnoreCase(maskType)) {
            return "DBMS_REDACT.RANDOM";
        }
        if ("REGEXP".equalsIgnoreCase(maskType)) {
            return "DBMS_REDACT.REGEXP";
        }
        return "DBMS_REDACT.PARTIAL";
    }

    private void appendEnableProtectionType(StringBuffer buffer, SensitiveType sensitiveType) {
        if (sensitiveType.isEnable()) {
            SSBTSDPPolicyOracle.appendString(buffer, "BEGIN");
            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
            SSBTSDPPolicyOracle.appendString(buffer, "DBMS_TSDP_PROTECT.ENABLE_PROTECTION_TYPE");
            SSBTSDPPolicyOracle.appendString(buffer, '(');
            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 1);
            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "sensitive_type", 2);
            SSBTSDPPolicyOracle.appendStringWithSpace(buffer, "=>");
            SSBTSDPPolicyOracle.appendString(buffer, '\'');
            SSBTSDPPolicyOracle.appendString(buffer, sensitiveType.getName());
            SSBTSDPPolicyOracle.appendString(buffer, '\'');
            SSBTSDPPolicyOracle.appendString(buffer, ')');
            SSBTSDPPolicyOracle.appendString(buffer, ';');
            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
            SSBTSDPPolicyOracle.appendString(buffer, "END");
            SSBTSDPPolicyOracle.appendString(buffer, ';');
            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
            SSBTSDPPolicyOracle.appendString(buffer, '/');
            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
        }
    }

    @Override
    public void clearTemporaryObjects() {
        this.map.clear();
        this.generatedPolicies.clear();
    }

    @Override
    public void doOnFinish(StringBuffer buffer) {
        if (this.appendTSDPPolicies(buffer)) {
            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
            SSBTSDPPolicyOracle.appendNewLine(buffer, true, 0);
            DDLFileMaker.incrementTSDPPolicies();
        }
    }

    private class STAssociation {
        private String columnName;
        private String description;
        private String schema;
        private String tableName;

        public STAssociation(String columnName, String tableName, String schema, String description) {
            this.columnName = columnName;
            this.tableName = tableName;
            this.schema = schema;
            this.description = description;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getTableName() {
            return this.tableName;
        }
    }
}

