/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.CollectionTypeProxyOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBCollectionTypeOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (object instanceof CollectionType) {
            CollectionType type = (CollectionType)object;
            SSBCollectionTypeOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, type);
        } else if (object instanceof CollectionTypeProxyOraclev9i) {
            CollectionTypeProxyOraclev9i typeProxy = (CollectionTypeProxyOraclev9i)object;
            this.storageDesign = typeProxy.getStorageDesign();
            SSBCollectionTypeOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, typeProxy);
            this.appendFullDefinition(buffer, typeProxy, prettyPrint);
            this.appendPermissions(buffer, typeProxy);
            DDLFileMaker.incrementCreateCollectionType();
        }
    }

    private void appendFullDefinition(StringBuffer oldbuffer, CollectionTypeProxyOraclev9i typeProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        SSBCollectionTypeOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
        SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, "CREATE");
        SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, "OR");
        SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, "REPLACE");
        SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, "TYPE");
        if (typeProxy.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBCollectionTypeOraclev9i.appendString(buffer, this.storageDesign.getFormatedName(typeProxy.getOwner()));
            SSBCollectionTypeOraclev9i.appendString(buffer, '.');
        }
        SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
        advancedComment = buffer.toString();
        SSBCollectionTypeOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, "IS");
        if (typeProxy.isArrayType(typeProxy.getType())) {
            SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, "VARRAY");
            SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, '(');
            this.appendStringWithSpace(buffer, typeProxy.getMaxElement());
            SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, ')');
        } else {
            SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, "TABLE");
        }
        SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, "OF");
        String datatype = null;
        TypeElement typeElement = ((CollectionType)typeProxy.getObject()).getElementType();
        DesignObject elemDataType = typeElement.getType();
        if (elemDataType instanceof StructuredType || elemDataType instanceof CollectionType) {
            RelationalObjectProxy proxy = this.storageDesign.getProxy(elemDataType);
            datatype = proxy != null ? this.storageDesign.getFormatedLongNameDDL(proxy) : this.storageDesign.getFormatedName(elemDataType);
            if (typeElement.isReference() && elemDataType instanceof StructuredType) {
                datatype = "REF " + datatype;
            }
        } else {
            datatype = typeElement.getDataType("Oracle9i");
        }
        SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, datatype);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBCollectionTypeOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisherWithSlash(buffer, prettyPrint);
        SSBCollectionTypeOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof CollectionTypeProxyOraclev9i && ((CollectionTypeProxyOraclev9i)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof CollectionType && ((CollectionType)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer oldBuffer, CollectionTypeProxyOracle collectionTypeProxyOracle) {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)collectionTypeProxyOracle.getStorageDesign();
        StringBuffer buffer = new StringBuffer();
        PermissionsSetOracle permissionsSet = storageDesignOracle.getPermissionsSet();
        Iterator it = permissionsSet.iterator();
        while (it.hasNext()) {
            PermissionsOracle permissions = (PermissionsOracle)it.next();
            if (!collectionTypeProxyOracle.equals(permissions.getCollectionTypeOracle()) || permissions.getUser() == null && permissions.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissions.getPrivileges())) {
                this.appendPrivileges(oldBuffer, buffer, permissions, collectionTypeProxyOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissions.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(oldBuffer, buffer, permissions, collectionTypeProxyOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer oldBuffer, StringBuffer buffer, PermissionsOracle permissions, CollectionTypeProxyOracle collectionTypeProxyOracle, StorageDesignOracle storageDesignOracle, boolean withGrantOption) {
        buffer.append(NEWLINE);
        this.appendComment(buffer, permissions);
        SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, "GRANT");
        if (withGrantOption) {
            buffer.append(permissions.getPrivilegesWithGrantOption());
        } else {
            buffer.append(permissions.getPrivileges());
        }
        this.appendObject(buffer, collectionTypeProxyOracle, storageDesignOracle);
        this.appendTo(buffer, permissions, storageDesignOracle);
        if (withGrantOption) {
            this.appendGrantOption(buffer, permissions);
        }
        String advancedComment = buffer.toString();
        buffer.append(NEWLINE);
        buffer.append(';');
        buffer.append(NEWLINE);
        this.appendToBuffer(oldBuffer, buffer, advancedComment);
    }

    private void appendObject(StringBuffer buffer, CollectionTypeProxyOracle collectionTypeProxyOracle, StorageDesign storageDesign) {
        buffer.append(NEWLINE);
        SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, "ON");
        SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(collectionTypeProxyOracle));
    }

    private void appendTo(StringBuffer buffer, PermissionsOracle privileges, StorageDesign storageDesign) {
        SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, "TO");
        if ("YES".equalsIgnoreCase(privileges.getPublic())) {
            SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, "PUBLIC");
        } else if (privileges.getUser() != null) {
            SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedName(privileges.getUser()));
        } else if (privileges.getRole() != null) {
            SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedName(privileges.getRole()));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOracle permissions) {
        if (permissions.getRole() == null) {
            SSBCollectionTypeOraclev9i.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }
}

