/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.BitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBCreateBitmapJoinIndexOraclev9i
extends AbstractSSBOracle {
    private StorageDesignOraclev9i storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        BitmapJoinIndexOraclev9i index = (BitmapJoinIndexOraclev9i)object;
        this.storageDesign = (StorageDesignOraclev9i)index.getStorageDesign();
        this.appendComment(oldbuffer, index);
        this.appendCreateBitmapJoinIndex(buffer, index);
        advancedComment = buffer.toString();
        this.appendIndexColumns(buffer, index, prettyPrint);
        this.appendFrom(buffer, index, prettyPrint);
        this.appendWhere(buffer, index, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateIndex();
    }

    private void appendCreateBitmapJoinIndex(StringBuffer buffer, BitmapJoinIndexOraclev9i index) {
        this.appendCreate(buffer);
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "BITMAP");
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "INDEX");
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(index));
    }

    private void appendIndexColumns(StringBuffer buffer, BitmapJoinIndexOraclev9i index, boolean prettyPrint) {
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "ON");
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(index.getTable()));
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        Object[] cols = index.getIndexColumnSet().toArray();
        for (int i = 0; i < cols.length; ++i) {
            TableProxyOracle tableProxy;
            if (i > 0) {
                this.appendComma(buffer);
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            }
            String colID = (String)cols[i];
            ColumnProxyOracle column = (ColumnProxyOracle)index.getStorageDesign().getColumnProxySet().getProxy(colID);
            if (column == null || (tableProxy = column.getTableProxy()) == null) continue;
            String sortOrder = (String)cols[++i];
            SSBCreateBitmapJoinIndexOraclev9i.appendString(buffer, ' ');
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy) + '.' + this.storageDesign.getFormatedName(column));
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, sortOrder);
        }
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ')');
    }

    private void appendFrom(StringBuffer buffer, BitmapJoinIndexOraclev9i index, boolean prettyPrint) {
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "FROM");
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(index.getTable()));
        for (int i = 0; i < index.getDimensionTables().length; ++i) {
            TableProxyOracle table = (TableProxyOracle)index.getStorageDesign().getTableProxySet().getProxy((String)index.getDimensionTables()[i]);
            if (table == null) continue;
            this.appendComma(buffer);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(table));
        }
    }

    private void appendWhere(StringBuffer buffer, BitmapJoinIndexOraclev9i index, boolean prettyPrint) {
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "WHERE");
        Object[] cols = index.getJoinColumnSet().toArray();
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "AND");
            }
            String dimensionCol = (String)cols[i];
            String baseCol = (String)cols[++i];
            ColumnProxyOracle dimColumn = (ColumnProxyOracle)index.getStorageDesign().getColumnProxySet().getProxy(dimensionCol);
            ColumnProxyOracle baseColumn = (ColumnProxyOracle)index.getStorageDesign().getColumnProxySet().getProxy(baseCol);
            if (dimColumn == null || baseColumn == null) continue;
            TableProxyOracle dimTable = dimColumn.getTableProxy();
            TableProxyOracle baseTable = baseColumn.getTableProxy();
            if (dimTable == null || baseTable == null) continue;
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(dimTable) + '.' + this.storageDesign.getFormatedName(dimColumn));
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "=");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(baseTable) + '.' + this.storageDesign.getFormatedName(baseColumn));
        }
        if ("YES".equalsIgnoreCase(index.getLocalPartitioning()) || !index.getTable().getPartitioned().equalsIgnoreCase("NO")) {
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "LOCAL");
            this.appendPartitionList(buffer, index, index.getTable(), prettyPrint);
        }
        this.appendIndexAttributes(buffer, index, prettyPrint);
    }

    private void appendPartitionList(StringBuffer buffer, BitmapJoinIndexOraclev9i index, TableProxyOracle tableProxy, boolean prettyPrint) {
        PartitionListOraclev9i partitionList = (PartitionListOraclev9i)tableProxy.getPartitionList();
        if (partitionList != null) {
            String subPartitionTableSpaceIDs;
            String partitionType = partitionList.getPartitionType();
            if (("HASH BY QUANTITY".equalsIgnoreCase(partitionType) || "COMPOSITE BY HASH".equalsIgnoreCase(partitionType)) && !"".equals((subPartitionTableSpaceIDs = index.getHashSubPartitionsTableSpaces()).trim())) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionTableSpaceIDs));
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ')');
            }
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                this.appendPartitions(buffer, index, partitionList, false, prettyPrint);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(partitionType) || "COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                this.appendOnCompPartitioned(buffer, index, partitionList, prettyPrint);
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                this.appendHashPartitions(buffer, partitionList, index, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                this.appendListPartitions(buffer, partitionList, index, prettyPrint);
            }
        }
    }

    private void appendListPartitions(StringBuffer buffer, PartitionListOraclev9i partitionList, BitmapJoinIndexOraclev9i indexProxy, boolean prettyPrint) {
        ListPartitionSetOraclev9i partitionSet = (ListPartitionSetOraclev9i)((StorageDesignOraclev9i)partitionList.getStorageDesign()).getListPartitionSet();
        Object[] partitionsList = partitionSet.toArray();
        Arrays.sort(partitionsList, new PossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < partitionsList.length; ++i) {
            sortedList.add(partitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            LocalIndexProperties lip;
            ListPartitionOraclev9i partition = (ListPartitionOraclev9i)setIt.next();
            if (partition.getPartitionList() == null || !partition.getPartitionList().toString().equalsIgnoreCase(partitionList.toString())) continue;
            if (first) {
                buffer.append(NEWLINE).append("    ");
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                buffer.append(NEWLINE).append("    ");
                first = false;
            } else {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ',');
                buffer.append(NEWLINE).append("    ");
            }
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            if ((lip = this.getPropsForIndex(indexProxy, partition)) == null) continue;
            TableSpaceOraclev9i ts = (TableSpaceOraclev9i)lip.getTableSpace();
            String logging = lip.getLogging();
            SegmentOraclev9i indexSegment = (SegmentOraclev9i)lip.getSegment();
            if (indexSegment != null) {
                this.appendSegment(buffer, indexSegment, prettyPrint);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                if (ts != null) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                }
            }
            if (!this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(logging)) {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(logging)) continue;
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            buffer.append(NEWLINE).append("    ");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendHashPartitions(StringBuffer buffer, PartitionListOraclev9i partitionList, BitmapJoinIndexOraclev9i indexProxy, boolean prettyPrint) {
        HashPartitionSetOraclev9i partitionSet = (HashPartitionSetOraclev9i)((StorageDesignOraclev9i)partitionList.getStorageDesign()).getHashPartitionSet();
        Iterator setIt = partitionSet.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            TableSpaceOraclev9i ts;
            LocalIndexProperties lip;
            HashPartitionOraclev9i partition = (HashPartitionOraclev9i)setIt.next();
            if (partition.getPartitionList() == null || !partition.getPartitionList().toString().equalsIgnoreCase(partitionList.toString())) continue;
            if (first) {
                buffer.append(NEWLINE).append("    ");
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                buffer.append(NEWLINE).append("    ");
                first = false;
            } else {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ',');
                buffer.append(NEWLINE).append("    ");
            }
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            if ((lip = this.getPropsForIndex(indexProxy, partition)) == null || (ts = (TableSpaceOraclev9i)lip.getTableSpace()) == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
        }
        if (!first) {
            buffer.append(NEWLINE).append("    ");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendOnCompPartitioned(StringBuffer buffer, BitmapJoinIndexOraclev9i indexProxy, PartitionListOraclev9i partitionList, boolean prettyPrint) {
        PartitionSetOracle partitionSet = ((StorageDesignOracle)partitionList.getStorageDesign()).getPartitionSet();
        Object[] partitionsList = partitionSet.toArray();
        Arrays.sort(partitionsList, new PossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < partitionsList.length; ++i) {
            sortedList.add(partitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            LocalIndexProperties lip;
            PartitionOraclev9i partition = (PartitionOraclev9i)setIt.next();
            if (partition.getPartitionList() == null || !partition.getPartitionList().toString().equalsIgnoreCase(partitionList.toString())) continue;
            if (first) {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                buffer.append(',');
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            if ((lip = this.getPropsForIndex(indexProxy, partition)) == null) continue;
            SegmentOraclev9i indexSegment = (SegmentOraclev9i)lip.getSegment();
            if (indexSegment != null) {
                this.appendSegment(buffer, indexSegment, prettyPrint);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                TableSpaceOraclev9i ts = (TableSpaceOraclev9i)lip.getTableSpace();
                if (ts != null) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                String logging = lip.getLogging();
                if ("YES".equalsIgnoreCase(logging)) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(logging)) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
            String tablespaceIDs = lip.getHashSubPartitionsTableSpaces();
            this.appendIndexSubPartitions(buffer, indexProxy, partitionList, partition, tablespaceIDs, prettyPrint);
        }
        if (!first) {
            buffer.append(NEWLINE).append("    ").append(')');
        }
    }

    private void appendPartitions(StringBuffer buffer, BitmapJoinIndexOraclev9i indexProxy, PartitionListOraclev9i partitionList, boolean composite, boolean prettyPrint) {
        PartitionSetOracle partitionSet = ((StorageDesignOracle)partitionList.getStorageDesign()).getPartitionSet();
        Object[] partitionsList = partitionSet.toArray();
        Arrays.sort(partitionsList, new PossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < partitionsList.length; ++i) {
            sortedList.add(partitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            LocalIndexProperties lip;
            PartitionOraclev9i partition = (PartitionOraclev9i)setIt.next();
            if (partition.getPartitionList() == null || !partition.getPartitionList().toString().equalsIgnoreCase(partitionList.toString())) continue;
            if (first) {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                buffer.append(',');
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            if ((lip = this.getPropsForIndex(indexProxy, partition)) == null) continue;
            SegmentOraclev9i indexSegment = (SegmentOraclev9i)lip.getSegment();
            if (indexSegment != null) {
                this.appendSegment(buffer, indexSegment, prettyPrint);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                TableSpaceOraclev9i ts = (TableSpaceOraclev9i)lip.getTableSpace();
                if (ts != null) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                String logging = lip.getLogging();
                if ("YES".equalsIgnoreCase(logging)) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(logging)) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
            if (!composite) continue;
            String tablespaceIDs = lip.getHashSubPartitionsTableSpaces();
            this.appendIndexSubPartitions(buffer, indexProxy, partitionList, partition, tablespaceIDs, prettyPrint);
        }
        if (!first) {
            buffer.append(NEWLINE).append("    ").append(')');
        }
    }

    private LocalIndexProperties getPropsForIndex(BitmapJoinIndexOraclev9i indexProxy, PartitionOracle partition) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partition, indexProxy);
    }

    private LocalIndexProperties getPropsForIndex(BitmapJoinIndexOraclev9i indexProxy, HashPartitionOraclev9i partition) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partition, indexProxy);
    }

    private LocalIndexProperties getPropsForIndex(BitmapJoinIndexOraclev9i indexProxy, ListPartitionOraclev9i partition) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partition, indexProxy);
    }

    public static String getFirstToken(String string) {
        StringTokenizer tokens = new StringTokenizer(string, ",");
        String first = " ";
        if (tokens.hasMoreTokens()) {
            first = tokens.nextToken().trim();
        }
        return first.trim();
    }

    private void appendIndexSubPartitions(StringBuffer buffer, BitmapJoinIndexOraclev9i index, PartitionListOraclev9i partitionList, PartitionOraclev9i partition, String tablespaceIDs, boolean prettyPrint) {
        String partType = partitionList.getPartitionType();
        if (partType.equalsIgnoreCase("COMPOSITE BY HASH")) {
            if (!this.appendHashSubPartitions(buffer, index, partition, prettyPrint) && !"".equalsIgnoreCase(tablespaceIDs.trim())) {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(tablespaceIDs));
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ')');
            }
        } else if (partType.equalsIgnoreCase("COMPOSITE BY LIST")) {
            this.appendListSubPartitions(buffer, partition);
        }
    }

    private boolean appendListSubPartitions(StringBuffer buffer, PartitionOraclev9i partition) {
        boolean result = false;
        ListStorageTemplatePartitionSetOraclev9i listPartitionSet = (ListStorageTemplatePartitionSetOraclev9i)((StorageDesignOraclev9i)partition.getStorageDesign()).getListStorageTemplatePartitionSet();
        Iterator setIt = listPartitionSet.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            ListStorageTemplatePartitionOraclev9i listPartition = (ListStorageTemplatePartitionOraclev9i)setIt.next();
            if (listPartition.getSubPartitionOf() == null || !listPartition.getSubPartitionOf().toString().equalsIgnoreCase(partition.toString())) continue;
            if (first) {
                buffer.append(NEWLINE).append("    ");
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
                result = true;
            } else {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ',');
                buffer.append(NEWLINE).append("    ");
            }
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
            if (!listPartition.getName().toUpperCase().startsWith("SYS_")) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(listPartition));
            }
            if (listPartition.getTablespace() == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(listPartition.getTablespace()));
        }
        if (!first) {
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private boolean appendHashSubPartitions(StringBuffer buffer, BitmapJoinIndexOraclev9i indexProxy, PartitionOraclev9i partition, boolean prettyPrint) {
        boolean result = false;
        HashPartitionSetOraclev9i hashPartitionSet = (HashPartitionSetOraclev9i)((StorageDesignOraclev9i)partition.getStorageDesign()).getHashPartitionSet();
        Iterator setIt = hashPartitionSet.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            TableSpaceOraclev9i ts;
            LocalIndexProperties lip;
            HashPartitionOraclev9i hashPartition = (HashPartitionOraclev9i)setIt.next();
            if (hashPartition.getSubPartitionOf() != partition) continue;
            if (first) {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
                result = true;
            } else {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ',');
            }
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if ((lip = this.getPropsForIndex(indexProxy, partition)) == null || (ts = (TableSpaceOraclev9i)lip.getTableSpace()) == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
        }
        if (!first) {
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            buffer.append(')');
        }
        return result;
    }

    private void appendSegment(StringBuffer buffer, SegmentOracle segment, boolean prettyPrint) {
        if (segment != null && segment.isMarkedGenerate() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                buffer.append("PCTFREE ").append(segment.getPCTFree());
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 2) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    buffer.append("INITRANS ").append(segment.getInitrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "INITRANS");
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "2");
                }
                if (segment.getMaxTrans() > 2) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    buffer.append("MAXTRANS ").append(segment.getMaxTrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    buffer.append("MAXTRANS 255").append(segment.getMaxTrans());
                }
            }
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            buffer.append(" STORAGE (");
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
            boolean props = false;
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                buffer.append("INITIAL ").append(segment.getSCInitialExtent());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                buffer.append("NEXT ").append(segment.getSCNextExtent());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                buffer.append("PCTINCREASE ").append(segment.getSCPctIncrease());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                buffer.append("MINEXTENTS ").append(segment.getSCMinExtents());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                buffer.append("MAXEXTENTS ").append(segment.getSCMaxExtents());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                buffer.append("FREELISTS ").append(segment.getSCFreeLists());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                buffer.append("FREELIST GROUPS ").append(segment.getSCFreelistGroups());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                buffer.append("BUFFER_POOL ").append(segment.getSCBufferPool());
                props = true;
            }
            if (props) {
                buffer.append(')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf(" STORAGE ("), buffer.length(), "");
            }
        }
    }

    private void appendIndexAttributes(StringBuffer buffer, BitmapJoinIndexOraclev9i indexProxy, boolean prettyPrint) {
        String tablespace = indexProxy.getTablespace();
        if (tablespace != null && !tablespace.equals("") && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            if ("DEFAULT".equalsIgnoreCase(tablespace)) {
                if ("YES".equalsIgnoreCase(indexProxy.getLocalPartitioning())) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
                }
            } else {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tablespace));
            }
        }
        this.appendSegment(buffer, indexProxy.getSegment(), prettyPrint);
        if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
            if ("YES".equalsIgnoreCase(indexProxy.getLogging())) {
                buffer.append(NEWLINE).append("    ");
                buffer.append("LOGGING");
            } else if ("NO".equalsIgnoreCase(indexProxy.getLogging())) {
                buffer.append(NEWLINE).append("    ");
                buffer.append("NOLOGGING");
            }
        }
        if ("YES".equalsIgnoreCase(indexProxy.getOnline())) {
            buffer.append(NEWLINE).append("    ");
            buffer.append("ONLINE");
        }
        if ("YES".equalsIgnoreCase(indexProxy.getComputeStatistics())) {
            buffer.append(NEWLINE).append("    ");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
        }
        buffer.append(NEWLINE).append("    ");
        if (indexProxy.getCompress() > 0) {
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "COMPRESS");
            this.appendStringWithSpace(buffer, indexProxy.getCompress());
        } else {
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        buffer.append(NEWLINE).append("    ");
        if ("YES".equalsIgnoreCase(indexProxy.getParallel())) {
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "PARALLEL");
            if (!"".equalsIgnoreCase(indexProxy.getDegree())) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, indexProxy.getDegree());
            }
        } else {
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "NOPARALLEL");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof BitmapJoinIndexOraclev9i && ((BitmapJoinIndexOraclev9i)object).isMarkedGenerate();
    }

    public void doAppendBJIndex(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        this.doAppend(oldbuffer, object, prettyPrint);
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOracle)one).getPosition() > ((PartitionOracle)two).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)one).getPosition() < ((PartitionOracle)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

