/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DirectoryOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBDirectoryOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        DirectoryOraclev9i dir = (DirectoryOraclev9i)object;
        this.storageDesign = dir.getStorageDesign();
        this.appendComment(oldbuffer, dir);
        this.appendCreateDir(buffer, dir);
        advancedComment = buffer.toString();
        this.appendDirPath(buffer, dir, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBDirectoryOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        SSBDirectoryOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendPermissions(oldbuffer, dir);
        DDLFileMaker.incrementCreateDirectory();
    }

    private void appendCreateDir(StringBuffer buffer, DirectoryOraclev9i dir) {
        this.appendCreateOrReplace(buffer);
        SSBDirectoryOraclev9i.appendStringWithSpace(buffer, "DIRECTORY");
        SSBDirectoryOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(dir));
    }

    private void appendDirPath(StringBuffer buffer, DirectoryOraclev9i dir, boolean prettyPrint) {
        String dirPath = dir.getDirPath();
        SSBDirectoryOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBDirectoryOraclev9i.appendStringWithSpace(buffer, "AS");
        SSBDirectoryOraclev9i.appendString(buffer, '\'');
        SSBDirectoryOraclev9i.appendString(buffer, dirPath);
        SSBDirectoryOraclev9i.appendStringWithSpace(buffer, '\'');
        if (dirPath == null || dirPath.equals("")) {
            SSBDirectoryOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBDirectoryOraclev9i.appendString(buffer, "--  ERROR: No Path name specified");
            DDLFileMaker.incrementErrors();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DirectoryOraclev9i && ((DirectoryOraclev9i)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer oldBuffer, DirectoryOracle directoryOracle) {
        StorageDesignOracle storageDesignOracle = directoryOracle.getStorageDesignOracle();
        StringBuffer buffer = new StringBuffer();
        PermissionsSetOracle permissionsSet = storageDesignOracle.getPermissionsSet();
        Iterator it = permissionsSet.iterator();
        while (it.hasNext()) {
            PermissionsOracle permissions = (PermissionsOracle)it.next();
            if (!directoryOracle.equals(permissions.getDirectoryOracle()) || permissions.getUser() == null && permissions.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissions.getPrivileges())) {
                this.appendPrivileges(oldBuffer, buffer, permissions, directoryOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissions.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(oldBuffer, buffer, permissions, directoryOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer oldBuffer, StringBuffer buffer, PermissionsOracle permissions, DirectoryOracle directoryOracle, StorageDesignOracle storageDesignOracle, boolean withGrantOption) {
        buffer.append(NEWLINE);
        this.appendComment(buffer, permissions);
        SSBDirectoryOraclev9i.appendStringWithSpace(buffer, "GRANT");
        if (withGrantOption) {
            buffer.append(permissions.getPrivilegesWithGrantOption());
        } else {
            buffer.append(permissions.getPrivileges());
        }
        this.appendObject(buffer, directoryOracle, storageDesignOracle);
        this.appendTo(buffer, permissions, storageDesignOracle);
        if (withGrantOption) {
            this.appendGrantOption(buffer, permissions);
        }
        String advancedComment = buffer.toString();
        buffer.append(NEWLINE);
        buffer.append(';');
        buffer.append(NEWLINE);
        this.appendToBuffer(oldBuffer, buffer, advancedComment);
    }

    private void appendObject(StringBuffer buffer, DirectoryOracle directoryOracle, StorageDesign storageDesign) {
        buffer.append(NEWLINE);
        SSBDirectoryOraclev9i.appendStringWithSpace(buffer, "ON");
        SSBDirectoryOraclev9i.appendStringWithSpace(buffer, "DIRECTORY");
        SSBDirectoryOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedName(directoryOracle));
    }

    private void appendTo(StringBuffer buffer, PermissionsOracle privileges, StorageDesign storageDesign) {
        SSBDirectoryOraclev9i.appendStringWithSpace(buffer, "TO");
        if ("YES".equalsIgnoreCase(privileges.getPublic())) {
            SSBDirectoryOraclev9i.appendStringWithSpace(buffer, "PUBLIC");
        } else if (privileges.getUser() != null) {
            SSBDirectoryOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedName(privileges.getUser()));
        } else if (privileges.getRole() != null) {
            SSBDirectoryOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedName(privileges.getRole()));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOracle permissions) {
        if (permissions.getRole() == null) {
            SSBDirectoryOraclev9i.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }
}

