/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ExternalTableColumnOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ExternalTableOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBExternalTableOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        ExternalTableOraclev9i table = (ExternalTableOraclev9i)object;
        this.storageDesign = table.getStorageDesign();
        if (table.getColumns().size() != 0) {
            this.appendComment(oldbuffer, table);
            this.appendCreate(buffer, table);
            advancedComment = buffer.toString();
            this.appendElementList(buffer, table, prettyPrint);
            this.appendExternalTableClause(buffer, table, prettyPrint);
            this.appendRejectLimit(buffer, table, prettyPrint);
            this.appendParallel(buffer, table, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.appendPermissions(oldbuffer, table);
            DDLFileMaker.incrementCreateTable();
        } else {
            SSBExternalTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            oldbuffer.append("-- Error - External table ");
            oldbuffer.append(this.storageDesign.getFormatedName(table));
            oldbuffer.append(" has no columns");
            DDLFileMaker.incrementErrors();
            SSBExternalTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBExternalTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
        }
    }

    private void appendCreate(StringBuffer buffer, ExternalTableOraclev9i table) {
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "CREATE");
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "TABLE");
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(table));
    }

    private void appendElementList(StringBuffer buffer, ExternalTableOraclev9i table, boolean prettyPrint) {
        SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        StorageObjectCollection columns = table.getColumns();
        ExternalTableColumnOraclev9i column = null;
        for (int i = 0; i < columns.size(); ++i) {
            if (i == 0) {
                SSBExternalTableOraclev9i.appendStringWithSpace(buffer, '(');
                SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            } else {
                SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ',');
                SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            }
            column = (ExternalTableColumnOraclev9i)columns.getElement(i);
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(column));
            String colDatatype = column.getDatatype();
            if (colDatatype.startsWith("TIMESTAMP")) {
                SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "TIMESTAMP");
                if (column.getPrecision() > 0) {
                    buffer.append('(').append(column.getPrecision());
                    SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("6");
                    SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
                }
                if (colDatatype.indexOf("WITH") <= -1) continue;
                SSBExternalTableOraclev9i.appendStringWithSpace(buffer, colDatatype.substring(10));
                continue;
            }
            if (colDatatype.equalsIgnoreCase("INTERVAL YEAR TO MONTH")) {
                SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "INTERVAL YEAR");
                if (column.getPrecision() > 0) {
                    buffer.append('(').append(column.getPrecision());
                    SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("2");
                    SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
                }
                SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "TO MONTH");
                continue;
            }
            if (colDatatype.equalsIgnoreCase("INTERVAL DAY TO SECOND")) {
                SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "INTERVAL DAY");
                if (column.getPrecision() > 0) {
                    buffer.append('(').append(column.getPrecision());
                    SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("2");
                    SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
                }
                SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "TO SECOND");
                if (column.getScale() > 0) {
                    buffer.append('(').append(column.getScale());
                    SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if (!this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) continue;
                buffer.append('(').append("6");
                SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
                continue;
            }
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, colDatatype);
            if (colDatatype.indexOf("CHAR") > -1 || colDatatype.equals("RAW") || colDatatype.equals("UROWID")) {
                if (column.getSize() > 0) {
                    buffer.append('(').append(column.getSize());
                    if (!column.getUnits().equalsIgnoreCase("") && (colDatatype.equalsIgnoreCase("CHAR") || colDatatype.equalsIgnoreCase("VARCHAR2") || colDatatype.equalsIgnoreCase("VARCHAR"))) {
                        buffer.append(' ').append(column.getUnits());
                    }
                    SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if ((colDatatype.equals("CHAR") || colDatatype.equals("NCHAR")) && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("1");
                    SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if (!colDatatype.equals("UROWID") || !this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) continue;
                buffer.append('(').append("4000");
                SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
                continue;
            }
            if (column.getPrecision() <= 0) continue;
            buffer.append('(').append(column.getPrecision());
            if (column.getScale() != 0) {
                SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ',');
                buffer.append(column.getScale());
            }
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
        }
        SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
    }

    private void appendExternalTableClause(StringBuffer buffer, ExternalTableOraclev9i table, boolean prettyPrint) {
        SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "ORGANIZATION");
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "EXTERNAL");
        SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, '(');
        if (!"".equalsIgnoreCase(table.getAccessDriverType().trim())) {
            SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "TYPE");
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, table.getAccessDriverType());
        }
        if (table.getDefaultDir() != null) {
            SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "DIRECTORY");
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(table.getDefaultDir()));
        }
        if (table.getAccessParametersType().equalsIgnoreCase("Opaque Format Spec")) {
            SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "ACCESS");
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "PARAMETERS");
            SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, table.getOpaqueFormatSpec());
            SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
        } else if (table.getAccessParametersType().equalsIgnoreCase("CLOB Subquery")) {
            SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "ACCESS");
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "PARAMETERS");
            SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "USING");
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "CLOB");
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, table.getClobSubquery());
        }
        SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "LOCATION");
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, '(');
        if (!table.getLocation().startsWith("'")) {
            SSBExternalTableOraclev9i.appendString(buffer, '\'');
        }
        SSBExternalTableOraclev9i.appendString(buffer, table.getLocation());
        if (!table.getLocation().endsWith("'")) {
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, '\'');
        }
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
        SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, ')');
    }

    private void appendParallel(StringBuffer buffer, ExternalTableOraclev9i table, boolean prettyPrint) {
        if (table.getParallel().equalsIgnoreCase("PARALLEL")) {
            SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "PARALLEL");
            int parallelNum = table.getParallelNum();
            if (parallelNum > 0) {
                this.appendStringWithSpace(buffer, parallelNum);
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "NOPARALLEL");
        }
    }

    private void appendRejectLimit(StringBuffer buffer, ExternalTableOraclev9i table, boolean prettyPrint) {
        String rejectLimit = table.getRejectLimit();
        if (rejectLimit.length() > 0) {
            SSBExternalTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "REJECT");
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "LIMIT");
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, rejectLimit);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof ExternalTableOraclev9i && ((ExternalTableOraclev9i)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer oldBuffer, ExternalTableOracle externalTableOracle) {
        StorageDesignOracle storageDesignOracle = externalTableOracle.getStorageDesignOracle();
        StringBuffer buffer = new StringBuffer();
        PermissionsSetOracle permissionsSet = storageDesignOracle.getPermissionsSet();
        Iterator it = permissionsSet.iterator();
        while (it.hasNext()) {
            PermissionsOracle permissions = (PermissionsOracle)it.next();
            if (!externalTableOracle.equals(permissions.getExternalTableOracle()) || permissions.getUser() == null && permissions.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissions.getPrivileges())) {
                this.appendPrivileges(oldBuffer, buffer, permissions, externalTableOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissions.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(oldBuffer, buffer, permissions, externalTableOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer oldBuffer, StringBuffer buffer, PermissionsOracle permissions, ExternalTableOracle externalTableOracle, StorageDesignOracle storageDesignOracle, boolean withGrantOption) {
        buffer.append(NEWLINE);
        this.appendComment(buffer, permissions);
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "GRANT");
        if (withGrantOption) {
            buffer.append(permissions.getPrivilegesWithGrantOption());
        } else {
            buffer.append(permissions.getPrivileges());
        }
        this.appendObject(buffer, externalTableOracle, storageDesignOracle);
        this.appendTo(buffer, permissions, storageDesignOracle);
        if (withGrantOption) {
            this.appendGrantOption(buffer, permissions);
        }
        String advancedComment = buffer.toString();
        buffer.append(NEWLINE);
        buffer.append(';');
        buffer.append(NEWLINE);
        this.appendToBuffer(oldBuffer, buffer, advancedComment);
    }

    private void appendObject(StringBuffer buffer, ExternalTableOracle externalTableOracle, StorageDesign storageDesign) {
        buffer.append(NEWLINE);
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "ON");
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(externalTableOracle));
    }

    private void appendTo(StringBuffer buffer, PermissionsOracle privileges, StorageDesign storageDesign) {
        SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "TO");
        if ("YES".equalsIgnoreCase(privileges.getPublic())) {
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "PUBLIC");
        } else if (privileges.getUser() != null) {
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedName(privileges.getUser()));
        } else if (privileges.getRole() != null) {
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedName(privileges.getRole()));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOracle permissions) {
        if (permissions.getRole() == null) {
            SSBExternalTableOraclev9i.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }
}

